/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate.converters;

import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.jpa.model.xml.GenericNamedValueConvertersRegistry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.model.converters.CustomConverterRegistry;
import com.intellij.spring.model.converters.PropertyKeyConverter;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.Props;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.persistence.integration.hibernate.HibernateIntegrationUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HibernatePropertyNameConverter
extends ResolvingConverter<String>
implements CustomConverterRegistry.Provider {
    @NonNls
    private static final String HIBERNATE_PROPERTIES = "hibernateProperties";

    HibernatePropertyNameConverter() {
    }

    @NotNull
    public Collection<String> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            HibernatePropertyNameConverter.$$$reportNull$$$0(0);
        }
        Map converters = GenericNamedValueConvertersRegistry.getConverters(Property.class);
        List<String> definedProperties = HibernatePropertyNameConverter.getDefinedPropertyKeys(context);
        Set<String> allPropertyNames = converters.keySet();
        allPropertyNames.removeAll(definedProperties);
        Set<String> set = allPropertyNames;
        if (set == null) {
            HibernatePropertyNameConverter.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public Converter getConverter() {
        return this;
    }

    @Override
    public Class getConverterClass() {
        return PropertyKeyConverter.class;
    }

    private static List<String> getDefinedPropertyKeys(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        return HibernatePropertyNameConverter.getKeys(element);
    }

    public static List<String> getKeys(DomElement element) {
        ArrayList<String> keys = new ArrayList<String>();
        Props props = (Props)element.getParentOfType(Props.class, false);
        if (props != null) {
            for (Prop prop : props.getProps()) {
                String value = prop.getKey().getStringValue();
                if (!StringUtil.isNotEmpty((String)value)) continue;
                keys.add(value);
            }
        }
        return keys;
    }

    public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            HibernatePropertyNameConverter.$$$reportNull$$$0(2);
        }
        return s;
    }

    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            HibernatePropertyNameConverter.$$$reportNull$$$0(3);
        }
        return s;
    }

    public boolean value(GenericDomValue domValue) {
        SpringProperty springProperty = (SpringProperty)domValue.getParentOfType(SpringProperty.class, false);
        return springProperty != null && HIBERNATE_PROPERTIES.equals(springProperty.getName().getStringValue()) && HibernateIntegrationUtil.isSessionFactoryBean((SpringBean)springProperty.getParentOfType(SpringBean.class, false), false, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/persistence/integration/hibernate/converters/HibernatePropertyNameConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/persistence/integration/hibernate/converters/HibernatePropertyNameConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

