/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.profiles.SpringProfileTarget;
import com.intellij.spring.profiles.SpringProfilesFactory;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class SpringProfileCompletionProvider
extends TextFieldWithAutoCompletionListProvider<String> {
    private final boolean myIncludeTests;
    private final Map<Module, Collection<String>> myProfiles = FactoryMap.create(this::getProfiles);
    private Collection<Module> myContext = Collections.emptyList();

    public SpringProfileCompletionProvider(boolean includeTests) {
        super(null);
        this.myIncludeTests = includeTests;
    }

    public void setContext(@NotNull Collection<Module> modules) {
        if (modules == null) {
            SpringProfileCompletionProvider.$$$reportNull$$$0(0);
        }
        this.myContext = modules;
    }

    @NotNull
    protected String getLookupString(@NotNull String item) {
        if (item == null) {
            SpringProfileCompletionProvider.$$$reportNull$$$0(1);
        }
        String string = item;
        if (string == null) {
            SpringProfileCompletionProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected Icon getIcon(@NotNull String item) {
        if (item == null) {
            SpringProfileCompletionProvider.$$$reportNull$$$0(3);
        }
        return SpringApiIcons.SpringProfile;
    }

    @NotNull
    public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        if (prefix == null || this.myContext.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SpringProfileCompletionProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        String text = SpringProfileCompletionProvider.filterOutCompletingProfile(parameters.getEditor().getDocument().getText(), parameters.getOffset());
        Set<String> activatedProfiles = SpringProfileUtils.profilesFromString(text);
        HashSet<String> profiles = new HashSet<String>();
        for (Module module : this.myContext) {
            profiles.addAll(this.myProfiles.get(module));
        }
        profiles.removeAll(activatedProfiles);
        profiles.remove("_DEFAULT_PROFILE_NAME_");
        ArrayList<String> result2 = new ArrayList<String>(profiles);
        result2.sort(StringUtil::naturalCompare);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SpringProfileCompletionProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public String getPrefix(@NotNull String text, int offset) {
        if (text == null) {
            SpringProfileCompletionProvider.$$$reportNull$$$0(6);
        }
        int space = text.lastIndexOf(32, offset - 1) + 1;
        int comma = text.lastIndexOf(44, offset - 1) + 1;
        return text.substring(Math.max(space, comma), offset);
    }

    private @Unmodifiable Collection<String> getProfiles(Module module) {
        return (Collection)ApplicationManager.getApplication().runReadAction(() -> {
            List<SpringProfileTarget> targets = SpringProfilesFactory.getInstance().findProfileTargets(module, this.myIncludeTests);
            return ContainerUtil.map2Set(targets, SpringProfileTarget::getName);
        });
    }

    private static String filterOutCompletingProfile(String text, int offset) {
        int after;
        int space = text.lastIndexOf(32, offset - 1) + 1;
        int comma = text.lastIndexOf(44, offset - 1) + 1;
        int before = Math.max(space, comma);
        Object result2 = text.substring(0, before);
        space = text.indexOf(32, offset);
        comma = text.indexOf(44, offset);
        int n = space < 0 ? comma : (after = comma < 0 ? space : Math.min(space, comma));
        if (after >= 0) {
            result2 = (String)result2 + text.substring(after);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringProfileCompletionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringProfileCompletionProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLookupString";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

