/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.profiles.SpringProfilesService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="SpringProfilesService", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0017B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/spring/profiles/SpringProfilesServiceImpl;", "Lcom/intellij/spring/profiles/SpringProfilesService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/spring/profiles/SpringProfilesServiceImpl$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "activeProfiles", "", "Lcom/intellij/openapi/module/ModulePointer;", "", "", "setActiveProfiles", "", "module", "Lcom/intellij/openapi/module/Module;", "getActiveProfiles", "getState", "loadState", "state", "State", "intellij.spring.core"})
public final class SpringProfilesServiceImpl
implements SpringProfilesService,
PersistentStateComponent<State> {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<ModulePointer, Set<String>> activeProfiles;

    public SpringProfilesServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.activeProfiles = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void setActiveProfiles(@NotNull Module module, @NotNull Set<String> activeProfiles) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(activeProfiles, (String)"activeProfiles");
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        Intrinsics.checkNotNullExpressionValue((Object)modulePointer, (String)"create(...)");
        ModulePointer modulePointer2 = modulePointer;
        if (activeProfiles.isEmpty()) {
            this.activeProfiles.remove(modulePointer2);
        } else {
            this.activeProfiles.put(modulePointer2, activeProfiles);
        }
    }

    @Override
    @NotNull
    public Set<String> getActiveProfiles(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Set set = this.activeProfiles.get(ModulePointerManager.getInstance((Project)module.getProject()).create(module));
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public State getState() {
        State state = new State();
        for (Map.Entry<ModulePointer, Set<String>> entry : this.activeProfiles.entrySet()) {
            state.getActiveProfiles().put(entry.getKey().getModuleName(), SpringProfileUtils.profilesAsString(entry.getValue()));
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (state.getActiveProfiles().isEmpty()) {
            return;
        }
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)this.project);
        for (Map.Entry<String, String> entry : state.getActiveProfiles().entrySet()) {
            ModulePointer modulePointer;
            Intrinsics.checkNotNullExpressionValue((Object)pointerManager.create(entry.getKey()), (String)"create(...)");
            if (modulePointer.getModule() == null) continue;
            this.activeProfiles.put(modulePointer, SpringProfileUtils.profilesFromString(entry.getValue()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003RC\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/profiles/SpringProfilesServiceImpl$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "", "", "activeProfiles", "getActiveProfiles", "()Ljava/util/Map;", "setActiveProfiles", "(Ljava/util/Map;)V", "activeProfiles$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.spring.core"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty activeProfiles$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        @NotNull
        public final Map<String, String> getActiveProfiles() {
            return (Map)this.activeProfiles$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setActiveProfiles(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.activeProfiles$delegate.setValue((Object)this, $$delegatedProperties[0], map);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "activeProfiles", "getActiveProfiles()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

