/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

final class SpringAnnotationReferenceContributor
extends PsiReferenceContributor {
    SpringAnnotationReferenceContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringAnnotationReferenceContributor.$$$reportNull$$$0(0);
        }
        SpringAnnotationReferenceContributor.registerPsiClassReferences(registrar);
        SpringAnnotationReferenceContributor.registerAnnoReferenceProviders(registrar);
    }

    private static void registerAnnoReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("org.springframework.scheduling.annotation.Async"), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof PsiLiteralExpression)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiClass executorClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass("java.util.concurrent.Executor", element.getResolveScope());
                PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference(element, ElementManipulators.getValueTextRange((PsiElement)element), executorClass, false)};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/references/SpringAnnotationReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/references/SpringAnnotationReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }, 100.0);
    }

    private static void registerPsiClassReferences(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringAnnotationReferenceContributor.$$$reportNull$$$0(1);
        }
        PsiJavaElementPattern.Capture newExpressionCapture = PsiJavaPatterns.psiNewExpression((String[])new String[]{"org.springframework.context.support.ClassPathXmlApplicationContext", "org.springframework.core.io.ClassPathResource"});
        PsiJavaElementPattern.Capture capture = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().andOr(new ElementPattern[]{PsiJavaPatterns.psiExpression().withSuperParent(2, (ElementPattern)newExpressionCapture), PsiJavaPatterns.psiExpression().withSuperParent(4, (ElementPattern)newExpressionCapture)});
        registrar.registerReferenceProvider((ElementPattern)capture, (PsiReferenceProvider)new ClassPathResourceReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam((ElementPattern)PsiJavaPatterns.psiAnnotation().qName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"org.springframework.beans.factory.annotation.Value"}))), (PsiReferenceProvider)new ClassPathResourceReferenceProvider(), 100.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "registrar";
        objectArray2[1] = "com/intellij/spring/references/SpringAnnotationReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerPsiClassReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClassPathResourceReferenceProvider
    extends PsiReferenceProvider {
        private ClassPathResourceReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                ClassPathResourceReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ClassPathResourceReferenceProvider.$$$reportNull$$$0(1);
            }
            String s = ElementManipulators.getValueText((PsiElement)element);
            PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getClassPathReferences(SpringResourcesBuilder.create(element, s).fromRoot(s.startsWith("/")).soft(true));
            if (psiReferenceArray == null) {
                ClassPathResourceReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/references/SpringAnnotationReferenceContributor$ClassPathResourceReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/references/SpringAnnotationReferenceContributor$ClassPathResourceReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

