/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi;

import com.google.common.primitives.UnsignedLong;
import com.intellij.protobuf.lang.psi.ProtoLiteral;
import com.intellij.protobuf.lang.psi.ProtoNumberValueUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public interface ProtoNumberValue
extends ProtoLiteral {
    public PsiElement getNumberElement();

    @Nullable
    public SourceType getSourceType();

    @Nullable
    default public IntegerFormat getIntegerFormat() {
        if (this.getSourceType() == SourceType.INTEGER) {
            PsiElement numberElement = this.getNumberElement();
            if (numberElement == null) {
                return null;
            }
            String numberText = numberElement.getText();
            int radix = ProtoNumberValueUtil.getRadix(numberText);
            return switch (radix) {
                case 8 -> IntegerFormat.OCT;
                case 10 -> IntegerFormat.DEC;
                case 16 -> IntegerFormat.HEX;
                default -> null;
            };
        }
        return null;
    }

    public boolean isNegative();

    @Override
    @Nullable
    default public Object getValue() {
        return this.getNumber();
    }

    @Nullable
    default public Long getLongValue() {
        PsiElement numberElement = this.getNumberElement();
        if (numberElement == null) {
            return null;
        }
        if (this.getSourceType() == SourceType.INTEGER) {
            String numberText = numberElement.getText();
            String negativePrefix = this.isNegative() ? "-" : "";
            int radix = ProtoNumberValueUtil.getRadix(numberText);
            numberText = ProtoNumberValueUtil.trimRadixPrefix(numberText, radix);
            try {
                return Long.parseLong(negativePrefix + numberText, radix);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    default public UnsignedLong getUnsignedLongValue() {
        if (this.isNegative()) {
            return null;
        }
        return this.getUnsignedLongComponent();
    }

    @Nullable
    default public UnsignedLong getUnsignedLongComponent() {
        PsiElement numberElement = this.getNumberElement();
        if (numberElement == null) {
            return null;
        }
        if (this.getSourceType() == SourceType.INTEGER) {
            String numberText = numberElement.getText();
            int radix = ProtoNumberValueUtil.getRadix(numberText);
            numberText = ProtoNumberValueUtil.trimRadixPrefix(numberText, radix);
            try {
                return UnsignedLong.valueOf((String)numberText, (int)radix);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    default public Double getDoubleValue() {
        SourceType sourceType = this.getSourceType();
        if (sourceType == null) {
            return null;
        }
        return switch (sourceType) {
            case SourceType.FLOAT -> {
                PsiElement numberElement = this.getNumberElement();
                if (numberElement == null) {
                    Object var2_3 = null;
                    yield var2_3;
                }
                String numberText = numberElement.getText();
                String negativePrefix = this.isNegative() ? "-" : "";
                try {
                    Double var2_4;
                    yield var2_4 = Double.valueOf(Double.parseDouble(negativePrefix + numberText));
                }
                catch (NumberFormatException e) {
                    Object var2_5 = null;
                    yield var2_5;
                }
            }
            case SourceType.INF -> {
                Double var2_6;
                yield var2_6 = Double.valueOf(this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            case SourceType.NAN -> {
                Double var2_7;
                yield var2_7 = Double.valueOf(Double.NaN);
            }
            default -> {
                Double var2_8;
                yield var2_8 = null;
            }
        };
    }

    @Nullable
    default public Number getNumber() {
        SourceType sourceType = this.getSourceType();
        if (sourceType != null) {
            return switch (this.getSourceType()) {
                default -> throw new IncompatibleClassChangeError();
                case SourceType.FLOAT, SourceType.INF, SourceType.NAN -> this.getDoubleValue();
                case SourceType.INTEGER -> {
                    Long longValue = this.getLongValue();
                    if (longValue != null) {
                        yield longValue;
                    }
                    yield this.getUnsignedLongValue();
                }
            };
        }
        return null;
    }

    default public boolean isValidDouble() {
        return this.getDoubleValue() != null;
    }

    default public boolean isValidInt32() {
        Long value = this.getLongValue();
        return value != null && value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    default public boolean isValidUint32() {
        if (this.isNegative()) {
            return false;
        }
        Long value = this.getLongValue();
        return value != null && value >= 0L && value <= 0xFFFFFFFFL;
    }

    default public boolean isValidInt64() {
        return this.getLongValue() != null;
    }

    default public boolean isValidUint64() {
        return this.getUnsignedLongValue() != null;
    }

    default public boolean isValidInt65() {
        return this.getUnsignedLongComponent() != null;
    }

    public static enum SourceType {
        INTEGER,
        FLOAT,
        INF,
        NAN;

    }

    public static enum IntegerFormat {
        OCT,
        DEC,
        HEX;

    }
}

