/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.introspector.MsRoutineTypes;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsFileGroup;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsPartition;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.dialects.mssql.model.MsSecurityPredicate;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsView;
import com.intellij.database.dialects.mssql.model.properties.MsLedgerKind;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.dialects.mssql.model.properties.MsTemporalTableKind;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.GeneratedModelUtil;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsGeneratedModelUtil
extends GeneratedModelUtil {
    public static boolean getAutoCreated(@NotNull MsIndex element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(0);
        }
        MsTable table = element.getTable();
        return element.isNameSurrogate() && table != null && MsGeneratedModelUtil.getAutoCreated(table);
    }

    public static boolean getAutoCreated(@NotNull MsView element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(1);
        }
        return element.isLedgerView() || element.isDroppedLedger();
    }

    public static boolean getAutoCreated(@NotNull MsTable element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(2);
        }
        return element.getTemporalKind() == MsTemporalTableKind.HISTORY_TABLE || element.getLedgerKind() == MsLedgerKind.HISTORY_TABLE || element.isDroppedLedger();
    }

    public static boolean getAutoCreated(@NotNull MsFileGroup element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(3);
        }
        return element.isSystem() || element.getName().equals("PRIMARY");
    }

    public static boolean getAutoCreated(@NotNull MsPartition element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(4);
        }
        return true;
    }

    public static boolean isElementSurrogate(@NotNull MsTable element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(5);
        }
        return element.isNameSurrogate() || element.isDroppedLedger();
    }

    public static boolean isElementSurrogate(@NotNull MsView element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(6);
        }
        return element.isNameSurrogate() || element.isDroppedLedger();
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull MsSequence element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)MsGeneratedModelUtil.resolveType(element));
        if (list == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private static MsAliasType resolveType(@NotNull MsSequence sequence) {
        if (sequence == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(9);
        }
        return MsGeneratedModelUtil.resolveType(sequence.getDasType(), sequence.getSchema());
    }

    @Nullable
    public static MsAliasType resolveType(@NotNull DasType dasType, @Nullable BasicSchema objectSchema) {
        BasicSchema targetSchema;
        if (dasType == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(10);
        }
        if (objectSchema == null) {
            return null;
        }
        String schemaName = DasTypeUtilsKt.getSchemaName(dasType);
        String typeName = DasTypeUtilsKt.getTypeName(dasType);
        BasicSchema basicSchema = targetSchema = schemaName == null ? objectSchema : objectSchema.getSibling(schemaName);
        if (!(targetSchema instanceof MsSchema)) {
            return null;
        }
        return (MsAliasType)((MsSchema)targetSchema).getAliasTypes().get(typeName);
    }

    public static void setSubstituted(@NotNull MsSchema nsp) {
        if (nsp == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(11);
        }
        MsGeneratedModelUtil.setSubstituted(nsp);
        nsp.setIntrospectionTimestamp(null);
        nsp.setDescriptionsCheckSum(0L);
        nsp.setAliasTypesCheckSum(0L);
        nsp.setTableTypesCheckSum(0L);
    }

    public static int getDisplayOrder(@NotNull MsLikeIndex e1, @NotNull MsLikeIndex e2) {
        if (e1 == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(12);
        }
        if (e2 == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(13);
        }
        return MsGeneratedModelUtil.getDisplayOrder(e1, e2);
    }

    public static int getDisplayOrder(@NotNull MsSecurityPredicate e1, @NotNull MsSecurityPredicate e2) {
        if (e1 == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(14);
        }
        if (e2 == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(15);
        }
        long id1 = e1.getObjectId();
        long id2 = e2.getObjectId();
        return Long.compare(id1, id2);
    }

    public static int getDisplayOrder(@NotNull MsPartition e1, @NotNull MsPartition e2) {
        if (e1 == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(16);
        }
        if (e2 == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(17);
        }
        short p1 = e1.getPosition();
        short p2 = e2.getPosition();
        return Short.compare(p1, p2);
    }

    @NotNull
    public static String getDisplayName(@NotNull MsIndex element) {
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(18);
        }
        if (element.isFulltext()) {
            return "fulltext";
        }
        String string = GeneratedModelUtil.getDisplayName(element);
        if (string == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String getDisplayName(@NotNull MsSecurityPredicate element) {
        String definition;
        if (element == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(20);
        }
        String string = StringUtil.isNotEmpty((String)(definition = element.getDefinition())) ? definition : GeneratedModelUtil.getDisplayName(element);
        if (string == null) {
            MsGeneratedModelUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static DasRoutine.Kind getRoutineKind(MsRoutine r) {
        MsRoutineType tp = r.getRoutineType();
        return MsRoutineTypes.MS_FUNCTION_TYPES.containsValue((Object)tp) ? DasRoutine.Kind.FUNCTION : (MsRoutineTypes.MS_PROCEDURE_TYPES.containsValue((Object)tp) ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.NONE);
    }

    public static void setRoutineKind(MsRoutine r, DasRoutine.Kind kind) {
        r.setRoutineType(kind == DasRoutine.Kind.FUNCTION ? MsRoutineType.SCALAR_FUN : (kind == DasRoutine.Kind.PROCEDURE ? MsRoutineType.PROC : MsRoutineType.CLR_PROC));
    }

    @Nullable
    public static String getDefaultExpression(MsStoredColumn col) {
        BasicReferenceInfo<? extends MsDefaultConstraint> ref = col.getDefaultConstraintRefInfo();
        if (ref == null) {
            return null;
        }
        MsDefaultConstraint constraint = ref.getTargetOrInlineData();
        if (constraint != null) {
            return constraint.getDefaultExpression();
        }
        return col.getDefaultConstraintRef() != null ? "" : null;
    }

    public static void setDefaultExpression(MsStoredColumn col, @Nullable String def) {
        String oldDef = MsGeneratedModelUtil.getDefaultExpression(col);
        if (Objects.equals(oldDef, def)) {
            return;
        }
        MsGeneratedModelUtil.storeDefaultExpression(col, def);
    }

    public static void setDefaultExpressionInline(MsStoredColumn col, @Nullable String def) {
        if (col.getDefaultConstraintRef() instanceof BasicInlineObjectReference && Objects.equals(MsGeneratedModelUtil.getDefaultExpression(col), def)) {
            return;
        }
        MsGeneratedModelUtil.storeDefaultExpression(col, def);
    }

    private static void storeDefaultExpression(MsStoredColumn col, @Nullable String def) {
        if (def == null) {
            col.setDefaultConstraintRef(null);
            return;
        }
        BasicMetaObject defMeta = BasicMetaUtils.findChild(col.getMetaObject().getParent(), ObjectKind.DEFAULT);
        if (defMeta == null) {
            return;
        }
        MsDefaultConstraint defaultConstraint = (MsDefaultConstraint)defMeta.newDataObject();
        defaultConstraint.setDefaultExpression(def);
        BasicDataObject.freeze(defaultConstraint);
        col.setDefaultConstraintRef(BasicInlineObjectReference.create(defaultConstraint));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/model/MsGeneratedModelUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/model/MsGeneratedModelUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isElementSurrogate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 8: 
            case 19: 
            case 21: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrder";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 19, 21 -> new IllegalStateException(string);
        };
    }
}

