/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.JavaCodeStyleMainPanel;
import com.intellij.application.options.JavaDocFormattingPanel;
import com.intellij.application.options.JavaIndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.frontback.impl.JavaFrontbackBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaPackageEntryTableAccessor;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.LocalTimeCounter;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JavaLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String GENERAL_CODE_SAMPLE = "public class Foo {\n  public int[] X = new int[]{1, 3, 5, 7, 9, 11};\n\n  public void foo(boolean a, int x, int y, int z) {\n    label1:\n    do {\n      try {\n        if (x > 0) {\n          int someVariable = a ? x : y;\n          int anotherVariable = a ? x : y;\n        }\n        else if (x < 0) {\n          int someVariable = (y + z);\n          someVariable = x = x + y;\n        }\n        else {\n          label2:\n          for (int i = 0; i < 5; i++) doSomething(i);\n        }\n        switch (a) {\n          case 0:\n            doCase0();\n            break;\n          default:\n            doDefault();\n        }\n      }\n      catch (Exception e) {\n        processException(e.getMessage(), x + y, z, a);\n      }\n      finally {\n        processFinally();\n      }\n    }\n    while (true);\n\n    if (2 < 3) return;\n    if (3 < 4) return;\n    do {\n      x++;\n    }\n    while (x < 10000);\n    while (x < 50000) x++;\n    for (int i = 0; i < 5; i++) System.out.println(i);\n  }\n\n  private class InnerClass implements I1, I2 {\n    public void bar() throws E1, E2 {\n    }\n  }\n}";
    private static final String BLANK_LINE_SAMPLE = "/*\n * This is a sample file.\n */\npackage com.intellij.samples;\n\nimport com.intellij.idea.Main;\n\nimport javax.swing.*;\nimport java.util.Vector;\nimport org.jetbrains.annotations.NotNull;\nimport org.jetbrains.annotations.Nullable;\n\npublic class Foo {\n  private int field1;\n  private int field2;\n\n  {\n      field1 = 2;\n  }\n\n  public void foo1() {\n      new Runnable() {\n          public void run() {\n          }\n      };\n  }\n\n  public class InnerClass {\n  }\n}\nclass AnotherClass {\n}\n\npublic class ClassWithAnnotatedFields {\n    @NotNull\n    public Boolean publicAnnotatedField = true;\n    public Boolean publicNonAnnotatedField = true;\n    @NotNull Boolean typeAnnotatedField = false;\n    @NotNull\n    private Boolean firstPrivateAnnotatedField = true;\n    @NotNull\n    private Boolean secondPrivateAnnotatedField = true;\n}\n\npublic record RecordWithAnnotatedComponents(@NotNull Double s, @Nullable String t, @NotNull Double w) {}\n\ninterface TestInterface {\n    int MAX = 10;\n    int MIN = 1;\n    void method1();\n    void method2();\n}";
    private static final String SPACING_SAMPLE = "@Annotation(param1 = \"value1\", param2 = \"value2\")\n@SuppressWarnings({\"ALL\"})\npublic class Foo<T extends Bar & Abba, U> {\n  int[] X = new int[]{1, 3, 5, 6, 7, 87, 1213, 2};\n  int[] empty = new int[]{};\n  public void foo(int x, int y) {\n    Runnable r = () -> {};\n    Runnable r1 = this :: bar;\n    for (int i = 0; i < x; i++) {\n      y += (y ^ 0x123) << 2;\n    }\n    for (int a: X) { System.out.print(a); }\n    do {\n      try(MyResource r1 = getResource(); MyResource r2 = null) {\n        if (0 < x && x < 10) {\n          while (x != y) {\n            x = f(x * 3 + 5);\n          }\n        }\n        else {\n          synchronized (this) {\n            switch (e.getCode()) {\n              //...\n            }\n          }\n        }\n      }\n      catch (MyException e) {\n      }\n      finally {\n        int[] arr = (int[])g(y);\n        x = y >= 0 ? arr[y] : -1;\n        Map<String, String> sMap = new HashMap<String, String>();\n        Bar.<String, Integer>mess(null);\n      }\n    }\n    while (true);\n    \n    switch (o) {\n      case Rec(String s, int i) r -> {}\n    }\n\n  }\n  void bar(){{return;}}\n}\nclass Bar {\n    static <U, T> U mess(T t) {\n        return null;\n    }\n}\ninterface Abba {}\npublic record Rec(String s, int i) {}\n\nclass SimpleClass {\n  class EmptyClass{}\n\n  void emptyMethod() {}\n\n  void complexMethodWithEmptyCodeBlocks() {\n      try {} catch (Exception e) {}\n      Runnable r = () -> {};\n  }\n\n  void oneLineMethod() {int x = 10;}\n\n  void complexMethodWithOneLineCodeBlocks() {\n      try {int x = 10;} catch (Exception e) {int y = 10;}\n\n      Runnable r = () -> {int z = 30;};\n  }\n}";
    @Language(value="JAVA")
    private static final String WRAPPING_CODE_SAMPLE = "/*\n * This is a sample file.\n */\n\npublic class ThisIsASampleClass extends C1 implements I1, I2, I3, I4, I5 {\n  private int f1 = 1;\n  private String field2 = \"\";\n  public void foo1(int i1, int i2, int i3, int i4, int i5, int i6, int i7) {}\n  public void fooNonEmptyBody() {int x = 1;}\n  public static void longerMethod() throws Exception1, Exception2, Exception3 {\n// todo something\n    int\ni = 0;\n    int[] a = new int[] {1, 2, 0x0052, 0x0053, 0x0054};\n    int[] empty = new int[] {};\n    int var1 = 1; int var2 = 2;\n    foo1(0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057);\n    int x = (3 + 4 + 5 + 6) * (7 + 8 + 9 + 10) * (11 + 12 + 13 + 14 + 0xFFFFFFFF);\n    String s1, s2, s3;\n    s1 = s2 = s3 = \"012345678901456\";\n    assert i + j + k + l + n+ m <= 2 : \"assert description\";    int y = 2 > 3 ? 7 + 8 + 9 : 11 + 12 + 13;\n    super.getFoo().foo().getBar().bar();\n\n    label:     if (2 < 3) {return;} else if (2 > 3) return; else return;\n    for (int i = 0; i < 0xFFFFFF; i += 2) System.out.println(i);\n    while (x < 50000) x++;\n    do x++; while (x < 10000);\n    switch (a) {\n    case 0: case 1:\ndoCase0(); break;\ncase 2: case 3: return;    default:\n      doDefault();\n    }\n    try (MyResource r1 = getResource(); MyResource r2 = null) {\n      doSomething();\n    } catch (Exception e) {\n      processException(e);\n    } finally {\n      processFinally();\n    }\n    do {\n        x--;\n    } while (x > 10); \n    try (MyResource r1 = getResource();\n      MyResource r2 = null) {\n      doSomething();\n    }\n    Runnable r = () -> {};\n  }\n    public static void test() \n        throws Exception { \n        foo.foo().bar(\"arg1\", \n                      \"arg2\"); \n        new Object() {};    } \n    class TestInnerClass {}\n    interface TestInnerInterface {}\n}\n\nenum Breed {\n    Dalmatian(), Labrador(), Dachshund()\n}\n\npublic record RecordWithAnnotatedComponents(@Annotation1 @Annotation2 String s, @Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") Integer t, @Annotation3(param1=\"value1\", param2=\"value2\") @Annotation1 Double u, @Annotation3(param1=\"value1\", param2=\"value2\") @Annotation5(param1=\"value1\", param2=\"value2\") Float w) {}\n\n@Annotation1 @Annotation2 @Annotation3(param1=\"value1\", param2=\"value2\") @Annotation4 class Foo {\n    @Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") public static void foo(){\n    }\n    @Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") public static int myFoo;\n    public void method(@Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") final int param){\n        @Annotation1 @Annotation3(param1=\"value1\", param2=\"value2\") final int localVariable;    }\n}";

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        if (settings == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (modelSettings == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return new CodeStyleAbstractConfigurable(settings, modelSettings, JavaLanguage.INSTANCE.getDisplayName()){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new JavaCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.java";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider$1", "createPanel"));
            }
        };
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return new JavaCodeStyleSettings(settings);
    }

    @NotNull
    public com.intellij.lang.Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return javaLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return SPACING_SAMPLE;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            return BLANK_LINE_SAMPLE;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return WRAPPING_CODE_SAMPLE;
        }
        return GENERAL_CODE_SAMPLE;
    }

    public int getRightMargin(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return 37;
        }
        return super.getRightMargin(settingsType);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showAllStandardOptions();
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACES_WITHIN_ANGLE_BRACKETS", JavaFrontbackBundle.message("code.style.settings.angle.spacing.brackets", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_AROUND_ANNOTATION_EQ", JavaFrontbackBundle.message("checkbox.spaces.around.annotation.eq", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_WITHIN_RECORD_HEADER", JavaFrontbackBundle.message("checkbox.spaces.record.header", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_WITHIN_DECONSTRUCTION_LIST", JavaFrontbackBundle.message("checkbox.spaces.within.deconstruction.list", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACES_INSIDE_BLOCK_BRACES_WHEN_BODY_IS_PRESENT", JavaFrontbackBundle.message("checkbox.spaces.inside.block.braces.when.body.is.present", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            String groupName = CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_ARGUMENTS;
            consumer.moveStandardOption("SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS", groupName);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_AFTER_CLOSING_ANGLE_BRACKET_IN_TYPE_ARGUMENT", JavaFrontbackBundle.message("code.style.settings.spacing.after.closing.angle.bracket", new Object[0]), groupName, new Object[0]);
            groupName = CodeStyleSettingsCustomizableOptions.getInstance().SPACES_IN_TYPE_PARAMETERS;
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_BEFORE_OPENING_ANGLE_BRACKET_IN_TYPE_PARAMETER", ApplicationBundle.message((String)"checkbox.spaces.before.opening.angle.bracket", (Object[])new Object[0]), groupName, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_AROUND_TYPE_BOUNDS_IN_TYPE_PARAMETERS", JavaFrontbackBundle.message("code.style.settings.spacing.around.type.bounds", new Object[0]), groupName, new Object[0]);
            groupName = CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER;
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_BEFORE_COLON_IN_FOREACH", JavaFrontbackBundle.message("checkbox.spaces.before.colon.in.foreach", new Object[0]), groupName, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_INSIDE_ONE_LINE_ENUM_BRACES", JavaFrontbackBundle.message("checkbox.spaces.inside.one.line.enum", new Object[0]), groupName, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "SPACE_BEFORE_DECONSTRUCTION_LIST", JavaFrontbackBundle.message("checkbox.spaces.before.deconstruction.list", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_CONTROL_STATEMENT_IN_ONE_LINE", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "CALL_PARAMETERS_WRAP", "PREFER_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "RESOURCE_LIST_WRAP", "RESOURCE_LIST_LPAREN_ON_NEXT_LINE", "RESOURCE_LIST_RPAREN_ON_NEXT_LINE", "EXTENDS_LIST_WRAP", "THROWS_LIST_WRAP", "EXTENDS_KEYWORD_WRAP", "THROWS_KEYWORD_WRAP", "METHOD_CALL_CHAIN_WRAP", "PARENTHESES_EXPRESSION_LPAREN_WRAP", "PARENTHESES_EXPRESSION_RPAREN_WRAP", "BINARY_OPERATION_WRAP", "BINARY_OPERATION_SIGN_ON_NEXT_LINE", "TERNARY_OPERATION_WRAP", "TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", "MODIFIER_LIST_WRAP", "KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE", "KEEP_SIMPLE_CLASSES_IN_ONE_LINE", "KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE", "FOR_STATEMENT_WRAP", "FOR_STATEMENT_LPAREN_ON_NEXT_LINE", "FOR_STATEMENT_RPAREN_ON_NEXT_LINE", "ARRAY_INITIALIZER_WRAP", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "ASSIGNMENT_WRAP", "PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", "LABELED_STATEMENT_WRAP", "ASSERT_STATEMENT_WRAP", "ASSERT_STATEMENT_COLON_ON_NEXT_LINE", "IF_BRACE_FORCE", "DOWHILE_BRACE_FORCE", "WHILE_BRACE_FORCE", "FOR_BRACE_FORCE", "WRAP_LONG_LINES", "METHOD_ANNOTATION_WRAP", "CLASS_ANNOTATION_WRAP", "FIELD_ANNOTATION_WRAP", "PARAMETER_ANNOTATION_WRAP", "VARIABLE_ANNOTATION_WRAP", "ALIGN_MULTILINE_CHAINED_METHODS", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "ALIGN_MULTILINE_RESOURCES", "ALIGN_MULTILINE_FOR", "INDENT_WHEN_CASES", "ALIGN_MULTILINE_BINARY_OPERATION", "ALIGN_MULTILINE_ASSIGNMENT", "ALIGN_MULTILINE_TERNARY_OPERATION", "ALIGN_MULTILINE_THROWS_LIST", "ALIGN_THROWS_KEYWORD", "ALIGN_MULTILINE_EXTENDS_LIST", "ALIGN_MULTILINE_METHOD_BRACKETS", "ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ALIGN_GROUP_FIELD_DECLARATIONS", "ALIGN_MULTILINE_TEXT_BLOCKS", "BRACE_STYLE", "CLASS_BRACE_STYLE", "METHOD_BRACE_STYLE", "LAMBDA_BRACE_STYLE", "USE_FLYING_GEESE_BRACES", "FLYING_GEESE_BRACES_GAP", "DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS", "ELSE_ON_NEW_LINE", "WHILE_ON_NEW_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "SWITCH_EXPRESSIONS_WRAP", "INDENT_CASE_FROM_SWITCH", "CASE_STATEMENT_ON_NEW_LINE", "SPECIAL_ELSE_IF_TREATMENT", "ENUM_CONSTANTS_WRAP", "ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS", "ALIGN_CONSECUTIVE_ASSIGNMENTS", "ALIGN_SUBSEQUENT_SIMPLE_METHODS", "WRAP_FIRST_METHOD_IN_CALL_CHAIN", "BUILDER_METHODS", "KEEP_BUILDER_METHODS_INDENTS"});
            consumer.showCustomOption(JavaCodeStyleSettings.class, "WRAP_SEMICOLON_AFTER_CALL_CHAIN", JavaFrontbackBundle.message("wrapping.semicolon.after.call.chain", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_CALL_CHAIN, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ENUM_FIELD_ANNOTATION_WRAP", JavaFrontbackBundle.message("wrapping.annotation.enums", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ANNOTATION_PARAMETER_WRAP", JavaFrontbackBundle.message("wrapping.annotation.parameters", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ALIGN_MULTILINE_ANNOTATION_PARAMETERS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0]), JavaFrontbackBundle.message("wrapping.annotation.parameters", new Object[0]), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "NEW_LINE_AFTER_LPAREN_IN_ANNOTATION", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0]), JavaFrontbackBundle.message("wrapping.annotation.parameters", new Object[0]), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "RPAREN_ON_NEW_LINE_IN_ANNOTATION", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]), JavaFrontbackBundle.message("wrapping.annotation.parameters", new Object[0]), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ALIGN_MULTILINE_TEXT_BLOCKS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0]), JavaFrontbackBundle.message("wrapping.text.blocks", new Object[0]), new Object[0]);
            String fieldAnnotations = ApplicationBundle.message((String)"wrapping.fields.annotation", (Object[])new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION", JavaFrontbackBundle.message("checkbox.do.not.wrap.after.single.annotation", new Object[0]), fieldAnnotations, new Object[0]);
            String parameterAnnotationsWrapping = ApplicationBundle.message((String)"wrapping.parameters.annotation", (Object[])new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION_IN_PARAMETER", JavaFrontbackBundle.message("checkbox.do.not.wrap.after.single.annotation", new Object[0]), parameterAnnotationsWrapping, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "NEW_LINE_WHEN_BODY_IS_PRESENTED", JavaFrontbackBundle.message("new.line.when.body.is.presented", new Object[0]), ApplicationBundle.message((String)"wrapping.method.parentheses", (Object[])new Object[0]), new Object[0]);
            String recordComponentsGroup = JavaFrontbackBundle.message("wrapping.record.components", new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "RECORD_COMPONENTS_WRAP", recordComponentsGroup, null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ALIGN_MULTILINE_RECORDS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0]), recordComponentsGroup, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "NEW_LINE_AFTER_LPAREN_IN_RECORD_HEADER", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0]), recordComponentsGroup, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "RPAREN_ON_NEW_LINE_IN_RECORD_HEADER", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]), recordComponentsGroup, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ANNOTATION_NEW_LINE_IN_RECORD_COMPONENT", JavaFrontbackBundle.message("annotations.new.line.record.component", new Object[0]), recordComponentsGroup, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "MULTI_CATCH_TYPES_WRAP", JavaFrontbackBundle.message("wrapping.multi.catch.types", new Object[0]), ApplicationBundle.message((String)"wrapping.try.statement", (Object[])new Object[0]), new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ALIGN_TYPES_IN_MULTI_CATCH", JavaFrontbackBundle.message("align.types.in.multi.catch", new Object[0]), ApplicationBundle.message((String)"wrapping.try.statement", (Object[])new Object[0]), new Object[0]);
            String deconstructionComponentsGroup = JavaFrontbackBundle.message("wrapping.deconstruction.patterns", new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "DECONSTRUCTION_LIST_WRAP", deconstructionComponentsGroup, null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(JavaCodeStyleSettings.class, "ALIGN_MULTILINE_DECONSTRUCTION_LIST_COMPONENTS", ApplicationBundle.message((String)"wrapping.align.when.multiline", (Object[])new Object[0]), deconstructionComponentsGroup, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "NEW_LINE_AFTER_LPAREN_IN_DECONSTRUCTION_PATTERN", ApplicationBundle.message((String)"wrapping.new.line.after.lpar", (Object[])new Object[0]), deconstructionComponentsGroup, new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "RPAREN_ON_NEW_LINE_IN_DECONSTRUCTION_PATTERN", ApplicationBundle.message((String)"wrapping.rpar.on.new.line", (Object[])new Object[0]), deconstructionComponentsGroup, new Object[0]);
            consumer.renameStandardOption("SWITCH_EXPRESSIONS_WRAP", JavaFrontbackBundle.message("wrapping.switch.statement.or.expression", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showAllStandardOptions();
            consumer.showCustomOption(JavaCodeStyleSettings.class, "BLANK_LINES_AROUND_INITIALIZER", JavaFrontbackBundle.message("editbox.blanklines.around.initializer", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
            consumer.renameStandardOption("BLANK_LINES_AROUND_FIELD_IN_INTERFACE", JavaFrontbackBundle.message("editbox.blank.lines.field.in.interface", new Object[0]));
            consumer.renameStandardOption("BLANK_LINES_AROUND_FIELD", JavaFrontbackBundle.message("editbox.blank.lines.field.without.annotations", new Object[0]));
            consumer.showCustomOption(JavaCodeStyleSettings.class, "BLANK_LINES_AROUND_FIELD_WITH_ANNOTATIONS", JavaFrontbackBundle.message("editbox.blank.lines.field.with.annotations", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "BLANK_LINES_AROUND_FIELD", new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "BLANK_LINES_BETWEEN_RECORD_COMPONENTS", JavaFrontbackBundle.message("editbox.blank.lines.record.components", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE", "LINE_COMMENT_ADD_SPACE_ON_REFORMAT", "LINE_COMMENT_AT_FIRST_COLUMN", "BLOCK_COMMENT_AT_FIRST_COLUMN", "BLOCK_COMMENT_ADD_SPACE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC) {
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_ALIGN_PARAM_COMMENTS", JavaFrontbackBundle.message("checkbox.align.parameter.descriptions", new Object[0]), JavaDocFormattingPanel.getAlignmentGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_ALIGN_EXCEPTION_COMMENTS", JavaFrontbackBundle.message("checkbox.align.thrown.exception.descriptions", new Object[0]), JavaDocFormattingPanel.getAlignmentGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_ADD_BLANK_AFTER_DESCRIPTION", JavaFrontbackBundle.message("checkbox.after.description", new Object[0]), JavaDocFormattingPanel.getBlankLinesGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_ADD_BLANK_AFTER_PARM_COMMENTS", JavaFrontbackBundle.message("checkbox.after.parameter.descriptions", new Object[0]), JavaDocFormattingPanel.getBlankLinesGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_ADD_BLANK_AFTER_RETURN", JavaFrontbackBundle.message("checkbox.after.return.tag", new Object[0]), JavaDocFormattingPanel.getBlankLinesGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_KEEP_INVALID_TAGS", JavaFrontbackBundle.message("checkbox.keep.invalid.tags", new Object[0]), JavaDocFormattingPanel.getInvalidTagsGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_KEEP_EMPTY_PARAMETER", JavaFrontbackBundle.message("checkbox.keep.empty.param.tags", new Object[0]), JavaDocFormattingPanel.getInvalidTagsGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_KEEP_EMPTY_RETURN", JavaFrontbackBundle.message("checkbox.keep.empty.return.tags", new Object[0]), JavaDocFormattingPanel.getInvalidTagsGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_KEEP_EMPTY_EXCEPTION", JavaFrontbackBundle.message("checkbox.keep.empty.throws.tags", new Object[0]), JavaDocFormattingPanel.getInvalidTagsGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_LEADING_ASTERISKS_ARE_ENABLED", JavaFrontbackBundle.message("checkbox.enable.leading.asterisks", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_USE_THROWS_NOT_EXCEPTION", JavaFrontbackBundle.message("checkbox.use.throws.rather.than.exception", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
            consumer.showStandardOptions(new String[]{"WRAP_COMMENTS"});
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_P_AT_EMPTY_LINES", JavaFrontbackBundle.message("checkbox.generate.p.on.empty.lines", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_KEEP_EMPTY_LINES", JavaFrontbackBundle.message("checkbox.keep.empty.lines", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_DO_NOT_WRAP_ONE_LINE_COMMENTS", JavaFrontbackBundle.message("checkbox.do.not.wrap.one.line.comments", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_PRESERVE_LINE_FEEDS", JavaFrontbackBundle.message("checkbox.preserve.line.feeds", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_PARAM_DESCRIPTION_ON_NEW_LINE", JavaFrontbackBundle.message("checkbox.param.description.on.new.line", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
            consumer.showCustomOption(JavaCodeStyleSettings.class, "JD_INDENT_ON_CONTINUATION", JavaFrontbackBundle.message("checkbox.param.indent.on.continuation", new Object[0]), JavaDocFormattingPanel.getOtherGroup(), new Object[0]);
        } else {
            consumer.showAllStandardOptions();
        }
    }

    public PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        if (text == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("sample.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), false, false);
        file.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, (Object)LanguageLevel.HIGHEST);
        return file;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new JavaIndentOptionsEditor();
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(final @NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        return new DocCommentSettings(){
            private final JavaCodeStyleSettings mySettings;
            {
                this.mySettings = (JavaCodeStyleSettings)rootSettings.getCustomSettings(JavaCodeStyleSettings.class);
            }

            public boolean isDocFormattingEnabled() {
                return this.mySettings.ENABLE_JAVADOC_FORMATTING;
            }

            public void setDocFormattingEnabled(boolean formattingEnabled) {
                this.mySettings.ENABLE_JAVADOC_FORMATTING = formattingEnabled;
            }

            public boolean isLeadingAsteriskEnabled() {
                return this.mySettings.JD_LEADING_ASTERISKS_ARE_ENABLED;
            }

            public boolean isRemoveEmptyTags() {
                return this.mySettings.JD_KEEP_EMPTY_EXCEPTION || this.mySettings.JD_KEEP_EMPTY_PARAMETER || this.mySettings.JD_KEEP_EMPTY_RETURN;
            }

            public void setRemoveEmptyLines(boolean removeEmptyLines) {
                this.mySettings.setKeepTrailingEmptyLines(!removeEmptyLines);
            }

            public void setRemoveEmptyTags(boolean removeEmptyTags) {
                this.mySettings.JD_KEEP_EMPTY_RETURN = !removeEmptyTags;
                this.mySettings.JD_KEEP_EMPTY_PARAMETER = !removeEmptyTags;
                this.mySettings.JD_KEEP_EMPTY_EXCEPTION = !removeEmptyTags;
            }
        };
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        if (field == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        if (PackageEntryTable.class.isAssignableFrom(field.getType())) {
            return new JavaPackageEntryTableAccessor(codeStyleObject, field);
        }
        return super.getAccessor(codeStyleObject, field);
    }

    public List<CodeStylePropertyAccessor> getAdditionalAccessors(@NotNull Object codeStyleObject) {
        if (codeStyleObject == null) {
            JavaLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(13);
        }
        if (codeStyleObject instanceof JavaCodeStyleSettings) {
            return Collections.singletonList(new RepeatAnnotationsAccessor((JavaCodeStyleSettings)((Object)codeStyleObject)));
        }
        return super.getAdditionalAccessors(codeStyleObject);
    }

    public boolean usesCommonKeepLineBreaks() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAccessors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class RepeatAnnotationsAccessor
    extends CodeStylePropertyAccessor<List<String>> {
        private final JavaCodeStyleSettings mySettings;

        RepeatAnnotationsAccessor(@NotNull JavaCodeStyleSettings settings) {
            if (settings == null) {
                RepeatAnnotationsAccessor.$$$reportNull$$$0(0);
            }
            this.mySettings = settings;
        }

        public boolean set(@NotNull List<String> extVal) {
            if (extVal == null) {
                RepeatAnnotationsAccessor.$$$reportNull$$$0(1);
            }
            this.mySettings.setRepeatAnnotations(extVal);
            return true;
        }

        @Nullable
        public List<String> get() {
            return this.mySettings.getRepeatAnnotations();
        }

        protected @Unmodifiable List<String> parseString(@NotNull String string) {
            if (string == null) {
                RepeatAnnotationsAccessor.$$$reportNull$$$0(2);
            }
            return CodeStylePropertiesUtil.getValueList((String)string);
        }

        @Nullable
        protected String valueToString(@NotNull List<String> value) {
            if (value == null) {
                RepeatAnnotationsAccessor.$$$reportNull$$$0(3);
            }
            return CodeStylePropertiesUtil.toCommaSeparatedString(value);
        }

        public String getPropertyName() {
            return "repeat_annotations";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extVal";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/JavaLanguageCodeStyleSettingsProvider$RepeatAnnotationsAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "set";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueToString";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

