/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.indexing.FileContent;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<ClassFileDecompilers.Full> {
    private static final Logger LOG = Logger.getInstance(ClassFileStubBuilder.class);
    public static final int STUB_VERSION = 29;

    @NotNull
    public VirtualFileFilter getFileFilter() {
        VirtualFileFilter virtualFileFilter = VirtualFileFilter.ALL;
        if (virtualFileFilter == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(0);
        }
        return virtualFileFilter;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(1);
        }
        return true;
    }

    @NotNull
    public Stream<ClassFileDecompilers.Full> getAllSubBuilders() {
        Stream<ClassFileDecompilers.Full> stream = ClassFileDecompilers.STATIC_EP_NAME.getExtensionList().stream().filter(d -> d instanceof ClassFileDecompilers.Full).map(d -> (ClassFileDecompilers.Full)d);
        if (stream == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(2);
        }
        return stream;
    }

    @Nullable
    public ClassFileDecompilers.Full getSubBuilder(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(3);
        }
        return (ClassFileDecompilers.Full)fileContent.getFile().computeWithPreloadedContentHint(fileContent.getContent(), () -> ClassFileDecompilers.getInstance().find(fileContent.getFile(), ClassFileDecompilers.Full.class));
    }

    @NotNull
    public String getSubBuilderVersion(@Nullable ClassFileDecompilers.Full decompiler) {
        if (decompiler == null) {
            return "default";
        }
        int version = decompiler.getStubBuilder().getStubVersion();
        String string = decompiler.getClass().getName() + ":" + version;
        if (string == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable ClassFileDecompilers.Full decompiler) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(5);
        }
        if (decompiler == null) {
            return null;
        }
        return (Stub)fileContent.getFile().computeWithPreloadedContentHint(fileContent.getContent(), () -> {
            VirtualFile file = fileContent.getFile();
            try {
                return decompiler.getStubBuilder().buildFileStub(fileContent);
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file.getPath(), (Throwable)e);
                } else {
                    LOG.info(file.getPath() + ": " + e.getMessage());
                }
                return null;
            }
        });
    }

    public int getStubVersion() {
        return 29;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileFilter";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubBuilders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBuilderVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

