/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.jakarta;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openRewrite.OpenRewriteRecipeLibraryContributor;
import com.intellij.openRewrite.jakarta.JakartaRecipeLibraryContributorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openRewrite/jakarta/JakartaRecipeLibraryContributor;", "Lcom/intellij/openRewrite/OpenRewriteRecipeLibraryContributor;", "<init>", "()V", "getRecipeLibraries", "", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "project", "Lcom/intellij/openapi/project/Project;", "hasLibrary", "", "module", "Lcom/intellij/openapi/module/Module;", "isUpdateAvailable", "updateMatches", "recipeName", "", "hasLibraryJarExclusively", "coords", "excludeCoords", "intellij.openRewrite"})
public final class JakartaRecipeLibraryContributor
implements OpenRewriteRecipeLibraryContributor {
    @Override
    @NotNull
    public List<UnifiedCoordinates> getRecipeLibraries(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new UnifiedCoordinates[]{new UnifiedCoordinates("org.openrewrite.recipe", "rewrite-migrate-java", "2.8.0"), new UnifiedCoordinates("org.openrewrite.recipe", "rewrite-java-dependencies", "1.6.0"), new UnifiedCoordinates("org.openrewrite.recipe", "rewrite-static-analysis", "2.0.0"), new UnifiedCoordinates("org.openrewrite.recipe", "rewrite-testing-frameworks", "3.0.0"), new UnifiedCoordinates("org.openrewrite.recipe", "rewrite-logging-frameworks", "3.0.0")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean hasLibrary(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)"javax.inject:javax.inject") || JavaLibraryUtil.hasLibraryJar((Module)module, (String)"javax.persistence:javax.persistence-api");
    }

    @Override
    public boolean isUpdateAvailable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.hasLibraryJarExclusively(module, "javax.inject:javax.inject", "jakarta.inject:jakarta.inject-api") || this.hasLibraryJarExclusively(module, "javax.persistence:javax.persistence-api", "jakarta.persistence:jakarta.persistence-api");
    }

    @Override
    public boolean updateMatches(@NotNull String recipeName) {
        Intrinsics.checkNotNullParameter((Object)recipeName, (String)"recipeName");
        return JakartaRecipeLibraryContributorKt.access$getRECIPE_REGEX$p().matches((CharSequence)recipeName);
    }

    private final boolean hasLibraryJarExclusively(Module module, String coords, String excludeCoords) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)coords) && !JavaLibraryUtil.hasLibraryJar((Module)module, (String)excludeCoords);
    }
}

