/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openRewrite.OpenRewriteConstantsKt;
import com.intellij.openRewrite.OpenRewriteUtilKt;
import com.intellij.openRewrite.run.OpenRewriteRunConfiguration;
import com.intellij.openRewrite.run.OpenRewriteRunConfigurationTypeKt;
import com.intellij.openRewrite.run.OpenRewriteWorkingDirectoryConfigurator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openRewrite/run/OpenRewriteRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/openRewrite/run/OpenRewriteRunConfiguration;", "<init>", "()V", "isDumbAware", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "setupConfigurationFromContext", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "getRecipeName", "", "psiElement", "intellij.openRewrite"})
@SourceDebugExtension(value={"SMAP\nOpenRewriteRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenRewriteRunConfigurationProducer.kt\ncom/intellij/openRewrite/run/OpenRewriteRunConfigurationProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class OpenRewriteRunConfigurationProducer
extends LazyRunConfigurationProducer<OpenRewriteRunConfiguration> {
    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return OpenRewriteRunConfigurationTypeKt.openRewriteRunConfigurationType().getConfigurationFactories()[0];
    }

    protected boolean setupConfigurationFromContext(@NotNull OpenRewriteRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = psiElement;
        PsiFile psiFile = psiElement2.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!OpenRewriteUtilKt.isRecipe(psiFile2)) {
            return false;
        }
        String string = this.getRecipeName(psiElement2);
        if (string == null) {
            return false;
        }
        String recipeName = string;
        configuration.setActiveRecipes(recipeName);
        configuration.setGeneratedName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement2);
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        configuration.setWorkingDirectory(new OpenRewriteWorkingDirectoryConfigurator(project, module).getWorkingDirectory());
        if (!Intrinsics.areEqual((Object)psiFile2.getName(), (Object)"rewrite.yml") || !Intrinsics.areEqual((Object)configuration.getWorkingDirectory(), (Object)virtualFile2.getParent().getPath())) {
            configuration.setConfigLocation(virtualFile2.getPath());
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull OpenRewriteRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = psiElement;
        PsiFile psiFile = psiElement2.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!OpenRewriteUtilKt.isRecipe(psiFile2)) {
            return false;
        }
        String string = this.getRecipeName(psiElement2);
        if (string == null) {
            return false;
        }
        String recipeName = string;
        if (!Intrinsics.areEqual((Object)configuration.getActiveRecipes(), (Object)recipeName)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)configuration.getExpandedConfigLocation(), (Object)virtualFile2.getPath())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)psiFile2.getName(), (Object)"rewrite.yml")) {
            CharSequence charSequence = configuration.getConfigLocation();
            return (charSequence == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)configuration.getExpandedWorkingDirectory(), (Object)virtualFile2.getParent().getPath());
        }
        return false;
    }

    private final String getRecipeName(PsiElement psiElement) {
        Object object;
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)psiElement, YAMLKeyValue.class);
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue yamlKeyValue = yAMLKeyValue;
        if (!Intrinsics.areEqual((Object)yamlKeyValue.getKey(), (Object)psiElement)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)yamlKeyValue.getKeyText(), (Object)"name")) {
            return null;
        }
        PsiElement psiElement2 = yamlKeyValue.getParent();
        YAMLMapping yAMLMapping = psiElement2 instanceof YAMLMapping ? (YAMLMapping)psiElement2 : null;
        if (yAMLMapping == null) {
            return null;
        }
        YAMLMapping parent = yAMLMapping;
        if (!(parent.getParent() instanceof YAMLDocument)) {
            return null;
        }
        YAMLKeyValue yAMLKeyValue2 = parent.getKeyValueByKey("type");
        Object object2 = yAMLKeyValue2 != null ? yAMLKeyValue2.getValue() : null;
        Object object3 = object2 instanceof YAMLScalar ? (YAMLScalar)object2 : null;
        if (object3 == null || (object3 = object3.getTextValue()) == null) {
            return null;
        }
        Object type = object3;
        if (!OpenRewriteConstantsKt.getRECIPE_TYPE_REGEX().matches((CharSequence)type)) {
            return null;
        }
        object2 = yamlKeyValue.getValue();
        Object object4 = object2 instanceof YAMLScalar ? (YAMLScalar)object2 : null;
        if (object4 != null && (object4 = object4.getTextValue()) != null) {
            Object object5;
            Object it = object5 = object4;
            boolean bl = false;
            object = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object5 : null;
        } else {
            object = null;
        }
        return object;
    }
}

