/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run.before;

import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeService;
import com.intellij.openRewrite.run.OpenRewriteRunUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openRewrite/run/before/OpenRewriteScratchClassRunLineMarkerProvider;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "<init>", "()V", "isDumbAware", "", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.openRewrite"})
public final class OpenRewriteScratchClassRunLineMarkerProvider
extends RunLineMarkerContributor {
    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement psiElement = ((PsiIdentifier)element).getParent();
        if (psiElement == null) {
            return null;
        }
        PsiElement parent = psiElement;
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiFile psiFile = ((PsiIdentifier)element).getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        PsiFile virtualFile = psiFile;
        if (!ScratchUtil.isScratch((VirtualFile)virtualFile)) {
            return null;
        }
        if (!OpenRewriteRunUtilsKt.isRecipe((PsiClass)parent)) {
            PsiFile psiFile2 = ((PsiClass)parent).getContainingFile();
            PsiJavaFile psiJavaFile = psiFile2 instanceof PsiJavaFile ? (PsiJavaFile)psiFile2 : null;
            if (psiJavaFile == null || (psiJavaFile = psiJavaFile.getImportList()) == null) {
                return null;
            }
            PsiJavaFile imports = psiJavaFile;
            for (PsiImportStatement importStatement : imports.getImportStatements()) {
                String string = importStatement.getQualifiedName();
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"org.openrewrite.", (boolean)false, (int)2, null) : false;
                if (!bl) continue;
                Project project = ((PsiIdentifier)element).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                OpenRewriteRecipeService.reload$default(OpenRewriteRecipeService.Companion.getInstance(project), null, 1, null);
                break;
            }
            return null;
        }
        return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run, ExecutorAction.Companion.getActions$default((ExecutorAction.Companion)ExecutorAction.Companion, (int)0, (int)1, null), null);
    }
}

