/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.yaml;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openRewrite.recipe.OpenRewriteOptionDescriptor;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openRewrite/yaml/OpenRewriteRecipeInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "descriptor", "Lcom/intellij/openRewrite/recipe/OpenRewriteRecipeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openRewrite/recipe/OpenRewriteRecipeDescriptor;Lcom/intellij/openapi/project/Project;)V", "getDescriptor", "()Lcom/intellij/openRewrite/recipe/OpenRewriteRecipeDescriptor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "insertOptionKeyValues", "sequenceItemScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "runOptionValueTemplate", "intellij.openRewrite"})
@SourceDebugExtension(value={"SMAP\nOpenRewriteRecipeInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenRewriteRecipeInsertHandler.kt\ncom/intellij/openRewrite/yaml/OpenRewriteRecipeInsertHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n774#2:58\n865#2,2:59\n1563#2:61\n1634#2,3:62\n*S KotlinDebug\n*F\n+ 1 OpenRewriteRecipeInsertHandler.kt\ncom/intellij/openRewrite/yaml/OpenRewriteRecipeInsertHandler\n*L\n30#1:58\n30#1:59,2\n30#1:61\n30#1:62,3\n*E\n"})
public final class OpenRewriteRecipeInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final OpenRewriteRecipeDescriptor descriptor;
    @NotNull
    private final Project project;

    public OpenRewriteRecipeInsertHandler(@NotNull OpenRewriteRecipeDescriptor descriptor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.descriptor = descriptor;
        this.project = project;
    }

    @NotNull
    public final OpenRewriteRecipeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiElement psiElement = context.getFile().findElementAt(context.getStartOffset());
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        PsiElement psiElement3 = psiElement2.getParent();
        YAMLScalar yAMLScalar = psiElement3 instanceof YAMLScalar ? (YAMLScalar)psiElement3 : null;
        if (yAMLScalar == null) {
            return;
        }
        YAMLScalar sequenceItemScalar = yAMLScalar;
        this.insertOptionKeyValues(sequenceItemScalar);
        PsiDocumentManager.getInstance((Project)this.project).doPostponedOperationsAndUnblockDocument(context.getEditor().getDocument());
        this.runOptionValueTemplate(context);
    }

    /*
     * WARNING - void declaration
     */
    private final void insertOptionKeyValues(YAMLScalar sequenceItemScalar) {
        Iterator $this$mapTo$iv$iv;
        void $this$map$iv;
        OpenRewriteOptionDescriptor option;
        void $this$filterTo$iv$iv;
        StringBuilder sb = new StringBuilder(sequenceItemScalar.getTextValue()).append(":");
        Iterable $this$filter$iv = this.descriptor.getOptions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            option = (OpenRewriteOptionDescriptor)element$iv$iv;
            boolean bl = false;
            if (!option.getRequired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            option = (OpenRewriteOptionDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(option.getName());
        }
        List requiredOptions = (List)destination$iv$iv;
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)((PsiElement)sequenceItemScalar)) + 2;
        String string = StringUtil.repeatSymbol((char)' ', (int)indent);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeatSymbol(...)");
        String intentString = string;
        for (String requiredOption : requiredOptions) {
            sb.append("\n").append(intentString).append(requiredOption).append(": value");
        }
        YAMLFile yAMLFile = YAMLElementGenerator.getInstance((Project)this.project).createDummyYamlWithText(sb.toString());
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"createDummyYamlWithText(...)");
        YAMLFile dummyFile = yAMLFile;
        Collection collection = YAMLUtil.getTopLevelKeys((YAMLFile)dummyFile);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTopLevelKeys(...)");
        Collection topLevelKeys = collection;
        if (topLevelKeys.isEmpty()) {
            throw new IllegalStateException("no top level keys: " + sb);
        }
        YAMLKeyValue dummyKeyValue = (YAMLKeyValue)topLevelKeys.iterator().next();
        YAMLMapping yAMLMapping = dummyKeyValue.getParentMapping();
        Intrinsics.checkNotNull((Object)yAMLMapping);
        sequenceItemScalar.replace((PsiElement)yAMLMapping);
    }

    private final void runOptionValueTemplate(InsertionContext context) {
        PsiElement psiElement = context.getFile().findElementAt(context.getStartOffset());
        if (psiElement == null) {
            return;
        }
        PsiElement newElement = psiElement;
        PsiElement psiElement2 = newElement.getParent();
        YAMLKeyValue yAMLKeyValue = psiElement2 instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement2 : null;
        if (yAMLKeyValue == null) {
            return;
        }
        YAMLKeyValue recipeKeyValue = yAMLKeyValue;
        YAMLValue yAMLValue = recipeKeyValue.getValue();
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return;
        }
        YAMLMapping recipeMapping = yAMLMapping;
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)recipeKeyValue);
        for (YAMLKeyValue keyValue : recipeMapping.getKeyValues()) {
            YAMLValue value;
            if (keyValue.getValue() == null) continue;
            builder.replaceElement((PsiElement)value, "");
        }
        builder.run(context.getEditor(), false);
    }
}

