/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigFileAnnotator;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.ui.SimpleTextAttributes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesAnnotator;", "Lcom/intellij/micronaut/config/MnConfigFileAnnotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getPlaceholderTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "annotateKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "annotateParameter", "text", "", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "elementStartOffset", "", "annotateIndexAccessExpressions", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnPropertiesAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnPropertiesAnnotator.kt\ncom/intellij/micronaut/config/properties/MnPropertiesAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class MnPropertiesAnnotator
extends MnConfigFileAnnotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof PropertyValueImpl) && !(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        Project project = ((PropertiesFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!MicronautUtils.hasMicronautLibrary(project) || !MnConfigUtilsKt.isMicronautConfigFile(file)) {
            return;
        }
        if (element instanceof PropertyValueImpl) {
            this.annotateValue(element, holder);
        } else if (element instanceof PropertyKeyImpl) {
            this.annotateKey((PropertyKeyImpl)element, holder);
        }
    }

    @Override
    @NotNull
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        TextAttributesKey textAttributesKey = PropertiesHighlighter.PropertiesComponent.PROPERTY_KEY.getTextAttributesKey();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"getTextAttributesKey(...)");
        return textAttributesKey;
    }

    private final void annotateKey(PropertyKeyImpl element, AnnotationHolder holder) {
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)element));
        if (metaConfigKey == null) {
            return;
        }
        MetaConfigKey configKey = metaConfigKey;
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String keyText = string;
        int elementStartOffset = element.getNode().getStartOffset();
        this.annotateIndexAccessExpressions(holder, keyText, configKey, elementStartOffset);
        this.annotateParameter(holder, keyText, configKey, elementStartOffset);
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
        if (configKey.isAccessType(accessTypeArray)) {
            return;
        }
        block5: for (MetaConfigKey.AccessType accessType : element.getReferences()) {
            if (!(accessType instanceof ConfigKeyPathReference)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((ConfigKeyPathReference)accessType).getRangeInElement().shiftRight(elementStartOffset), (String)"shiftRight(...)");
            switch (WhenMappings.$EnumSwitchMapping$0[((ConfigKeyPathReference)accessType).getPathType().ordinal()]) {
                case 1: {
                    TextRange referenceRange;
                    TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.CONSTANT;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CONSTANT");
                    this.doAnnotate(holder, referenceRange, textAttributesKey);
                    continue block5;
                }
                case 2: {
                    TextRange referenceRange;
                    TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.INSTANCE_METHOD;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"INSTANCE_METHOD");
                    this.doAnnotate(holder, referenceRange, textAttributesKey);
                    PsiElement resolve = ((ConfigKeyPathReference)accessType).resolve();
                    if (!(resolve instanceof BeanPropertyElement) || !((BeanPropertyElement)resolve).getMethod().isDeprecated()) continue block5;
                    TextAttributesKey textAttributesKey2 = CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"DEPRECATED_ATTRIBUTES");
                    this.doAnnotate(holder, referenceRange, textAttributesKey2);
                    continue block5;
                }
                case 3: {
                    TextRange referenceRange;
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ITALIC_ATTRIBUTES");
                    this.doAnnotateEnforced(holder, referenceRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
                    continue block5;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.MAP};
        if (configKey.isAccessType(accessTypeArray) && configKey.getKeyItemHint() != MetaConfigKey.ItemHint.NONE) {
            boolean bl;
            int configKeyNameLength = -1;
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof MetaConfigKeyReference)) continue;
                configKeyNameLength = ((MetaConfigKeyReference)reference).getRangeInElement().getEndOffset();
                break;
            }
            boolean bl2 = bl = configKeyNameLength != -1;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-MnPropertiesAnnotator$annotateKey$232 = false;
                String $i$a$-assert-MnPropertiesAnnotator$annotateKey$232 = keyText;
                throw new AssertionError((Object)$i$a$-assert-MnPropertiesAnnotator$annotateKey$232);
            }
            int endOffset = keyText.length() - configKeyNameLength - (StringUtil.endsWithChar((CharSequence)keyText, (char)']') ? 2 : 1);
            TextRange textRange = TextRange.from((int)(configKeyNameLength + 1), (int)endOffset).shiftRight(elementStartOffset);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange genericKeyRange = textRange;
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ITALIC_ATTRIBUTES");
            this.doAnnotateEnforced(holder, genericKeyRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
        }
    }

    private final void annotateParameter(AnnotationHolder holder, String text, MetaConfigKey configKey, int elementStartOffset) {
        String string = configKey.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        MnParametrizedConfigKey mnParametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
        if (mnParametrizedConfigKey == null) {
            return;
        }
        MnParametrizedConfigKey parametrizedConfigKey = mnParametrizedConfigKey;
        TextRange textRange = parametrizedConfigKey.getParameterRange(text);
        if (textRange == null || (textRange = textRange.shiftRight(elementStartOffset)) == null) {
            return;
        }
        TextRange parameterRange = textRange;
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ITALIC_ATTRIBUTES");
        this.doAnnotateEnforced(holder, parameterRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
    }

    private final void annotateIndexAccessExpressions(AnnotationHolder holder, String text, MetaConfigKey configKey, int elementStartOffset) {
        new IndexAccessTextProcessor(text, configKey, this, holder, elementStartOffset){
            final /* synthetic */ MnPropertiesAnnotator this$0;
            final /* synthetic */ AnnotationHolder $holder;
            final /* synthetic */ int $elementStartOffset;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$elementStartOffset = $elementStartOffset;
                super($text, $configKey);
            }

            protected void onMissingClosingBracket(int startIdx) {
            }

            protected void onMissingIndexValue(int startIdx) {
            }

            protected void onBracket(int startIdx) {
                TextRange textRange = TextRange.from((int)startIdx, (int)1).shiftRight(this.$elementStartOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.BRACKETS;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"BRACKETS");
                MnPropertiesAnnotator.access$doAnnotate(this.this$0, this.$holder, textRange, textAttributesKey);
            }

            protected void onIndexValue(TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
                TextRange textRange = indexValueRange.shiftRight(this.$elementStartOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.NUMBER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"NUMBER");
                MnPropertiesAnnotator.access$doAnnotate(this.this$0, this.$holder, textRange, textAttributesKey);
            }

            protected void onIndexValueNotInteger(TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
            }
        }.process();
    }

    public static final /* synthetic */ void access$doAnnotate(MnPropertiesAnnotator $this, AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        $this.doAnnotate(holder, range, key);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigKeyPathReference.PathType.values().length];
            try {
                nArray[ConfigKeyPathReference.PathType.ENUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigKeyPathReference.PathType.BEAN_PROPERTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigKeyPathReference.PathType.ARBITRARY_ENTRY_KEY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

