/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.cache;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.cache.MnCacheConstants;
import com.intellij.micronaut.jam.cache.model.MnCacheBaseElement;
import com.intellij.micronaut.jam.cache.model.MnCacheOperations;
import com.intellij.micronaut.jam.cache.model.MnCacheParameterConverter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.semantic.SemService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/micronaut/jam/cache/MnCacheAnnotationParametersInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkMethodInternal", "", "checkParameters", "cache", "Lcom/intellij/micronaut/jam/cache/model/MnCacheBaseElement;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnCacheAnnotationParametersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnCacheAnnotationParametersInspection.kt\ncom/intellij/micronaut/jam/cache/MnCacheAnnotationParametersInspection\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n19#2:72\n19#2:73\n1#3:74\n*S KotlinDebug\n*F\n+ 1 MnCacheAnnotationParametersInspection.kt\ncom/intellij/micronaut/jam/cache/MnCacheAnnotationParametersInspection\n*L\n39#1:72\n58#1:73\n*E\n"})
public final class MnCacheAnnotationParametersInspection
extends AbstractBaseUastLocalInspectionTool {
    public MnCacheAnnotationParametersInspection() {
        Class[] classArray = new Class[]{UMethod.class};
        super(classArray);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null || !MicronautUtils.hasMicronautCache(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiElement psiElement = uMethod.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        ProblemsHolder holder = new ProblemsHolder(manager, psiElement2.getContainingFile(), isOnTheFly);
        this.checkMethodInternal(uMethod, holder);
        return holder.getResultsArray();
    }

    private final void checkMethodInternal(UMethod uMethod, ProblemsHolder holder) {
        SemService semService = SemService.getSemService((Project)holder.getProject());
        PsiElement $this$asSafely$iv = uMethod.getSourcePsi();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        for (PsiAnnotation psiAnnotation : psiMethod2.getAnnotations()) {
            MnCacheOperations cacheOperations;
            String annoName;
            if (psiAnnotation.getQualifiedName() == null) continue;
            if (MnCacheConstants.getCACHE_ANNOTATIONS().keySet().contains(annoName)) {
                MnCacheBaseElement cache;
                if ((MnCacheBaseElement)semService.getSemElement(MnCacheBaseElement.CACHE_BASE_JAM_KEY, (PsiElement)psiAnnotation) == null) continue;
                this.checkParameters(cache, holder);
                continue;
            }
            if (!MnCacheConstants.getCACHE_OPS_ANNOTATIONS().keySet().contains(annoName) || (MnCacheOperations)semService.getSemElement(MnCacheOperations.CACHE_OPS_JAM_KEY, (PsiElement)psiMethod2) == null) continue;
            for (MnCacheBaseElement mnCacheBaseElement : cacheOperations.getCaches()) {
                Intrinsics.checkNotNull((Object)mnCacheBaseElement);
                this.checkParameters(mnCacheBaseElement, holder);
            }
        }
    }

    private final void checkParameters(MnCacheBaseElement cache, ProblemsHolder holder) {
        for (JamStringAttributeElement<String> param : cache.getParametersElement()) {
            TextRange range;
            PsiReference psiReference;
            PsiReference psiReference2;
            PsiReference[] paramPsiElement;
            block4: {
                PsiLanguageInjectionHost psiLanguageInjectionHost;
                if (param.getPsiElement() == null) continue;
                PsiReference[] $this$asSafely$iv = paramPsiElement;
                boolean $i$f$asSafely = false;
                PsiReference[] psiReferenceArray = $this$asSafely$iv;
                if (!($this$asSafely$iv instanceof PsiLanguageInjectionHost)) {
                    psiReferenceArray = null;
                }
                if ((psiLanguageInjectionHost = (PsiLanguageInjectionHost)psiReferenceArray) == null || ($this$asSafely$iv = psiLanguageInjectionHost.getReferences()) == null) continue;
                PsiReference[] psiReferenceArray2 = $this$asSafely$iv;
                int n = psiReferenceArray2.length;
                for (int i = 0; i < n; ++i) {
                    PsiReference psiReference3;
                    PsiReference it = psiReference3 = psiReferenceArray2[i];
                    boolean bl = false;
                    if (!(it instanceof MnCacheParameterConverter.MnCacheParameterReference)) continue;
                    psiReference2 = psiReference3;
                    break block4;
                }
                psiReference2 = null;
            }
            if ((psiReference = psiReference2) == null) continue;
            PsiReference paramReference = psiReference;
            Intrinsics.checkNotNullExpressionValue((Object)paramReference.getRangeInElement(), (String)"getRangeInElement(...)");
            if (range.isEmpty() && range.getStartOffset() == 1 && Intrinsics.areEqual((Object)"\"\"", (Object)((PsiElement)paramPsiElement).getText())) {
                String message;
                Intrinsics.checkNotNullExpressionValue((Object)ProblemsHolder.unresolvedReferenceMessage((PsiReference)paramReference), (String)"unresolvedReferenceMessage(...)");
                holder.registerProblem((PsiElement)paramPsiElement, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                continue;
            }
            if (paramReference.resolve() != null) continue;
            holder.registerProblem(paramReference);
        }
    }
}

