/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.micronaut.run.MnRunConfigurationTypeKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\"\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/micronaut/run/MnRunConfigurationProducer;", "Lcom/intellij/execution/junit/JavaRunConfigurationProducerBase;", "Lcom/intellij/micronaut/run/MnRunConfiguration;", "<init>", "()V", "isDumbAware", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "setupConfigurationFromContext", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "findMainClass", "Lkotlin/Pair;", "", "psiElement", "mainMethodContainer", "Lorg/jetbrains/uast/UElement;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnRunConfigurationProducer.kt\ncom/intellij/micronaut/run/MnRunConfigurationProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,69:1\n1#2:70\n295#3,2:71\n207#4:73\n171#4:74\n*S KotlinDebug\n*F\n+ 1 MnRunConfigurationProducer.kt\ncom/intellij/micronaut/run/MnRunConfigurationProducer\n*L\n56#1:71,2\n67#1:73\n67#1:74\n*E\n"})
public final class MnRunConfigurationProducer
extends JavaRunConfigurationProducerBase<MnRunConfiguration> {
    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return MnRunConfigurationTypeKt.mnRunConfigurationType().getConfigurationFactories()[0];
    }

    protected boolean setupConfigurationFromContext(@NotNull MnRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (!MicronautUtils.hasMicronautLibrary(module2)) {
            return false;
        }
        Pair<String, PsiElement> pair = this.findMainClass((PsiElement)sourceElement.get());
        if (pair == null) {
            return false;
        }
        Pair<String, PsiElement> pair2 = pair;
        String mainClassName = (String)pair2.component1();
        PsiElement mainClass = (PsiElement)pair2.component2();
        if (mainClass != null) {
            sourceElement.set((Object)mainClass);
        }
        configuration.setMainClassName(mainClassName);
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull MnRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Module configurationModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (!Intrinsics.areEqual((Object)context.getModule(), (Object)configurationModule)) {
            return false;
        }
        Pair<String, PsiElement> pair = this.findMainClass(context.getPsiLocation());
        if (pair == null) {
            return false;
        }
        String mainClassName = (String)pair.component1();
        String configFqn = configuration.getRunClass();
        return Intrinsics.areEqual((Object)configFqn, (Object)mainClassName);
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ConfigurationFactory factory2 = other.getConfiguration().getFactory();
        return factory2 != null && Intrinsics.areEqual((Object)factory2.getOptionsClass(), JvmMainMethodRunConfigurationOptions.class);
    }

    private final Pair<String, PsiElement> findMainClass(PsiElement psiElement) {
        UClass uClass;
        UClass it;
        UElement uElement;
        if (psiElement == null) {
            return null;
        }
        UElement container = this.mainMethodContainer(psiElement);
        if (container instanceof UClass) {
            uElement = container;
            it = (UClass)uElement;
            boolean bl = false;
            uClass = (UClass)(PsiMethodUtil.hasMainMethod((PsiClass)it.getJavaPsi()) ? uElement : null);
        } else if (container instanceof UFile) {
            Object v1;
            block8: {
                Iterable $this$firstOrNull$iv = ((UFile)container).getClasses();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UClass it2 = (UClass)element$iv;
                    boolean bl = false;
                    if (!PsiMethodUtil.hasMainMethod((PsiClass)it2.getJavaPsi())) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            uClass = v1;
        } else {
            uClass = null;
        }
        if (uClass == null) {
            return null;
        }
        UClass mainClass = uClass;
        String string = PsiMethodUtil.getMainJVMClassName((PsiClass)mainClass.getJavaPsi());
        if (string == null) {
            return null;
        }
        String mainClassName = string;
        uElement = mainClass.getSourcePsi();
        it = uElement;
        boolean bl = false;
        UElement sourceElement = !PsiMethodUtil.isMainMethodWithProvider((PsiClass)mainClass.getJavaPsi(), (PsiElement)psiElement) ? uElement : null;
        return TuplesKt.to((Object)mainClassName, (Object)sourceElement);
    }

    private final UElement mainMethodContainer(PsiElement psiElement) {
        UElement uElement;
        PsiElement $this$getUastParentOfType_u24default$iv = psiElement;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UClass uClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        if (uClass != null) {
            uElement = (UElement)uClass;
        } else {
            PsiElement $this$toUElementOfType$iv = psiElement;
            boolean $i$f$toUElementOfType = false;
            uElement = UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UFile.class);
        }
        return uElement;
    }
}

