/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.jvm.config.ConfigKeyParts;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.AutoPopupTailTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.smallrye.SmallRyeConfigUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ3\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001aJ'\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b \u00a8\u0006!"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesUtils;", "", "<init>", "()V", "getPropertyKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "property", "Lcom/intellij/lang/properties/psi/impl/PropertyImpl;", "getPropertyKey$intellij_quarkus", "getPropertyValue", "Lcom/intellij/lang/properties/psi/impl/PropertyValueImpl;", "getPropertyValue$intellij_quarkus", "getMetaConfigKeyVariants", "", "element", "Lcom/intellij/psi/PsiElement;", "configKeyManager", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager;", "existingKeys", "", "", "getMetaConfigKeyVariants$intellij_quarkus", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager;Ljava/util/Set;)[Ljava/lang/Object;", "getLastResolvedMetaConfigKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "keyElement", "getLastResolvedMetaConfigKey$intellij_quarkus", "adjustMapTypeKeyReferenceRange", "Lcom/intellij/openapi/util/TextRange;", "range", "configKey", "trimmedText", "adjustMapTypeKeyReferenceRange$intellij_quarkus", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsPropertiesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsPropertiesUtils.kt\ncom/intellij/quarkus/config/properties/QsPropertiesUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,84:1\n37#2:85\n36#2,3:86\n*S KotlinDebug\n*F\n+ 1 QsPropertiesUtils.kt\ncom/intellij/quarkus/config/properties/QsPropertiesUtils\n*L\n55#1:85\n55#1:86,3\n*E\n"})
public final class QsPropertiesUtils {
    @NotNull
    public static final QsPropertiesUtils INSTANCE = new QsPropertiesUtils();

    private QsPropertiesUtils() {
    }

    @Nullable
    public final PropertyKeyImpl getPropertyKey$intellij_quarkus(@NotNull PropertyImpl property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ASTNode aSTNode = property.getKeyNode();
        if (aSTNode == null) {
            return null;
        }
        ASTNode keyNode = aSTNode;
        PsiElement keyElement = keyNode.getPsi();
        return keyElement instanceof PropertyKeyImpl ? (PropertyKeyImpl)keyElement : null;
    }

    @Nullable
    public final PropertyValueImpl getPropertyValue$intellij_quarkus(@NotNull PropertyImpl property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ASTNode aSTNode = property.getValueNode();
        if (aSTNode == null) {
            return null;
        }
        ASTNode valueNode = aSTNode;
        PsiElement valueElement = valueNode.getPsi();
        return valueElement instanceof PropertyValueImpl ? (PropertyValueImpl)valueElement : null;
    }

    @NotNull
    public final Object[] getMetaConfigKeyVariants$intellij_quarkus(@NotNull PsiElement element, @NotNull MetaConfigKeyManager configKeyManager, @NotNull Set<String> existingKeys) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)configKeyManager, (String)"configKeyManager");
        Intrinsics.checkNotNullParameter(existingKeys, (String)"existingKeys");
        char delimiterChar = PropertiesCodeStyleSettings.getInstance((Project)element.getProject()).getDelimiter();
        TailType defaultDelimiterType = AutoPopupTailTypes.charType((char)delimiterChar);
        List configKeys = configKeyManager.getAllMetaConfigKeys(element);
        Map result = new LinkedHashMap();
        for (MetaConfigKey configKey : configKeys) {
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)configKey.getName(), (String)"getName(...)");
            if (existingKeys.contains(name)) continue;
            LookupElementBuilder builder = configKey.getPresentation().getLookupElement();
            MetaConfigKey.AccessType[] accessTypeArray = MetaConfigKey.AccessType.MAP_GROUP;
            TailType tailType = configKey.isAccessType(Arrays.copyOf(accessTypeArray, accessTypeArray.length)) ? AutoPopupTailTypes.dotType() : defaultDelimiterType;
            Ref lookupElementRef = new Ref();
            TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)((LookupElement)builder), (TailType)tailType);
            LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)tailTypeDecorator);
            lookupElementRef.set((Object)lookupElement);
            result.putIfAbsent(configKey.getName(), lookupElement);
        }
        Collection $this$toTypedArray$iv = result.values();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    @Nullable
    public final MetaConfigKey getLastResolvedMetaConfigKey$intellij_quarkus(@NotNull PsiElement keyElement) {
        Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
        PsiReference[] psiReferenceArray = keyElement.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        PsiReference[] references = psiReferenceArray;
        int n = references.length + -1;
        if (0 <= n) {
            do {
                int i;
                PsiReference reference;
                if (!((reference = references[i = n--]) instanceof MetaConfigKeyReference)) continue;
                return ((MetaConfigKeyReference)reference).getResolvedKey();
            } while (0 <= n);
        }
        return null;
    }

    @NotNull
    public final TextRange adjustMapTypeKeyReferenceRange$intellij_quarkus(@NotNull TextRange range, @Nullable MetaConfigKey configKey, @NotNull String trimmedText) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)trimmedText, (String)"trimmedText");
        if (configKey == null || configKey.isAccessType((MetaConfigKey.AccessType[])(psiElement = new PsiElement[]{MetaConfigKey.AccessType.NORMAL}))) {
            return range;
        }
        psiElement = configKey.getDeclaration();
        if (SmallRyeConfigUtils.INSTANCE.declaredWithUnnamedKey(psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null)) {
            return range;
        }
        ConfigKeyParts configKeyParts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)trimmedText, (boolean)false);
        if (configKeyParts == null) {
            return range;
        }
        ConfigKeyParts parts = configKeyParts;
        TextRange textRange = TextRange.allOf((String)parts.getConfigKey()).shiftRight(range.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        return textRange;
    }
}

