/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.starter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.TextValidationFunction;
import com.intellij.microservices.jvm.starters.DownloadResult;
import com.intellij.microservices.jvm.starters.WebStarterContext;
import com.intellij.microservices.jvm.starters.WebStarterContextProvider;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.microservices.jvm.starters.WebStarterDependencyCategory;
import com.intellij.microservices.jvm.starters.WebStarterFrameworkVersion;
import com.intellij.microservices.jvm.starters.WebStarterModuleBuilder;
import com.intellij.microservices.jvm.starters.WebStarterServerOptions;
import com.intellij.microservices.jvm.starters.WebStarterSettings;
import com.intellij.microservices.jvm.starters.wizard.WebStarterInitialStep;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusIcons;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000fH\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fH\u0014J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0015J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'H\u0014J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020#H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u000201H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/quarkus/starter/QuarkusModuleBuilder;", "Lcom/intellij/microservices/jvm/starters/WebStarterModuleBuilder;", "<init>", "()V", "KOTLIN_DEPENDENCY_ID", "Lcom/intellij/openapi/util/Key;", "", "getDefaultServerUrl", "getBuilderId", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getDescription", "getHelpId", "getLanguageLevels", "", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getDefaultLanguageLevel", "isExampleCodeProvided", "", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getFilePathsToOpen", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "loadServerOptions", "Lcom/intellij/microservices/jvm/starters/WebStarterServerOptions;", "serverUrl", "downloadResult", "Lcom/intellij/microservices/jvm/starters/DownloadResult;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "tempFile", "Ljava/io/File;", "composeGeneratorUrl", "Lcom/intellij/util/Url;", "starterContext", "Lcom/intellij/microservices/jvm/starters/WebStarterContext;", "extractGeneratorResult", "", "tempZipFile", "contentEntryDir", "createOptionsStep", "Lcom/intellij/microservices/jvm/starters/wizard/WebStarterInitialStep;", "contextProvider", "Lcom/intellij/microservices/jvm/starters/WebStarterContextProvider;", "getArtifactIdValidationFunction", "Lcom/intellij/ide/starters/shared/TextValidationFunction;", "QuarkusDependencyCategory", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQuarkusModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuarkusModuleBuilder.kt\ncom/intellij/quarkus/starter/QuarkusModuleBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,218:1\n1#2:219\n382#3,7:220\n1563#4:227\n1634#4,3:228\n1563#4:231\n1634#4,3:232\n24#5:235\n*S KotlinDebug\n*F\n+ 1 QuarkusModuleBuilder.kt\ncom/intellij/quarkus/starter/QuarkusModuleBuilder\n*L\n114#1:220,7\n121#1:227\n121#1:228,3\n157#1:231\n157#1:232,3\n169#1:235\n*E\n"})
public class QuarkusModuleBuilder
extends WebStarterModuleBuilder {
    @NotNull
    private final Key<String> KOTLIN_DEPENDENCY_ID;

    public QuarkusModuleBuilder() {
        Key key = Key.create((String)"QUARKUS_KOTLIN_DEPENDENCY_ID");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.KOTLIN_DEPENDENCY_ID = key;
    }

    @NotNull
    public String getDefaultServerUrl() {
        return "https://code.quarkus.io";
    }

    @NotNull
    public String getBuilderId() {
        return "quarkus-jetbrains";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = QuarkusIcons.Quarkus;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Quarkus");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        String[] stringArray = new String[]{"com.redhat.devtools.intellij.quarkus"};
        PluginId quarkusToolsId = PluginId.Companion.findId(stringArray);
        if (quarkusToolsId != null && PluginManager.isPluginInstalled((PluginId)quarkusToolsId) && !PluginManagerCore.isDisabled((PluginId)quarkusToolsId)) {
            return QuarkusBundle.message("quarkus.wizard.built.in", new Object[0]);
        }
        return "Quarkus";
    }

    @NotNull
    public String getDescription() {
        return QuarkusBundle.message("description.for.quarkus.project.starter", new Object[0]);
    }

    @NotNull
    public String getHelpId() {
        return "quarkus.project";
    }

    @NotNull
    protected List<StarterLanguageLevel> getLanguageLevels() {
        Object[] objectArray = new StarterLanguageLevel[]{new StarterLanguageLevel("21", "21", "21"), new StarterLanguageLevel("17", "17", "17"), new StarterLanguageLevel("11", "11", "11")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return new StarterLanguageLevel("21", "21", "21");
    }

    protected boolean isExampleCodeProvided() {
        return true;
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        Object[] objectArray = new StarterLanguage[]{new StarterLanguage("java", "Java", "JAVA", false, null, 24, null), new StarterLanguage("kotlin", "Kotlin", "kotlin", false, null, 24, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        Object[] objectArray = new StarterProjectType[]{new StarterProjectType("GRADLE", "Gradle - Groovy", null, 4, null), new StarterProjectType("GRADLE_KOTLIN_DSL", "Gradle - Kotlin", null, 4, null), new StarterProjectType("MAVEN", "Maven", null, 4, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.listOf((Object)"README.md");
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages;
        CustomizedMessages $this$getCustomizedMessages_u24lambda_u240 = customizedMessages = new CustomizedMessages();
        boolean bl = false;
        $this$getCustomizedMessages_u24lambda_u240.setProjectTypeLabel(JavaStartersBundle.message((String)"title.project.build.system.label", (Object[])new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setDependenciesLabel(QuarkusBundle.message("quarkus.starter.extensions.label", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setSelectedDependenciesLabel(QuarkusBundle.message("quarkus.starter.selected.extensions.label", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setNoDependenciesSelectedLabel(QuarkusBundle.message("quarkus.starter.select.extensions.hint", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setFrameworkVersionLabel(QuarkusBundle.message("quarkus.starter.version.label", new Object[0]));
        return customizedMessages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        void $this$mapTo$iv$iv;
        Object category;
        Object description;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        JsonNode extensionsRoot = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/api/extensions"), null, (int)2, null);
        Map categories = new LinkedHashMap();
        String kotlinDependencyId = null;
        Iterator iterator = extensionsRoot.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            String categoryName;
            Object links;
            Object it;
            boolean isDefault;
            String name;
            String id;
            JsonNode dependencyObject;
            block9: {
                Object object2;
                block8: {
                    dependencyObject = (JsonNode)iterator2.next();
                    id = dependencyObject.get("id").asText();
                    name = dependencyObject.get("name").asText();
                    if (StringsKt.equals((String)name, (String)"Kotlin", (boolean)true)) {
                        kotlinDependencyId = id;
                    }
                    if (StringsKt.equals((String)name, (String)"Kotlin", (boolean)true) || StringsKt.equals((String)name, (String)"Scala", (boolean)true)) continue;
                    Intrinsics.checkNotNull((Object)dependencyObject);
                    JsonNode jsonNode = this.getNullable(dependencyObject, "description");
                    description = jsonNode != null ? jsonNode.asText() : null;
                    JsonNode jsonNode2 = this.getNullable(dependencyObject, "default");
                    isDefault = jsonNode2 != null ? jsonNode2.asBoolean() : false;
                    JsonNode jsonNode3 = this.getNullable(dependencyObject, "guide");
                    String guideLink = jsonNode3 != null ? jsonNode3.asText() : null;
                    object2 = guideLink;
                    if (object2 == null) break block8;
                    it = object2;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.GUIDE, guideLink, null, 4, null));
                    object2 = list;
                    if (list != null) break block9;
                }
                object2 = links = CollectionsKt.emptyList();
            }
            if (StringsKt.equals((String)(categoryName = dependencyObject.get("category").asText()), (String)"Alternative languages", (boolean)true)) continue;
            it = categories;
            String key$iv = categoryName;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)categoryName);
                QuarkusDependencyCategory answer$iv = new QuarkusDependencyCategory(categoryName, null, 2, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            category = (QuarkusDependencyCategory)((Object)object);
            List<WebStarterDependency> list = ((QuarkusDependencyCategory)((Object)category)).getExtensions();
            Intrinsics.checkNotNull((Object)id);
            Intrinsics.checkNotNull((Object)name);
            list.add(new WebStarterDependency(id, name, (String)description, (List)links, isDefault, false, 32, null));
        }
        JsonNode versionsRoot = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/api/streams"), null, (int)2, null);
        Iterable $this$map$iv = (Iterable)versionsRoot;
        boolean $i$f$map = false;
        description = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            category = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String version = item.get("quarkusCoreVersion").asText();
            String key = item.get("key").asText();
            boolean recommended = item.get("recommended").asBoolean();
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNull((Object)version);
            collection.add(new WebStarterFrameworkVersion(key, version, recommended));
        }
        List quarkusPlatformVersions = (List)destination$iv$iv;
        WebStarterServerOptions options = new WebStarterServerOptions(quarkusPlatformVersions, CollectionsKt.toList((Iterable)categories.values()));
        options.putUserData(this.KOTLIN_DEPENDENCY_ID, (Object)kotlinDependencyId);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    protected DownloadResult downloadResult(@NotNull ProgressIndicator progressIndicator, @NotNull File tempFile) {
        void $this$mapTo$iv$iv;
        ObjectNode objectNode;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)tempFile, (String)"tempFile");
        Url url = this.composeGeneratorUrl(this.getStarterContext().getServerUrl(), this.getStarterContext());
        StarterProjectType starterProjectType = this.getStarterContext().getProjectType();
        Intrinsics.checkNotNull((Object)starterProjectType);
        String projectType = starterProjectType.getId();
        ObjectNode $this$downloadResult_u24lambda_u244 = objectNode = this.getObjectMapper().createObjectNode();
        boolean bl = false;
        $this$downloadResult_u24lambda_u244.put("buildTool", projectType);
        StarterLanguageLevel starterLanguageLevel = this.getStarterContext().getLanguageLevel();
        Intrinsics.checkNotNull((Object)starterLanguageLevel);
        $this$downloadResult_u24lambda_u244.put("javaVersion", starterLanguageLevel.getId());
        $this$downloadResult_u24lambda_u244.put("groupId", this.getStarterContext().getGroup());
        $this$downloadResult_u24lambda_u244.put("artifactId", this.getStarterContext().getArtifact());
        $this$downloadResult_u24lambda_u244.put("version", this.getStarterContext().getVersion());
        WebStarterFrameworkVersion webStarterFrameworkVersion = this.getStarterContext().getFrameworkVersion();
        $this$downloadResult_u24lambda_u244.put("streamKey", webStarterFrameworkVersion != null ? webStarterFrameworkVersion.getId() : null);
        $this$downloadResult_u24lambda_u244.put("className", this.getStarterContext().getGroup() + ".ExampleResource");
        $this$downloadResult_u24lambda_u244.put("path", "/hello");
        if (!this.getStarterContext().getIncludeExamples()) {
            $this$downloadResult_u24lambda_u244.put("noExamples", true);
        }
        ObjectNode payload = objectNode;
        ObjectNode $this$downloadResult_u24lambda_u247 = objectNode = payload.putArray("extensions");
        boolean bl2 = false;
        Iterable $this$map$iv = this.getStarterContext().getDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WebStarterDependency webStarterDependency = (WebStarterDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getId());
        }
        Set selectedDependencyIds = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        if (Intrinsics.areEqual((Object)this.getStarterContext().getLanguage().getId(), (Object)"kotlin")) {
            String string = (String)this.getStarterContext().getServerOptions().getUserData(this.KOTLIN_DEPENDENCY_ID);
            if (string != null) {
                String it = string;
                boolean bl4 = false;
                selectedDependencyIds.add(it);
            }
        }
        for (Object e : selectedDependencyIds) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String dependencyId = (String)e;
            $this$downloadResult_u24lambda_u247.add(dependencyId);
        }
        QuarkusModuleBuilder $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(QuarkusModuleBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Loading project from " + url);
        Object object = HttpRequests.post((String)url.toExternalForm(), (String)"application/json; charset=utf-8").tuner(arg_0 -> QuarkusModuleBuilder.downloadResult$lambda$8(this, arg_0)).userAgent(this.getUserAgent()).connectTimeout(10000).isReadResponseOnError(true).connect(arg_0 -> QuarkusModuleBuilder.downloadResult$lambda$9(this, payload, tempFile, progressIndicator, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (DownloadResult)object;
    }

    @NotNull
    protected Url composeGeneratorUrl(@NotNull String serverUrl, @NotNull WebStarterContext starterContext) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
        return Urls.newFromEncoded((String)(StringsKt.removeSuffix((String)starterContext.getServerUrl(), (CharSequence)"/") + "/api/download"));
    }

    protected void extractGeneratorResult(@NotNull File tempZipFile, @NotNull File contentEntryDir) {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        WebStarterSettings.unzipSubfolder((File)tempZipFile, (File)contentEntryDir);
    }

    @NotNull
    protected WebStarterInitialStep createOptionsStep(@NotNull WebStarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        return new WebStarterInitialStep(contextProvider, this){
            final /* synthetic */ QuarkusModuleBuilder this$0;
            {
                this.this$0 = $receiver;
                super($contextProvider);
            }

            protected TextValidationFunction[] getCustomValidationRules(String propertyId) {
                TextValidationFunction[] textValidationFunctionArray;
                Intrinsics.checkNotNullParameter((Object)propertyId, (String)"propertyId");
                if (Intrinsics.areEqual((Object)propertyId, (Object)"artifactId")) {
                    TextValidationFunction[] textValidationFunctionArray2 = new TextValidationFunction[]{QuarkusModuleBuilder.access$getArtifactIdValidationFunction(this.this$0)};
                    textValidationFunctionArray = textValidationFunctionArray2;
                } else {
                    textValidationFunctionArray = new TextValidationFunction[]{};
                }
                return textValidationFunctionArray;
            }
        };
    }

    private final TextValidationFunction getArtifactIdValidationFunction() {
        return QuarkusModuleBuilder::getArtifactIdValidationFunction$lambda$10;
    }

    private static final void downloadResult$lambda$8(QuarkusModuleBuilder this$0, URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setRequestProperty("Client-Name", this$0.getUserAgent());
    }

    private static final DownloadResult downloadResult$lambda$9(QuarkusModuleBuilder this$0, ObjectNode $payload, File $tempFile, ProgressIndicator $progressIndicator, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.write(this$0.getObjectMapper().writeValueAsString((Object)$payload));
        return this$0.handleDownloadResponse(request, $tempFile, $progressIndicator);
    }

    private static final String getArtifactIdValidationFunction$lambda$10(String artifactId) {
        return StringUtil.hasUpperCaseChar((String)artifactId) ? QuarkusBundle.message("quarkus.starter.artifact.must.contain.only.lowercase.characters", new Object[0]) : null;
    }

    public static final /* synthetic */ TextValidationFunction access$getArtifactIdValidationFunction(QuarkusModuleBuilder $this) {
        return $this.getArtifactIdValidationFunction();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/quarkus/starter/QuarkusModuleBuilder$QuarkusDependencyCategory;", "Lcom/intellij/microservices/jvm/starters/WebStarterDependencyCategory;", "title", "", "extensions", "", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getExtensions", "()Ljava/util/List;", "intellij.quarkus"})
    public static final class QuarkusDependencyCategory
    extends WebStarterDependencyCategory {
        @NotNull
        private final List<WebStarterDependency> extensions;

        public QuarkusDependencyCategory(@NotNull String title, @NotNull List<WebStarterDependency> extensions) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            super(title, extensions);
            this.extensions = extensions;
        }

        public /* synthetic */ QuarkusDependencyCategory(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = new ArrayList();
            }
            this(string, list);
        }

        @NotNull
        public final List<WebStarterDependency> getExtensions() {
            return this.extensions;
        }
    }
}

