/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.db;

import com.intellij.clouds.kubernetes.db.KubernetesDBPortForwardingConfig;
import com.intellij.clouds.kubernetes.db.KubernetesPortForwardingPanel;
import com.intellij.clouds.kubernetes.db.UtilsKt;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.ClientProperty;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider;", "Lcom/intellij/database/dataSource/DbOptionProvider$LocalDataSourceOptionProvider;", "Lcom/intellij/clouds/kubernetes/db/KubernetesDBPortForwardingConfig;", "<init>", "()V", "isApplicable", "", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDisplayName", "", "getDescription", "load", "store", "", "value", "getEditor", "Lcom/intellij/database/dataSource/DbOptionProvider$EditorDesc;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLocation", "Lcom/intellij/database/dataSource/DbOptionProvider$UiLocation;", "MyService", "intellij.clouds.kubernetes.db"})
@SourceDebugExtension(value={"SMAP\nKubernetesPortForwardingDataSourceOptionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPortForwardingDataSourceOptionProvider.kt\ncom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,145:1\n1761#2,3:146\n1#3:149\n30#4,2:150\n*S KotlinDebug\n*F\n+ 1 KubernetesPortForwardingDataSourceOptionProvider.kt\ncom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider\n*L\n94#1:146,3\n129#1:150,2\n*E\n"})
public final class KubernetesPortForwardingDataSourceOptionProvider
extends DbOptionProvider.LocalDataSourceOptionProvider<KubernetesDBPortForwardingConfig> {
    public boolean isApplicable(@NotNull LocalDataSource target) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!RegistryManager.Companion.getInstance().get("kubernetes.db.integration.enabled").asBoolean()) {
                return false;
            }
            Object object = target.getDatabaseDriver();
            if (object != null && (object = object.getJDBCUrlParsers()) != null) {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StatelessJdbcUrlParser it = (StatelessJdbcUrlParser)element$iv;
                        boolean bl2 = false;
                        if (!(it.getParameterNames().contains("port") && it.getParameterNames().contains("host"))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String getDisplayName() {
        String string = KubernetesBundle.message((String)"Kubernetes.db.panel.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = KubernetesBundle.message((String)"Kubernetes.db.panel.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public KubernetesDBPortForwardingConfig load(@Nullable LocalDataSource target) {
        KubernetesDBPortForwardingConfig kubernetesDBPortForwardingConfig;
        LocalDataSource localDataSource = target;
        if (localDataSource != null) {
            LocalDataSource it = localDataSource;
            boolean bl = false;
            kubernetesDBPortForwardingConfig = KubernetesDBPortForwardingConfig.Companion.loadConfig(it);
        } else {
            kubernetesDBPortForwardingConfig = null;
        }
        return kubernetesDBPortForwardingConfig;
    }

    public void store(@NotNull LocalDataSource target, @Nullable KubernetesDBPortForwardingConfig value) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (value == null) {
            return;
        }
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.enabled", String.valueOf(value.isEnabled()));
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.context", value.getContextName());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.namespace", value.getNamespace());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.resource.type", value.getResourceType());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.resource", value.getResource());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.host.port", value.getHostPort());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.container.port", value.getContainerPort());
    }

    @NotNull
    public DbOptionProvider.EditorDesc<KubernetesDBPortForwardingConfig> getEditor(@NotNull LocalDataSource target, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = dataContext.getData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNull((Object)object);
        Project project = (Project)object;
        Object object2 = dataContext.getData(AbstractDatabaseConfigurable.CONFIGURABLE);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.DataSourceConfigurable");
        DataSourceConfigurable configurable = (DataSourceConfigurable)object2;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MyService> serviceClass$iv = MyService.class;
        Object object3 = $this$service$iv.getService(serviceClass$iv);
        if (object3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        String string = target.getUrl();
        KubernetesPortForwardingPanel panel = new KubernetesPortForwardingPanel(project, ((MyService)object3).getCoroutineScope(), string != null ? UtilsKt.getPortFromUrl(string) : null, configurable);
        panel.updateSettings(KubernetesDBPortForwardingConfig.Companion.loadConfig(target));
        Disposer.register((Disposable)((Disposable)configurable), (Disposable)panel);
        JComponent component2 = panel.getComponent();
        ClientProperty.put((JComponent)component2, (Key)DbOptionsEditor.CUSTOM_LAYOUT, (Object)true);
        return new DbOptionProvider.EditorDesc(component2, panel::updateSettings, panel::getSettings);
    }

    @NotNull
    public DbOptionProvider.UiLocation getLocation() {
        return DbOptionProvider.UiLocation.NEW_TAB;
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider$MyService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.clouds.kubernetes.db"})
    private static final class MyService {
        @NotNull
        private final CoroutineScope coroutineScope;

        public MyService(@NotNull CoroutineScope coroutineScope2) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope2, (String)"coroutineScope");
            this.coroutineScope = coroutineScope2;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

