/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.IImageLine;
import org.jetbrains.letsPlot.util.pngj.IImageLineFactory;
import org.jetbrains.letsPlot.util.pngj.IImageLineSet;
import org.jetbrains.letsPlot.util.pngj.IImageLineSetFactory;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.ImageLineByte;
import org.jetbrains.letsPlot.util.pngj.ImageLineInt;
import org.jetbrains.letsPlot.util.pngj.PngjException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\r\b \u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001&B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\r\u0010\u0017\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tJ\u0010\u0010\"\u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J\u000e\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tJ\b\u0010%\u001a\u00020\tH\u0016R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ImageLineSetDefault;", "T", "Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineSet;", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "singleCursor", "", "nlinesx", "", "noffsetx", "stepx", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;ZIII)V", "currentRow", "imageLine", "Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "imageLines", "", "getImgInfo", "()Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "nlines", "offset", "step", "createImageLine", "()Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "createImageLines", "", "getImageLine", "n", "(I)Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "getImageLineRawNum", "hasImageLine", "imageRowToMatrixRow", "imrow", "imageRowToMatrixRowStrict", "matrixRowToImageRow", "mrow", "size", "Companion", "plot-api"})
public abstract class ImageLineSetDefault<T extends IImageLine>
implements IImageLineSet<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageInfo imgInfo;
    private final boolean singleCursor;
    private int nlines;
    private int offset;
    private int step;
    @Nullable
    private List<T> imageLines;
    @Nullable
    private T imageLine;
    private int currentRow;

    public ImageLineSetDefault(@NotNull ImageInfo imgInfo, boolean singleCursor, int nlinesx, int noffsetx, int stepx) {
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        this.currentRow = -1;
        this.imgInfo = imgInfo;
        this.singleCursor = singleCursor;
        if (singleCursor) {
            this.nlines = 1;
            this.offset = 0;
            this.step = 1;
        } else {
            this.nlines = nlinesx;
            this.offset = noffsetx;
            this.step = stepx;
        }
        this.createImageLines();
    }

    @NotNull
    protected final ImageInfo getImgInfo() {
        return this.imgInfo;
    }

    private final void createImageLines() {
        if (this.singleCursor) {
            this.imageLine = this.createImageLine();
        } else {
            this.imageLines = new ArrayList();
            int n = this.nlines;
            for (int i = 0; i < n; ++i) {
                List<T> list2 = this.imageLines;
                Intrinsics.checkNotNull(list2);
                list2.add(this.createImageLine());
            }
        }
    }

    @NotNull
    protected abstract T createImageLine();

    @NotNull
    public T getImageLine(int n) {
        Object object;
        this.currentRow = n;
        if (this.singleCursor) {
            T t = this.imageLine;
            object = t;
            Intrinsics.checkNotNull(t);
        } else {
            int r = this.imageRowToMatrixRowStrict(n);
            if (r < 0) {
                throw new PngjException("Invalid row number");
            }
            List<T> list2 = this.imageLines;
            Intrinsics.checkNotNull(list2);
            object = (IImageLine)list2.get(r);
        }
        return object;
    }

    @NotNull
    public T getImageLineRawNum(int n) {
        Object object;
        if (this.singleCursor) {
            T t = this.imageLine;
            object = t;
            Intrinsics.checkNotNull(t);
        } else {
            List<T> list2 = this.imageLines;
            Intrinsics.checkNotNull(list2);
            object = (IImageLine)list2.get(n);
        }
        return object;
    }

    @Override
    public boolean hasImageLine(int n) {
        return this.singleCursor ? this.currentRow == n : this.imageRowToMatrixRowStrict(n) >= 0;
    }

    @Override
    public int size() {
        return this.nlines;
    }

    private final int imageRowToMatrixRowStrict(int imrow) {
        int imrow2 = imrow;
        int mrow = (imrow2 -= this.offset) >= 0 && (this.step == 1 || imrow2 % this.step == 0) ? imrow2 / this.step : -1;
        return mrow < this.nlines ? mrow : -1;
    }

    public final int matrixRowToImageRow(int mrow) {
        return mrow * this.step + this.offset;
    }

    public final int imageRowToMatrixRow(int imrow) {
        int r = (imrow - this.offset) / this.step;
        return r < 0 ? 0 : (r < this.nlines ? r : this.nlines - 1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004\"\b\b\u0001\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/ImageLineSetDefault$Companion;", "", "()V", "factoryByte", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineSetFactory;", "Lorg/jetbrains/letsPlot/util/pngj/ImageLineByte;", "getFactoryByte", "()Lorg/jetbrains/letsPlot/util/pngj/IImageLineSetFactory;", "factoryInt", "Lorg/jetbrains/letsPlot/util/pngj/ImageLineInt;", "getFactoryInt", "createImageLineSetFactoryFromImageLineFactory", "T", "Lorg/jetbrains/letsPlot/util/pngj/IImageLine;", "ifactory", "Lorg/jetbrains/letsPlot/util/pngj/IImageLineFactory;", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        private final <T extends IImageLine> IImageLineSetFactory<T> createImageLineSetFactoryFromImageLineFactory(IImageLineFactory<T> ifactory) {
            return new IImageLineSetFactory<T>(ifactory){
                final /* synthetic */ IImageLineFactory<T> $ifactory;
                {
                    this.$ifactory = $ifactory;
                }

                @NotNull
                public IImageLineSet<T> create(@Nullable ImageInfo imgInfo, boolean singleCursor, int nlines, int noffset, int step2) {
                    ImageInfo imageInfo = imgInfo;
                    Intrinsics.checkNotNull((Object)imageInfo);
                    ImageInfo imageInfo2 = imageInfo;
                    return new ImageLineSetDefault<T>(singleCursor, nlines, noffset, step2, this.$ifactory, imgInfo, imageInfo2){
                        final /* synthetic */ IImageLineFactory<T> $ifactory;
                        final /* synthetic */ ImageInfo $imgInfo;
                        {
                            this.$ifactory = $ifactory;
                            this.$imgInfo = $imgInfo;
                            super($super_call_param$1, $singleCursor, $nlines, $noffset, $step);
                        }

                        @NotNull
                        protected T createImageLine() {
                            ImageInfo imageInfo = this.$imgInfo;
                            Intrinsics.checkNotNull((Object)imageInfo);
                            return this.$ifactory.createImageLine(imageInfo);
                        }
                    };
                }
            };
        }

        @NotNull
        public final IImageLineSetFactory<ImageLineInt> getFactoryInt() {
            return this.createImageLineSetFactoryFromImageLineFactory(ImageLineInt.Companion.getFactory());
        }

        @NotNull
        public final IImageLineSetFactory<ImageLineByte> getFactoryByte() {
            return this.createImageLineSetFactoryFromImageLineFactory(ImageLineByte.Companion.getFactory());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

