/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.appServerIntegrations;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerDeployedFileUrlProvider;
import com.intellij.javaee.appServers.context.DefaultWebModuleContextProvider;
import com.intellij.javaee.appServers.context.DeploymentModelContext;
import com.intellij.javaee.appServers.context.FacetContextProvider;
import com.intellij.javaee.appServers.context.JavaeeAppFacetContextProvider;
import com.intellij.javaee.appServers.context.WebModuleContextProvider;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.serverInstances.J2EEServerInstance;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.Url;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationServerUrlMapping
implements AppServerDeployedFileUrlProvider {
    private static final JavaeeFacet DEFAULT_DEPLOYMENT_CONTEXT_KEY = null;
    private final Map<J2EEServerInstance, ServerInstanceMapping> myServerInstance2Mapping = new HashMap<J2EEServerInstance, ServerInstanceMapping>();
    private WebModuleContextProvider myCompositeWebModuleContextProvider;
    private List<FacetContextProvider> myFacetContextProvider;

    private WebModuleContextProvider getWebModuleContextProviders() {
        if (this.myCompositeWebModuleContextProvider == null) {
            final ArrayList<WebModuleContextProvider> webModuleContextProviders = new ArrayList<WebModuleContextProvider>();
            this.collectWebModuleContextProviders(webModuleContextProviders);
            this.myCompositeWebModuleContextProvider = new WebModuleContextProvider(){

                @Override
                @Nullable
                public String getContext(@NotNull JavaeeApplicationFacet earFacet, @Nullable String moduleWebUri) {
                    if (earFacet == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (WebModuleContextProvider provider : webModuleContextProviders) {
                        String context = provider.getContext(earFacet, moduleWebUri);
                        if (context == null) continue;
                        return context;
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earFacet", "com/intellij/javaee/appServers/appServerIntegrations/ApplicationServerUrlMapping$1", "getContext"));
                }
            };
        }
        return this.myCompositeWebModuleContextProvider;
    }

    protected void collectWebModuleContextProviders(List<WebModuleContextProvider> webModuleContextProvider) {
        webModuleContextProvider.add(DefaultWebModuleContextProvider.INSTANCE);
    }

    private List<FacetContextProvider> getFacetContextProviders() {
        if (this.myFacetContextProvider == null) {
            this.myFacetContextProvider = new ArrayList<FacetContextProvider>();
            this.collectFacetContextProviders(this.myFacetContextProvider);
        }
        return this.myFacetContextProvider;
    }

    protected void collectFacetContextProviders(List<FacetContextProvider> facetContextProvider) {
        facetContextProvider.add(new JavaeeAppFacetContextProvider());
    }

    @Nullable
    public VirtualFile findSourceFile(@NotNull J2EEServerInstance serverInstance, @NotNull CommonModel model, @NotNull Url url) {
        if (serverInstance == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(1);
        }
        if (url == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    @Deprecated
    @Nullable
    public String getUrlForDeployedFile(J2EEServerInstance serverInstance, DeploymentModel deploymentModel, String relativePath) {
        return null;
    }

    public String getUrlForDeployedFile(J2EEServerInstance serverInstance, DeploymentModel deploymentModel) {
        return this.doGetUrlForDeployedFile(serverInstance, deploymentModel, null, null);
    }

    @Nullable
    public String getUrlForDeployedFile(@NotNull J2EEServerInstance serverInstance, @NotNull DeploymentModel deploymentModel, @NotNull JavaeeFacet javaeeFacet, @NotNull String relativePath) {
        if (serverInstance == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(3);
        }
        if (deploymentModel == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(4);
        }
        if (javaeeFacet == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(5);
        }
        if (relativePath == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(6);
        }
        return this.doGetUrlForDeployedFile(serverInstance, deploymentModel, javaeeFacet, relativePath);
    }

    public void startTrackingServerInstance(@NotNull J2EEServerInstance serverInstance) {
        if (serverInstance == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(7);
        }
        this.myServerInstance2Mapping.put(serverInstance, new ServerInstanceMapping());
    }

    public void stopTrackingServerInstance(@NotNull J2EEServerInstance serverInstance) {
        if (serverInstance == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(8);
        }
        this.myServerInstance2Mapping.remove(serverInstance);
    }

    public void updateDeploymentContexts(@NotNull J2EEServerInstance serverInstance, @NotNull DeploymentModel deploymentModel, boolean deployed) {
        ServerInstanceMapping serverInstanceMapping;
        if (serverInstance == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(9);
        }
        if (deploymentModel == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(10);
        }
        if ((serverInstanceMapping = this.myServerInstance2Mapping.get(serverInstance)) == null) {
            return;
        }
        if (deployed) {
            serverInstanceMapping.put(deploymentModel, this.getContextsForUnknownFacet(deploymentModel, false));
        } else {
            serverInstanceMapping.remove(deploymentModel);
        }
    }

    private String doGetUrlForDeployedFile(@NotNull J2EEServerInstance serverInstance, @NotNull DeploymentModel deploymentModel, @Nullable JavaeeFacet javaeeFacet, @Nullable String relativePath) {
        ServerInstanceMapping serverInstanceMapping;
        if (serverInstance == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(11);
        }
        if (deploymentModel == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(12);
        }
        if ((serverInstanceMapping = this.myServerInstance2Mapping.get(serverInstance)) == null) {
            return null;
        }
        DeploymentMapping deploymentMapping = (DeploymentMapping)serverInstanceMapping.get(deploymentModel);
        if (deploymentMapping == null) {
            return null;
        }
        String context = (String)deploymentMapping.get((Object)javaeeFacet);
        return context == null ? null : this.doCreateUrl(serverInstance.getCommonModel(), context, relativePath);
    }

    private DeploymentMapping getContextsForUnknownFacet(@NotNull DeploymentModel deploymentModel, boolean defaultOnly) {
        if (deploymentModel == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(13);
        }
        DeploymentMapping deploymentMapping = new DeploymentMapping();
        Artifact artifact = deploymentModel.getArtifact();
        if (artifact == null) {
            String context = ApplicationServerUrlMapping.getProvidedContext(deploymentModel);
            if (context == null) {
                context = this.getFileContext(deploymentModel);
            }
            deploymentMapping.put(DEFAULT_DEPLOYMENT_CONTEXT_KEY, context);
            return deploymentMapping;
        }
        ReadAction.run(() -> {
            Project project = deploymentModel.getCommonModel().getProject();
            JavaeeArtifactUtil javaeeArtifactUtil = JavaeeArtifactUtil.getInstance();
            for (FacetContextProvider facetContextProvider : this.getFacetContextProviders()) {
                for (JavaeeFacet javaeeFacet : javaeeArtifactUtil.getFacetsIncludedInArtifact(project, artifact, facetContextProvider.getFacetId())) {
                    String facetContext = this.getContextForKnownFacet(deploymentModel, javaeeFacet);
                    if (facetContext == null) continue;
                    deploymentMapping.put(javaeeFacet, facetContext);
                    if (deploymentMapping.containsKey((Object)DEFAULT_DEPLOYMENT_CONTEXT_KEY)) continue;
                    deploymentMapping.put(DEFAULT_DEPLOYMENT_CONTEXT_KEY, facetContext);
                    if (!defaultOnly) continue;
                    return;
                }
            }
        });
        return deploymentMapping;
    }

    protected String getFileContext(DeploymentModel deploymentModel) {
        return null;
    }

    protected String doCreateUrl(@NotNull CommonModel serverConfig, @Nullable String context, @Nullable String relativePath) {
        if (serverConfig == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(14);
        }
        return ApplicationServerUrlMapping.createUrl(serverConfig, context, relativePath);
    }

    public static String createUrl(@NotNull CommonModel serverConfig, @Nullable String context, @Nullable String relativePath) {
        if (serverConfig == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(15);
        }
        Object result = "http://" + serverConfig.getHost() + ":" + serverConfig.getPort();
        if (StringUtil.isNotEmpty((String)context)) {
            result = DeploymentUtil.concatPaths((String[])new String[]{result, context});
        }
        result = StringUtil.isNotEmpty((String)relativePath) ? DeploymentUtil.concatPaths((String[])new String[]{result, relativePath}) : DeploymentUtil.concatPaths((String[])new String[]{result, "/"});
        return result;
    }

    public String getDefaultUrlForServerConfig(@NotNull CommonModel serverConfig) {
        if (serverConfig == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(16);
        }
        for (DeploymentModel deploymentModel : serverConfig.getDeploymentModels()) {
            DeploymentMapping deploymentMapping = this.getContextsForUnknownFacet(deploymentModel, true);
            String context = (String)deploymentMapping.get(null);
            if (context == null) continue;
            return this.doCreateUrl(serverConfig, context, null);
        }
        return this.doCreateUrl(serverConfig, null, null);
    }

    private String getContextForKnownFacet(@NotNull DeploymentModel deploymentModel, @NotNull JavaeeFacet javaeeFacet) {
        String providedContext;
        if (deploymentModel == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(17);
        }
        if (javaeeFacet == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(18);
        }
        if ((providedContext = ApplicationServerUrlMapping.getProvidedContext(deploymentModel)) != null) {
            return providedContext;
        }
        return (String)ReadAction.compute(() -> {
            FacetTypeId facetTypeId = javaeeFacet.getTypeId();
            for (FacetContextProvider facetContextProvider : this.getFacetContextProviders()) {
                if (!facetContextProvider.getFacetId().equals((Object)facetTypeId)) continue;
                return facetContextProvider.getDeploymentContext(this.getWebModuleContextProviders(), deploymentModel, javaeeFacet);
            }
            return null;
        });
    }

    @Nullable
    private static String getProvidedContext(@NotNull DeploymentModel deployment) {
        if (deployment == null) {
            ApplicationServerUrlMapping.$$$reportNull$$$0(19);
        }
        if (!(deployment instanceof DeploymentModelContext)) {
            return null;
        }
        DeploymentModelContext contextProvider = (DeploymentModelContext)((Object)deployment);
        return contextProvider.isDefaultContextRoot() ? null : contextProvider.getContextRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverInstance";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentModel";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeFacet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/appServers/appServerIntegrations/ApplicationServerUrlMapping";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSourceFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getUrlForDeployedFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "startTrackingServerInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "stopTrackingServerInstance";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDeploymentContexts";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetUrlForDeployedFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextsForUnknownFacet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateUrl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultUrlForServerConfig";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextForKnownFacet";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvidedContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ServerInstanceMapping
    extends HashMap<DeploymentModel, DeploymentMapping> {
        private ServerInstanceMapping() {
        }
    }

    private static class DeploymentMapping
    extends HashMap<JavaeeFacet, String> {
        private DeploymentMapping() {
        }
    }
}

