/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServers.AppServersIntegrationBundle;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DeploymentStatus {
    DEPLOYED(AppServersIntegrationBundle.messagePointer("deployment.status.name.deployed", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.deployed", new Object[0]), AllIcons.RunConfigurations.TestPassed),
    NOT_DEPLOYED(AppServersIntegrationBundle.messagePointer("deployment.status.name.not.deployed", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.not.deployed", new Object[0]), AllIcons.RunConfigurations.TestError),
    FAILED(AppServersIntegrationBundle.messagePointer("deployment.status.name.failed", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.failed", new Object[0]), AllIcons.RunConfigurations.TestFailed),
    DEACTIVATING(AppServersIntegrationBundle.messagePointer("deployment.status.name.deactivating", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.deactivating", new Object[0]), AllIcons.Process.Step_1),
    PREPARING(AppServersIntegrationBundle.messagePointer("deployment.status.name.preparing", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.preparing", new Object[0]), AllIcons.Process.Step_1),
    PREPARED(AppServersIntegrationBundle.messagePointer("deployment.status.name.prepared", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.prepared", new Object[0]), AllIcons.Process.Step_2),
    ACTIVATING(AppServersIntegrationBundle.messagePointer("deployment.status.name.activating", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.activating", new Object[0]), AllIcons.Process.Step_3),
    UNPREPARED(AppServersIntegrationBundle.messagePointer("deployment.status.name.unprepared", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.unprepared", new Object[0]), AllIcons.Process.Step_2),
    UNPREPARING(AppServersIntegrationBundle.messagePointer("deployment.status.name.unpreparing", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.unpreparing", new Object[0]), AllIcons.Process.Step_2),
    UNKNOWN(AppServersIntegrationBundle.messagePointer("deployment.status.name.unknown", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.unknown", new Object[0]), AllIcons.RunConfigurations.TestUnknown),
    DISCONNECTED(AppServersIntegrationBundle.messagePointer("deployment.status.name.disconnected", new Object[0]), AppServersIntegrationBundle.messagePointer("deployment.status.description.disconnected", new Object[0]), AllIcons.Nodes.Plugin),
    EXCLUDED_FROM_DEPLOYMENT((Supplier)AppServersIntegrationBundle.messagePointer("deployment.status.name.excluded.from.deployment", new Object[0]), (Supplier)AppServersIntegrationBundle.messagePointer("deployment.status.description.excluded.from.deployment", new Object[0]), null){
        private final Map<Icon, LayeredIcon> myPatchedIcon = new HashMap<Icon, LayeredIcon>();

        @Override
        public Icon getIcon(Icon deploymentIcon) {
            LayeredIcon icon = this.myPatchedIcon.get(deploymentIcon);
            if (icon == null) {
                icon = new LayeredIcon(2);
                icon.setIcon(deploymentIcon, 0);
                icon.setIcon(PlatformIcons.EXCLUDED_FROM_COMPILE_ICON, 1);
                this.myPatchedIcon.put(deploymentIcon, icon);
            }
            return icon;
        }
    };

    private final Supplier<@Nls String> myName;
    private final Supplier<@Nls String> myDescription;
    private final Icon myIcon;

    private DeploymentStatus(Supplier<String> name, Supplier<String> description, Icon icon) {
        this.myName = name;
        this.myDescription = description;
        this.myIcon = icon;
    }

    public String toString() {
        return this.myName.get();
    }

    public Icon getIcon(Icon deploymentIcon) {
        return this.myIcon;
    }

    @Nls
    public String getName() {
        return this.myName.get();
    }

    @Nls
    public String getDescription() {
        return this.myDescription.get();
    }
}

