/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils.persistence.data.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.utils.persistence.data.FrameworksDataBundle;
import com.intellij.javaee.utils.persistence.data.inspections.RequiredParameterType;
import com.intellij.javaee.utils.persistence.data.inspections.TypeWrapper;
import com.intellij.javaee.utils.persistence.data.parser.Part;
import com.intellij.javaee.utils.persistence.data.parser.PartTree;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserUtil;
import com.intellij.javaee.utils.persistence.data.parser.domain.OrderBySource;
import com.intellij.javaee.utils.persistence.data.parser.domain.PropertyPath;
import com.intellij.javaee.utils.persistence.data.parser.domain.Sort;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

public final class PartTreeInconsistencyUtils {
    public static void checkParts(@NotNull ProblemsHolder holder, @NotNull UMethod uMethod, @NotNull PartTree partTree) {
        List<Part> parts;
        if (holder == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(0);
        }
        if (uMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(1);
        }
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(2);
        }
        if ((parts = partTree.getParts()).size() == 1 && StringUtil.isEmptyOrSpaces((String)parts.get(0).getSource())) {
            return;
        }
        for (Part part : parts) {
            for (PropertyPath property : part.getProperty()) {
                PsiElement psiIdentifier;
                PsiType type = property.getType();
                if (type != null || (psiIdentifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
                String propertyName = property.getSegment();
                if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                    PartTreeInconsistencyUtils.addEmptyPropertyProblem(holder, uMethod.getName(), partTree, part, psiIdentifier);
                    continue;
                }
                TextRange range = PartTreeInconsistencyUtils.getTextRange(partTree, property);
                if (range == null) continue;
                holder.registerProblem(psiIdentifier, range, FrameworksDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
            }
        }
    }

    public static void checkOrderBy(@NotNull ProblemsHolder holder, @NotNull UMethod uMethod, PartTree partTree) {
        PsiElement identifier;
        OrderBySource source;
        if (holder == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(3);
        }
        if (uMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(4);
        }
        if ((source = partTree.getOrderBySource()) != null && (identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) != null) {
            for (Map.Entry<Sort.Order, TextRange> entry : PartTreeParserUtil.getSortTextRanges(partTree).entrySet()) {
                Sort.Order order = entry.getKey();
                for (PropertyPath property : order.getPropertyPath()) {
                    PsiType type = property.getType();
                    if (type != null) continue;
                    String propertyName = property.getSegment();
                    if (StringUtil.isEmptyOrSpaces((String)propertyName)) {
                        String msg = PartTreeInconsistencyUtils.getEmptyPropertyMessage(uMethod.getName(), entry.getValue());
                        holder.registerProblem(identifier, FrameworksDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
                        continue;
                    }
                    TextRange range = PartTreeInconsistencyUtils.getOrderByRange(partTree, property);
                    if (range == null) continue;
                    holder.registerProblem(identifier, range, FrameworksDataBundle.message("cannot.resolve.property", propertyName), new LocalQuickFix[0]);
                }
            }
        }
    }

    private static void addEmptyPropertyProblem(@NotNull ProblemsHolder holder, String methodName, PartTree partTree, Part part, PsiElement psiIdentifier) {
        if (holder == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(5);
        }
        if (methodName.equals(partTree.getSubject().getExpression())) {
            return;
        }
        Map<Part, TextRange> textRanges = PartTreeParserUtil.getPartTextRanges(partTree);
        TextRange range = textRanges.get(part);
        if (range != null) {
            if (range.getStartOffset() == range.getEndOffset()) {
                String msg = PartTreeInconsistencyUtils.getEmptyPropertyMessage(methodName, range);
                holder.registerProblem(psiIdentifier, FrameworksDataBundle.message("empty.property.with.empty.text.range", msg), new LocalQuickFix[0]);
            } else {
                holder.registerProblem(psiIdentifier, range, FrameworksDataBundle.message("empty.property", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    private static String getEmptyPropertyMessage(String methodName, TextRange range) {
        String string = methodName.substring(0, range.getStartOffset()) + "<EMPTY_PROPERTY>" + methodName.substring(range.getEndOffset());
        if (string == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static TextRange getTextRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(7);
        }
        if (property == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(8);
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Part, TextRange> textRanges = PartTreeParserUtil.getPartTextRanges(partTree);
        for (Map.Entry<Part, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getProperty()) {
                int startOffset;
                if (!path.equals(property) || (startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset())) < 0) continue;
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    @Nullable
    private static TextRange getOrderByRange(@NotNull PartTree partTree, @NotNull PropertyPath property) {
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(9);
        }
        if (property == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(10);
        }
        String methodName = partTree.getSource();
        String propertyName = property.getSegment();
        Map<Sort.Order, TextRange> textRanges = PartTreeParserUtil.getSortTextRanges(partTree);
        for (Map.Entry<Sort.Order, TextRange> entry : textRanges.entrySet()) {
            for (PropertyPath path : entry.getKey().getPropertyPath()) {
                if (!path.equals(property)) continue;
                int startOffset = methodName.indexOf(StringUtil.capitalize((String)propertyName), entry.getValue().getStartOffset());
                return TextRange.create((int)startOffset, (int)(startOffset + propertyName.length()));
            }
        }
        return null;
    }

    public static boolean hasUnresolvedPropertyPaths(@NotNull PartTree partTree) {
        if (partTree == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(11);
        }
        for (Part part : partTree.getParts()) {
            for (PropertyPath property : part.getProperty()) {
                PsiType type = property.getType();
                if (type != null) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<RequiredParameterType> getRequiredParameterTypes(@NotNull Iterable<Part> parts, @NotNull Project project, @NotNull Condition<? super Part> isCollectionTypeRequired, @NotNull Condition<? super Part> isCollectionElementTypeRequired, Function<Part, AssignableParameterTypeValidator> ... assignableTypeValidators) {
        if (parts == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(12);
        }
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(13);
        }
        if (isCollectionTypeRequired == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(14);
        }
        if (isCollectionElementTypeRequired == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(15);
        }
        LinkedList<RequiredParameterType> psiTypes = new LinkedList<RequiredParameterType>();
        for (Part part : parts) {
            PropertyPath propertyPath = part.getProperty();
            PsiType psiType = propertyPath.getLeafProperty().getType();
            if (psiType == null) continue;
            RequiredParameterType requiredParameterType = isCollectionTypeRequired.value((Object)part) ? RequiredParameterType.collectionType(propertyPath, PartTreeInconsistencyUtils.createTypedCollection(project, psiType)) : (isCollectionElementTypeRequired.value((Object)part) ? RequiredParameterType.collectionElementType(propertyPath, PartTreeInconsistencyUtils.getCollectionOrStringElementType(project, psiType)) : RequiredParameterType.simple(propertyPath, psiType));
            requiredParameterType.assignableTypeValidators = Arrays.stream(assignableTypeValidators).map(function -> (AssignableParameterTypeValidator)function.fun((Object)part)).filter(Objects::nonNull).collect(Collectors.toSet());
            int argumentsNumber = part.getType().getNumberOfArguments();
            for (int i = 0; i < argumentsNumber; ++i) {
                ContainerUtil.addAllNotNull(psiTypes, (Object[])new RequiredParameterType[]{requiredParameterType});
            }
        }
        LinkedList<RequiredParameterType> linkedList = psiTypes;
        if (linkedList == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(16);
        }
        return linkedList;
    }

    @NotNull
    public static PsiType createWrappedType(@NotNull Project project, @NotNull PsiType psiType, @NotNull String wrappedClass) {
        PsiClassType boxedType;
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(17);
        }
        if (psiType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(18);
        }
        if (wrappedClass == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(19);
        }
        if (StringUtil.isEmptyOrSpaces((String)wrappedClass)) {
            PsiType psiType2 = psiType;
            if (psiType2 == null) {
                PartTreeInconsistencyUtils.$$$reportNull$$$0(20);
            }
            return psiType2;
        }
        PsiClass wrapped = JavaPsiFacade.getInstance((Project)project).findClass(wrappedClass, GlobalSearchScope.allScope((Project)project));
        if (wrapped == null || wrapped.getTypeParameters().length != 1) {
            PsiType psiType3 = psiType;
            if (psiType3 == null) {
                PartTreeInconsistencyUtils.$$$reportNull$$$0(21);
            }
            return psiType3;
        }
        if (psiType instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)psiType).getBoxedType(PsiManager.getInstance((Project)project), GlobalSearchScope.allScope((Project)project))) != null) {
            PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(wrapped, (PsiType)boxedType);
            if (psiClassType == null) {
                PartTreeInconsistencyUtils.$$$reportNull$$$0(22);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(wrapped, psiType);
        if (psiClassType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(23);
        }
        return psiClassType;
    }

    @Nullable
    public static PsiType createTypedCollection(@NotNull Project project, @NotNull PsiType psiType) {
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(24);
        }
        if (psiType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(25);
        }
        return PartTreeInconsistencyUtils.createTypedCollection(project, psiType, "java.util.Collection");
    }

    public static PsiType createTypedCollection(@NotNull Project project, @NotNull PsiType psiType, @NotNull String collection) {
        PsiClass aClass;
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(26);
        }
        if (psiType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(27);
        }
        if (collection == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(28);
        }
        if ((aClass = PartTreeInconsistencyUtils.getCollectionClass(project, StringUtil.isEmptyOrSpaces((String)collection) ? "java.util.Collection" : collection)) == null || aClass.getTypeParameters().length != 1) {
            return null;
        }
        if (psiType instanceof PsiPrimitiveType && (psiType = ((PsiPrimitiveType)psiType).getBoxedType(PsiManager.getInstance((Project)project), GlobalSearchScope.allScope((Project)project))) == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(aClass, psiType);
    }

    @Nullable
    public static PsiType getCollectionOrStringElementType(@NotNull Project project, @NotNull PsiType psiType) {
        GlobalSearchScope resolveScope;
        if (project == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(29);
        }
        if (psiType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(30);
        }
        if ((resolveScope = psiType.getResolveScope()) != null && PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)resolveScope).equals((Object)psiType)) {
            return psiType;
        }
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters(psiType, "java.util.Collection");
    }

    @Nullable
    public static PsiClass getCollectionClass(Project project, @NotNull String collection) {
        if (collection == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(31);
        }
        return JavaPsiFacade.getInstance((Project)project).findClass(collection, GlobalSearchScope.allScope((Project)project));
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType, String ... classes) {
        for (String aClass : classes) {
            PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)aClass, (int)0, (boolean)false);
            if (psiType == null) continue;
            return psiType;
        }
        return null;
    }

    public static String getRequiredParametersTypesToString(List<RequiredParameterType> requiredParameterTypes, PsiMethod psiMethod, @NotNull TypeWrapper wrapper) {
        if (wrapper == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(32);
        }
        String[] types = new String[requiredParameterTypes.size()];
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        int i = 0;
        for (Map.Entry<String, PsiType> entry : PartTreeInconsistencyUtils.getParametersMap(requiredParameterTypes, psiMethod, wrapper).entrySet()) {
            PsiType requiredType = entry.getValue();
            boolean boldType = true;
            if (i < parameters.length) {
                PsiType parameterType = parameters[i].getType();
                if (requiredType != null && parameterType.isAssignableFrom(requiredType)) {
                    boldType = false;
                }
            }
            String text = requiredType == null ? PartTreeInconsistencyUtils.getUnresolvedTypeText() : XmlStringUtil.escapeString((String)PartTreeInconsistencyUtils.getPresentableText(requiredType, requiredParameterTypes.get((int)i).assignableTypeValidators));
            types[i] = boldType ? "<b>" + text + "</b>" : text;
            ++i;
        }
        return StringUtil.join((String[])types, (String)", ");
    }

    @NotNull
    private static String getPresentableText(PsiType type, Set<AssignableParameterTypeValidator> validators) {
        if (type == null) {
            String string = PartTreeInconsistencyUtils.getUnresolvedTypeText();
            if (string == null) {
                PartTreeInconsistencyUtils.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (!validators.isEmpty()) {
            String string = StringUtil.join((Collection)ContainerUtil.map(validators, validator -> validator.getRequiredTypePresentableText(type)), (String)"|");
            if (string == null) {
                PartTreeInconsistencyUtils.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = type.getPresentableText();
        if (string == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static Map<String, PsiType> getParametersMap(@NotNull List<RequiredParameterType> types, @NotNull PsiMethod psiMethod, @NotNull TypeWrapper wrapper) {
        if (types == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(36);
        }
        if (psiMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(37);
        }
        if (wrapper == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(38);
        }
        LinkedHashMap<String, PsiType> paramMap = new LinkedHashMap<String, PsiType>();
        PsiClassType objectClassType = PartTreeInconsistencyUtils.getObjectClassType(psiMethod.getProject());
        for (RequiredParameterType type : types) {
            PropertyPath nodeProperty = type.propertyPath;
            PropertyPath property = nodeProperty.getLeafProperty();
            String propertyName = StringUtil.replace((String)nodeProperty.toDotPath(), (String)".", (String)"_");
            PsiType psiType = property.getType();
            if (psiType == null) continue;
            if (type.collectionType) {
                psiType = PartTreeInconsistencyUtils.createTypedCollection(psiMethod.getProject(), psiType, wrapper.collectionTypes.length > 0 ? wrapper.collectionTypes[0] : "");
            } else if (wrapper.simpleTypes.length > 0) {
                psiType = PartTreeInconsistencyUtils.createWrappedType(psiMethod.getProject(), psiType, wrapper.simpleTypes[0]);
            }
            String paramName = PartTreeInconsistencyUtils.getUnusedName(paramMap, propertyName);
            paramMap.put(paramName, (PsiType)(psiType == null ? objectClassType : psiType));
        }
        LinkedHashMap<String, PsiType> linkedHashMap = paramMap;
        if (linkedHashMap == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(39);
        }
        return linkedHashMap;
    }

    @Nullable
    public static PsiType getPsiType(Project project, String fqn) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass pageableClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
        return pageableClass == null ? null : PsiTypesUtil.getClassType((PsiClass)pageableClass);
    }

    @NotNull
    public static String getUnusedName(@NotNull Map<String, PsiType> paramMap, @NotNull String name) {
        if (paramMap == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(40);
        }
        if (name == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(41);
        }
        Object paramName = name;
        int i = 0;
        while (paramMap.containsKey(paramName)) {
            paramName = name + (++i + 1);
        }
        String string = paramName;
        if (string == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static PsiClassType getObjectClassType(Project project) {
        return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    @NotNull
    public static Map<String, PsiType> getPropertyPathParamsMap(@NotNull Iterable<Part> nodes, @NotNull PsiMethod psiMethod, @NotNull Condition<? super Part> isCollectionTypeRequired) {
        if (nodes == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(43);
        }
        if (psiMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(44);
        }
        if (isCollectionTypeRequired == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(45);
        }
        LinkedHashMap<String, PsiType> paramMap = new LinkedHashMap<String, PsiType>();
        PsiClassType objectClassType = PartTreeInconsistencyUtils.getObjectClassType(psiMethod.getProject());
        for (Part node : nodes) {
            PropertyPath nodeProperty = node.getProperty();
            PropertyPath property = nodeProperty.getLeafProperty();
            String propertyName = StringUtil.replace((String)nodeProperty.toDotPath(), (String)".", (String)"_");
            PsiType psiType = property.getType();
            if (psiType == null) continue;
            if (isCollectionTypeRequired.value((Object)node)) {
                psiType = PartTreeInconsistencyUtils.createTypedCollection(psiMethod.getProject(), psiType);
            }
            int argumentsNumber = node.getType().getNumberOfArguments();
            for (int arg = 0; arg < argumentsNumber; ++arg) {
                String paramName = PartTreeInconsistencyUtils.getUnusedName(paramMap, propertyName);
                paramMap.put(paramName, (PsiType)(psiType == null ? objectClassType : psiType));
            }
        }
        LinkedHashMap<String, PsiType> linkedHashMap = paramMap;
        if (linkedHashMap == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(46);
        }
        return linkedHashMap;
    }

    public static boolean areAssignableTypes(@NotNull PsiMethod psiMethod, @NotNull List<RequiredParameterType> requiredParameterTypes, @NotNull PsiClass domainClass, UClass repositoryClass, @NotNull PartTreeParametersCheckHelper helper) {
        PsiParameter[] parameters;
        if (psiMethod == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(47);
        }
        if (requiredParameterTypes == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(48);
        }
        if (domainClass == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(49);
        }
        if (helper == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(50);
        }
        if ((parameters = psiMethod.getParameterList().getParameters()).length == 0) {
            return requiredParameterTypes.isEmpty();
        }
        boolean shouldCheckReactiveTypes = helper.acceptReactiveTypeParameters(repositoryClass);
        boolean shouldCheckCoroutinesTypes = helper.acceptCoroutineTypeParameters(repositoryClass);
        int requiredParameterIndex = 0;
        for (RequiredParameterType requiredParameterType : requiredParameterTypes) {
            if (requiredParameterIndex > parameters.length - 1) {
                return false;
            }
            PsiParameter parameter = parameters[requiredParameterIndex];
            PsiType parameterType = parameter.getType();
            if (helper.isNotQueryParameter(psiMethod, parameterType)) continue;
            PsiType requiredType = requiredParameterType.type;
            if (requiredType == null) {
                ++requiredParameterIndex;
                continue;
            }
            if (requiredParameterType.collectionType) {
                PsiType actualSubstitutedTypeParameter;
                if (parameterType instanceof PsiArrayType) {
                    PsiArrayType psiArrayType = (PsiArrayType)parameterType;
                    actualSubstitutedTypeParameter = psiArrayType.getComponentType();
                } else {
                    actualSubstitutedTypeParameter = parameter.isVarArgs() ? parameterType : PartTreeInconsistencyUtils.getSubstitutedTypeParameters(parameterType, helper.getPossibleCollections(shouldCheckReactiveTypes, shouldCheckCoroutinesTypes));
                }
                PsiType requiredSubstitutedType = PartTreeInconsistencyUtils.getSubstitutedTypeParameters(requiredType, "java.util.Collection");
                if (actualSubstitutedTypeParameter != null && requiredSubstitutedType != null && actualSubstitutedTypeParameter.isAssignableFrom(requiredSubstitutedType)) {
                    ++requiredParameterIndex;
                    continue;
                }
                return false;
            }
            PsiType substitutedFromWrapper = PartTreeInconsistencyUtils.getSubstitutedTypeParameters(parameterType, helper.getPossibleWrappers(shouldCheckReactiveTypes, shouldCheckCoroutinesTypes));
            if (substitutedFromWrapper != null) {
                parameterType = substitutedFromWrapper;
            }
            if (!PartTreeInconsistencyUtils.isAssignableOrDomainClassFrom(parameterType, requiredParameterType, domainClass)) {
                return false;
            }
            ++requiredParameterIndex;
        }
        return true;
    }

    private static boolean isAssignableOrDomainClassFrom(@NotNull PsiType parameterType, @NotNull RequiredParameterType requiredType, @NotNull PsiClass domainClass) {
        if (parameterType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(51);
        }
        if (requiredType == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(52);
        }
        if (domainClass == null) {
            PartTreeInconsistencyUtils.$$$reportNull$$$0(53);
        }
        if (requiredType.type == null) {
            return true;
        }
        for (AssignableParameterTypeValidator validator : requiredType.assignableTypeValidators) {
            if (!validator.isAccepted(requiredType.type)) continue;
            return validator.isAssignable(parameterType);
        }
        if (parameterType.isAssignableFrom(requiredType.type)) {
            return true;
        }
        return parameterType instanceof PsiClassType && domainClass.equals(((PsiClassType)parameterType).resolve());
    }

    public static String getUnresolvedTypeText() {
        return "? extends Object";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 16, 20, 21, 22, 23, 33, 34, 35, 39, 42, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
            case 6: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/persistence/data/inspections/PartTreeInconsistencyUtils";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 13: 
            case 17: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCollectionTypeRequired";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCollectionElementTypeRequired";
                break;
            }
            case 18: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedClass";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 37: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramMap";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredParameterTypes";
                break;
            }
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/persistence/data/inspections/PartTreeInconsistencyUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyPropertyMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredParameterTypes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrappedType";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersMap";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyPathParamsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkParts";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkOrderBy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyPropertyProblem";
                break;
            }
            case 6: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 46: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrderByRange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedPropertyPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredParameterTypes";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createWrappedType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTypedCollection";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionOrStringElementType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionClass";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredParametersTypesToString";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParametersMap";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedName";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyPathParamsMap";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableTypes";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableOrDomainClassFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 16, 20, 21, 22, 23, 33, 34, 35, 39, 42, 46 -> new IllegalStateException(string);
        };
    }

    public static interface PartTreeParametersCheckHelper {
        public String[] getPossibleWrappers(boolean var1, boolean var2);

        public String[] getPossibleCollections(boolean var1, boolean var2);

        public boolean acceptReactiveTypeParameters(UClass var1);

        public boolean acceptCoroutineTypeParameters(UClass var1);

        public boolean isNotQueryParameter(@NotNull PsiMethod var1, PsiType var2);
    }

    public static abstract class AssignableParameterTypeValidator {
        public abstract boolean isAccepted(@NotNull PsiType var1);

        public abstract boolean isAssignable(@NotNull PsiType var1);

        protected String getRequiredTypePresentableText(@NotNull PsiType psiType) {
            if (psiType == null) {
                AssignableParameterTypeValidator.$$$reportNull$$$0(0);
            }
            return psiType.getPresentableText();
        }

        protected static boolean isAssignable(@Nullable PsiType psiType, @NotNull String baseClass) {
            if (baseClass == null) {
                AssignableParameterTypeValidator.$$$reportNull$$$0(1);
            }
            return psiType instanceof PsiClassType && InheritanceUtil.isInheritor((PsiClass)((PsiClassType)psiType).resolve(), (boolean)false, (String)baseClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javaee/utils/persistence/data/inspections/PartTreeInconsistencyUtils$AssignableParameterTypeValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRequiredTypePresentableText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAssignable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

