/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.appServers.context.FacetContextProvider;
import com.intellij.javaee.appServers.context.WebModuleContextProvider;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFacetContextProvider
implements FacetContextProvider {
    @Override
    public FacetTypeId<? extends JavaeeFacet> getFacetId() {
        return WebFacet.ID;
    }

    @Override
    public String getDeploymentContext(@NotNull WebModuleContextProvider webModuleContextProvider, @NotNull DeploymentModel deploymentModel, @NotNull JavaeeFacet facet) {
        if (webModuleContextProvider == null) {
            WebFacetContextProvider.$$$reportNull$$$0(0);
        }
        if (deploymentModel == null) {
            WebFacetContextProvider.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            WebFacetContextProvider.$$$reportNull$$$0(2);
        }
        WebFacet webFacet = (WebFacet)facet;
        Artifact artifact = deploymentModel.getArtifact();
        if (artifact != null && JavaeeArtifactUtil.getInstance().isJavaeeApplication(artifact.getArtifactType())) {
            return WebFacetContextProvider.getModuleContext(webModuleContextProvider, artifact, webFacet);
        }
        String serverSpecificContext = StringUtil.nullize((String)this.getContextServerSpecific(deploymentModel, webFacet));
        if (serverSpecificContext != null) {
            return serverSpecificContext;
        }
        File source = deploymentModel.getDeploymentSource().getFile();
        return source == null ? null : FileUtilRt.getNameWithoutExtension((String)source.getName());
    }

    protected String getContextServerSpecific(@NotNull DeploymentModel deploymentModel, @NotNull WebFacet facet) {
        if (deploymentModel == null) {
            WebFacetContextProvider.$$$reportNull$$$0(3);
        }
        if (facet == null) {
            WebFacetContextProvider.$$$reportNull$$$0(4);
        }
        return this.getContextServerSpecific(facet);
    }

    protected String getContextServerSpecific(@NotNull WebFacet facet) {
        if (facet == null) {
            WebFacetContextProvider.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public static String getModuleContext(@NotNull WebModuleContextProvider webModuleContextProvider, @NotNull Artifact earArtifact, @NotNull WebFacet webFacet) {
        if (webModuleContextProvider == null) {
            WebFacetContextProvider.$$$reportNull$$$0(6);
        }
        if (earArtifact == null) {
            WebFacetContextProvider.$$$reportNull$$$0(7);
        }
        if (webFacet == null) {
            WebFacetContextProvider.$$$reportNull$$$0(8);
        }
        Project project = webFacet.getModule().getProject();
        String moduleWebUri = WebArtifactUtil.getInstance().getModuleWebUri(earArtifact, webFacet);
        if (moduleWebUri == null) {
            return null;
        }
        Collection<JavaeeApplicationFacet> earFacets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, earArtifact, JavaeeApplicationFacet.ID);
        for (JavaeeApplicationFacet earFacet : earFacets) {
            String contextRoot = webModuleContextProvider.getContext(earFacet, moduleWebUri);
            if (contextRoot == null) continue;
            return contextRoot;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webModuleContextProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentModel";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earArtifact";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/web/WebFacetContextProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeploymentContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextServerSpecific";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

