/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.model.xml.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.web.model.xml.HttpStatusCode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class HttpStatusCodeConverter
extends ResolvingConverter<HttpStatusCode> {
    private static final Pattern HTTP_STATUS_CODE = Pattern.compile("\\d{3}");
    private final Set<HttpStatusCode> myAllowedStatusCodes;
    private final boolean myCustomCodeAllowed;

    public HttpStatusCodeConverter() {
        this(EnumSet.allOf(HttpStatusCode.class), true);
    }

    public HttpStatusCodeConverter(@Unmodifiable Set<HttpStatusCode> allowedStatusCodes, boolean customCodeAllowed) {
        this.myAllowedStatusCodes = EnumSet.copyOf(allowedStatusCodes);
        this.myAllowedStatusCodes.remove((Object)HttpStatusCode.CUSTOM);
        this.myCustomCodeAllowed = customCodeAllowed;
    }

    public final HttpStatusCode fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            HttpStatusCodeConverter.$$$reportNull$$$0(0);
        }
        return this.findHttpStatusCode(s);
    }

    @Nullable
    private HttpStatusCode findHttpStatusCode(@Nullable String s) {
        if (s == null) {
            return null;
        }
        HttpStatusCode value = (HttpStatusCode)((Object)ContainerUtil.find(this.myAllowedStatusCodes, code -> code.getValue().equals(s)));
        if (value != null) {
            return value;
        }
        if (!this.myCustomCodeAllowed) {
            return null;
        }
        return HTTP_STATUS_CODE.matcher(s).matches() ? HttpStatusCode.CUSTOM : null;
    }

    public final String toString(HttpStatusCode statusCode, @NotNull ConvertContext context) {
        if (context == null) {
            HttpStatusCodeConverter.$$$reportNull$$$0(1);
        }
        return statusCode == null ? null : statusCode.getValue();
    }

    @NotNull
    public Collection<HttpStatusCode> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            HttpStatusCodeConverter.$$$reportNull$$$0(2);
        }
        Set<HttpStatusCode> set = this.myAllowedStatusCodes;
        if (set == null) {
            HttpStatusCodeConverter.$$$reportNull$$$0(3);
        }
        return set;
    }

    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            HttpStatusCodeConverter.$$$reportNull$$$0(4);
        }
        if (s == null || !HTTP_STATUS_CODE.matcher(s).matches()) {
            return J2EEBundle.message("inspection.message.invalid.http.status.code", s);
        }
        return J2EEBundle.message("inspection.message.http.status.code.not.allowed.here", s);
    }

    @Nullable
    public LookupElement createLookupElement(HttpStatusCode statusCode) {
        return LookupElementBuilder.create((String)statusCode.getValue()).withStrikeoutness(statusCode.isDeprecated()).withTailText(" (" + statusCode.getReason() + ")", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/model/xml/converters/HttpStatusCodeConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/model/xml/converters/HttpStatusCodeConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

