/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.model;

public enum RelationshipType {
    ONE_TO_ONE,
    ONE_TO_MANY,
    MANY_TO_ONE,
    MANY_TO_MANY;


    public boolean isMany(boolean thisSide) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case MANY_TO_MANY -> true;
            case MANY_TO_ONE -> thisSide;
            case ONE_TO_MANY -> {
                if (!thisSide) {
                    yield true;
                }
                yield false;
            }
            case ONE_TO_ONE -> false;
        };
    }

    public RelationshipType getInverseType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case MANY_TO_MANY -> this;
            case MANY_TO_ONE -> ONE_TO_MANY;
            case ONE_TO_MANY -> MANY_TO_ONE;
            case ONE_TO_ONE -> this;
        };
    }

    public boolean corresponds(RelationshipType otherSideType) {
        return this.getInverseType() == otherSideType;
    }

    public static RelationshipType getRelationshipType(boolean thatSideMany, boolean thisSideMany) {
        return thisSideMany ? (thatSideMany ? MANY_TO_MANY : MANY_TO_ONE) : (thatSideMany ? ONE_TO_MANY : ONE_TO_ONE);
    }
}

