/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.playwright.js;

import com.intellij.aqua.runners.playwright.js.PlaywrightConfigurationFilePropertyReader;
import com.intellij.aqua.runners.playwright.js.PlaywrightConstantsKt;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\"\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"isUnderCorrectPlaywrightConfig", "", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "getPlaywrightSettingsTestDirValuePsiReference", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/lang/javascript/psi/JSElement;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiElement;", "getDirectory", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/vfs/VirtualFile;", "getPlaywrightConfigurationFile", "project", "Lcom/intellij/openapi/project/Project;", "getPlaywrightConfigurationPropertyValueElement", "configurationFile", "propertyName", "", "getTestDirRelativePath", "pathElement", "intellij.aqua.runners.playwright.js"})
@SourceDebugExtension(value={"SMAP\nPlaywrightConfigurationFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaywrightConfigurationFileUtils.kt\ncom/intellij/aqua/runners/playwright/js/PlaywrightConfigurationFileUtilsKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n67#2:100\n1374#3:101\n1460#3,5:102\n774#3:107\n865#3,2:108\n1056#3:110\n*S KotlinDebug\n*F\n+ 1 PlaywrightConfigurationFileUtils.kt\ncom/intellij/aqua/runners/playwright/js/PlaywrightConfigurationFileUtilsKt\n*L\n55#1:100\n60#1:101\n60#1:102,5\n61#1:107\n61#1:108,2\n62#1:110\n*E\n"})
public final class PlaywrightConfigurationFileUtilsKt {
    public static final boolean isUnderCorrectPlaywrightConfig(@NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return true;
        }
        PsiElement element2 = psiElement;
        VirtualFile virtualFile = PlaywrightConfigurationFileUtilsKt.getDirectory(element2);
        if (virtualFile == null) {
            return true;
        }
        VirtualFile directory = virtualFile;
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile2 = PlaywrightConfigurationFileUtilsKt.getPlaywrightConfigurationFile(project, directory);
        if (virtualFile2 == null) {
            return true;
        }
        VirtualFile closestConfigFile = virtualFile2;
        if (Intrinsics.areEqual((Object)closestConfigFile.getParent(), (Object)directory)) {
            Project project2 = element2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!Intrinsics.areEqual((Object)ProjectUtil.guessProjectDir((Project)project2), (Object)directory)) {
                return true;
            }
        }
        Project project3 = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        JSElement jSElement = PlaywrightConfigurationFileUtilsKt.getPlaywrightConfigurationPropertyValueElement(project3, closestConfigFile, "testDir");
        if (jSElement == null) {
            return true;
        }
        JSElement testDirProperty = jSElement;
        String string = PlaywrightConfigurationFileUtilsKt.getTestDirRelativePath(testDirProperty);
        if (string == null) {
            return true;
        }
        String testDirRelativePath = string;
        VirtualFile virtualFile3 = closestConfigFile.getParent().findFileByRelativePath(testDirRelativePath);
        if (virtualFile3 == null) {
            return false;
        }
        VirtualFile testDir = virtualFile3;
        return VfsUtil.isAncestor((VirtualFile)testDir, (VirtualFile)directory, (boolean)false);
    }

    @Nullable
    public static final SmartPsiElementPointer<JSElement> getPlaywrightSettingsTestDirValuePsiReference(@NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = context2.getPsiLocation();
        if (psiElement == null) {
            return null;
        }
        PsiElement element2 = psiElement;
        VirtualFile virtualFile = PlaywrightConfigurationFileUtilsKt.getDirectory(element2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile2 = PlaywrightConfigurationFileUtilsKt.getPlaywrightConfigurationFile(project, directory);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile closestConfigFile = virtualFile2;
        Project project2 = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        JSElement jSElement = PlaywrightConfigurationFileUtilsKt.getPlaywrightConfigurationPropertyValueElement(project2, closestConfigFile, "testDir");
        if (jSElement == null) {
            return null;
        }
        JSElement testDirProperty = jSElement;
        return SmartPointerManager.createPointer((PsiElement)((PsiElement)testDirProperty));
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile getDirectory(PsiElement $this$directory) {
        Object object;
        if ($this$directory instanceof PsiDirectory) {
            object = ((PsiDirectory)$this$directory).getVirtualFile();
        } else {
            void $this$parentOfType$iv;
            PsiElement psiElement = $this$directory;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            PsiFile psiFile = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiFile.class, (boolean)false);
            object = psiFile != null ? psiFile.getVirtualFile() : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile getPlaywrightConfigurationFile(@NotNull Project project, @NotNull VirtualFile directory) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Iterable $this$flatMap$iv = PlaywrightConstantsKt.getPLAYWRIGHT_CONFIG_FILE_NAMES();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Collection collection = FilenameIndex.getVirtualFilesByName((String)it, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile configFile = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(configFile.getParent().isDirectory() && VfsUtil.isAncestor((VirtualFile)configFile.getParent(), (VirtualFile)directory, (boolean)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return (VirtualFile)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(directory){
            final /* synthetic */ VirtualFile $directory$inlined;
            {
                this.$directory$inlined = virtualFile;
            }

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                String string = VfsUtil.getRelativePath((VirtualFile)this.$directory$inlined, (VirtualFile)it.getParent());
                it = (VirtualFile)b;
                Comparable comparable = string != null ? Integer.valueOf(string.length()) : null;
                bl = false;
                String string2 = VfsUtil.getRelativePath((VirtualFile)this.$directory$inlined, (VirtualFile)it.getParent());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(string2 != null ? Integer.valueOf(string2.length()) : null));
            }
        }));
    }

    @Nullable
    public static final JSElement getPlaywrightConfigurationPropertyValueElement(@NotNull Project project, @NotNull VirtualFile configurationFile, @NotNull String propertyName) {
        JSElement jSElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurationFile, (String)"configurationFile");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(configurationFile);
        if (psiFile != null) {
            PsiFile configurationFilePsi = psiFile;
            boolean bl = false;
            jSElement = (JSElement)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)configurationFilePsi), (Key)new Key(propertyName), () -> PlaywrightConfigurationFileUtilsKt.getPlaywrightConfigurationPropertyValueElement$lambda$5$lambda$4(configurationFilePsi, propertyName));
        } else {
            jSElement = null;
        }
        return jSElement;
    }

    private static final String getTestDirRelativePath(JSElement pathElement) {
        return pathElement instanceof JSLiteralExpression ? ((JSLiteralExpression)pathElement).getStringValue() : null;
    }

    private static final CachedValueProvider.Result getPlaywrightConfigurationPropertyValueElement$lambda$5$lambda$4(PsiFile $configurationFilePsi, String $propertyName) {
        JSElement jSElement;
        if ($configurationFilePsi instanceof JSFile) {
            PlaywrightConfigurationFilePropertyReader playwrightConfigurationFilePropertyReader;
            PlaywrightConfigurationFilePropertyReader it = playwrightConfigurationFilePropertyReader = new PlaywrightConfigurationFilePropertyReader($propertyName);
            boolean bl = false;
            $configurationFilePsi.accept((PsiElementVisitor)it);
            jSElement = playwrightConfigurationFilePropertyReader.getPropertyValue();
        } else {
            jSElement = null;
        }
        JSElement configurationElement = jSElement;
        Object[] objectArray = new Object[]{$configurationFilePsi};
        return CachedValueProvider.Result.create(configurationElement, (Object[])objectArray);
    }
}

