/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class QUnitFileStructureBuilder
extends AbstractTestFileStructureBuilder<QUnitFileStructure> {
    private static final QUnitFileStructureBuilder INSTANCE = new QUnitFileStructureBuilder();
    public static final String MODULE_NAME = "module";
    public static final String TEST_NAME = "test";
    public static final String ASYNC_TEST_NAME = "asyncTest";
    public static final String SUITE_NAME = "suite";

    @Override
    @NotNull
    public QUnitFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            QUnitFileStructureBuilder.$$$reportNull$$$0(0);
        }
        QUnitFileStructure qUnitFileStructure = new Builder(jsFile).build();
        if (qUnitFileStructure == null) {
            QUnitFileStructureBuilder.$$$reportNull$$$0(1);
        }
        return qUnitFileStructure;
    }

    public static QUnitFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructureBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructureBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTestFileStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTestFileStructure";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class Builder {
        private final QUnitFileStructure myFileStructure;
        @NotNull
        private AbstractQUnitModuleStructure myCurrentModuleStructure;

        private Builder(@NotNull JSFile jsFile) {
            if (jsFile == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myFileStructure = new QUnitFileStructure(jsFile);
            this.myCurrentModuleStructure = this.myFileStructure.getDefaultModuleStructure();
        }

        public QUnitFileStructure build() {
            if (JsPsiUtils.mightContainGlobalCall(this.myFileStructure.getJsFile(), QUnitFileStructureBuilder.TEST_NAME, false)) {
                List<JSStatement> jsStatements = JsPsiUtils.listStatementsInExecutionOrder(this.myFileStructure.getJsFile());
                for (JSStatement jsStatement : jsStatements) {
                    this.update(jsStatement);
                }
            }
            this.myFileStructure.postProcess();
            return this.myFileStructure;
        }

        private void update(JSElement jsElement) {
            JSCallExpression callExpression;
            JSExpressionStatement expressionStatement = (JSExpressionStatement)ObjectUtils.tryCast((Object)jsElement, JSExpressionStatement.class);
            if (expressionStatement != null && (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), JSCallExpression.class)) != null) {
                this.updateJsCallExpression(callExpression);
            }
        }

        private void updateJsCallExpression(@NotNull JSCallExpression callExpression) {
            if (callExpression == null) {
                Builder.$$$reportNull$$$0(1);
            }
            JSReferenceExpression methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
            JSArgumentList argumentList = callExpression.getArgumentList();
            if (methodExpression != null && methodExpression.getQualifier() == null && argumentList != null) {
                String name;
                String methodName = methodExpression.getReferenceName();
                JSExpression[] arguments = (JSExpression[])ObjectUtils.notNull((Object)argumentList.getArguments(), (Object)JSExpression.EMPTY_ARRAY);
                if (arguments.length >= 1 && (name = JsPsiUtils.getPrettyText(arguments[0])) != null) {
                    JSFunctionExpression body;
                    JSLiteralExpression nameLiteralExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)arguments[0], JSLiteralExpression.class);
                    LeafPsiElement nameLeafPsiElement = null;
                    if (nameLiteralExpression != null) {
                        nameLeafPsiElement = (LeafPsiElement)ObjectUtils.tryCast((Object)nameLiteralExpression.getFirstChild(), LeafPsiElement.class);
                    }
                    if (QUnitFileStructureBuilder.MODULE_NAME.equals(methodName) || QUnitFileStructureBuilder.SUITE_NAME.equals(methodName)) {
                        boolean ok = arguments.length == 1;
                        JSObjectLiteralExpression lifecycleObjectLiteral = null;
                        if (arguments.length == 2 && (lifecycleObjectLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)arguments[1], JSObjectLiteralExpression.class)) != null) {
                            ok = true;
                        }
                        if (ok) {
                            QUnitModuleStructure moduleStructure = new QUnitModuleStructure(this.myFileStructure, name, callExpression, lifecycleObjectLiteral, nameLeafPsiElement);
                            this.myFileStructure.addModuleStructure(moduleStructure);
                            this.myCurrentModuleStructure = moduleStructure;
                        }
                    } else if ((QUnitFileStructureBuilder.TEST_NAME.equals(methodName) || QUnitFileStructureBuilder.ASYNC_TEST_NAME.equals(methodName)) && arguments.length == 2 && (body = JsPsiUtils.extractFunctionExpression(arguments[1])) != null) {
                        QUnitTestMethodStructure testMethodStructure = new QUnitTestMethodStructure(this.myCurrentModuleStructure, name, callExpression, nameLeafPsiElement);
                        this.myCurrentModuleStructure.addTestMethodStructure(testMethodStructure);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructureBuilder$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateJsCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

