/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.icons.AllIcons;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMethodHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private Icon myRawIcon;
    private Icon myStateIcon;
    private JSMethodHierarchyTreeStructure myTreeStructure;

    public JSMethodHierarchyNodeDescriptor(@NotNull Project project, @Nullable HierarchyNodeDescriptor parentDescriptor, @NotNull JSPsiElementBase aClass, boolean isBase, JSMethodHierarchyTreeStructure treeStructure) {
        if (project == null) {
            JSMethodHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            JSMethodHierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        super(project, (NodeDescriptor)parentDescriptor, (PsiElement)aClass, isBase);
        this.myTreeStructure = treeStructure;
    }

    public void setTreeStructure(JSMethodHierarchyTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
    }

    public JSPsiElementBase getJSClass() {
        return (JSPsiElementBase)this.getPsiElement();
    }

    public PsiElement getTargetElement() {
        JSPsiElementBase aClass = this.getJSClass();
        if (aClass == null || !aClass.isValid()) {
            return null;
        }
        JSFunction baseMethod = this.myTreeStructure.getBaseMethod();
        if (baseMethod == null) {
            return null;
        }
        JSFunctionItem method = JSMethodHierarchyUtil.findMethodInClass(baseMethod, aClass, false);
        if (method != null) {
            return method;
        }
        return aClass;
    }

    public boolean update() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        JSPsiElementBase jsClass = this.getJSClass();
        if (jsClass == null) {
            return this.invalidElement();
        }
        Icon newRawIcon = jsClass.getIcon(flags);
        Icon newStateIcon = this.calculateState(jsClass);
        if (changes || newRawIcon != this.myRawIcon || newStateIcon != this.myStateIcon) {
            changes = true;
            this.myRawIcon = newRawIcon;
            this.myStateIcon = newStateIcon;
            Icon newIcon = this.myRawIcon;
            if (this.myIsBase) {
                newIcon = this.getBaseMarkerIcon(newIcon);
            }
            if (this.myStateIcon != null) {
                newIcon = IconManager.getInstance().createRowIcon(new Icon[]{this.myStateIcon, newIcon});
            }
            this.setIcon(newIcon);
        }
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(jsClass.getName(), classNameAttributes);
        this.myHighlightedText.getEnding().addText(" (" + StringUtil.getPackageName((String)jsClass.getQualifiedName()) + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private Icon calculateState(JSPsiElementBase jsClass) {
        boolean hasBaseImplementation;
        if (jsClass.isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE) {
            return null;
        }
        JSFunction baseMethod = this.myTreeStructure.getBaseMethod();
        if (baseMethod == null) {
            return null;
        }
        JSFunctionItem method = JSMethodHierarchyUtil.findMethodInClass(baseMethod, jsClass, false);
        if (method != null) {
            return AllIcons.Hierarchy.MethodDefined;
        }
        JSFunctionItem baseClassMethod = JSMethodHierarchyUtil.findMethodInClass(baseMethod, jsClass, true);
        boolean bl = hasBaseImplementation = baseClassMethod != null;
        if (hasBaseImplementation) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        return AllIcons.Hierarchy.ShouldDefineMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyNodeDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

