/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptObjectJSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSThisType;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveReadonlyArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptIntrinsicJSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverTypeImpl;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSSpecialNamedTypeImpl
extends JSNamedType
implements JSUtilType {
    public static final Key<JSType> STRING_KEY = Key.create((String)"js.type.cache.string");
    public static final Key<JSType> NUMBER_KEY = Key.create((String)"js.type.cache.number");
    public static final Key<JSType> BOOLEAN_KEY = Key.create((String)"js.type.cache.boolean");
    public static final Key<JSType> SYMBOL_KEY = Key.create((String)"js.type.cache.symbol");
    public static final Key<JSType> BIGINT_KEY = Key.create((String)"js.type.cache.bigint");
    public static final Key<JSType> NULL_KEY = Key.create((String)"js.type.cache.null");
    public static final Key<JSType> UNDEFINED_KEY = Key.create((String)"js.type.cache.undefined");
    public static final Key<JSType> VOID_KEY = Key.create((String)"js.type.cache.void");
    public static final Key<JSType> INTRINSIC_KEY = Key.create((String)"js.type.cache.intrinsic");
    public static final Key<JSType> NEVER_KEY = Key.create((String)"js.type.cache.never");

    protected JSSpecialNamedTypeImpl(@NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance) {
        if (source == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(0);
        }
        if (staticOrInstance == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(1);
        }
        super(source, staticOrInstance);
    }

    protected JSSpecialNamedTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
    }

    @Nullable
    public static JSType getSpecialType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean isFromJSDoc) {
        String typeStringUnified;
        if (typeString == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(4);
        }
        if (source == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(5);
        }
        if (staticOrInstance == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(6);
        }
        switch (typeString) {
            case "string": {
                return JSSpecialNamedTypeImpl.createPrimitiveType(JSStringType::new, STRING_KEY, source, staticOrInstance);
            }
            case "number": {
                return JSSpecialNamedTypeImpl.createPrimitiveType(JSNumberType::new, NUMBER_KEY, source, staticOrInstance);
            }
            case "boolean": {
                return JSSpecialNamedTypeImpl.createPrimitiveType(JSBooleanType::new, BOOLEAN_KEY, source, staticOrInstance);
            }
            case "symbol": {
                return JSSpecialNamedTypeImpl.createPrimitiveType(JSSymbolType::new, SYMBOL_KEY, source, staticOrInstance);
            }
            case "bigint": {
                return JSSpecialNamedTypeImpl.createPrimitiveType(JSBigIntType::new, BIGINT_KEY, source, staticOrInstance);
            }
            case "null": {
                return JSSpecialNamedTypeImpl.createSimpleType(JSNullType::new, NULL_KEY, source);
            }
            case "undefined": {
                return JSSpecialNamedTypeImpl.createSimpleType(JSUndefinedType::new, UNDEFINED_KEY, source);
            }
            case "void": {
                return JSSpecialNamedTypeImpl.createSimpleType(JSVoidType::new, VOID_KEY, source);
            }
            case "intrinsic": {
                return JSSpecialNamedTypeImpl.createSimpleType(TypeScriptIntrinsicJSTypeImpl::new, INTRINSIC_KEY, source);
            }
            case "never": {
                return JSSpecialNamedTypeImpl.createSimpleType(TypeScriptNeverTypeImpl::new, NEVER_KEY, source);
            }
        }
        if (source.isTypeScript() && "object".equals(typeString)) {
            return new TypeScriptObjectJSTypeImpl(source, staticOrInstance);
        }
        String string = typeStringUnified = isFromJSDoc ? JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(typeString) : typeString;
        if (!source.isTypeScript()) {
            switch (typeStringUnified) {
                case "String": {
                    return new JSStringType(false, source, staticOrInstance);
                }
                case "Number": {
                    return new JSNumberType(false, source, staticOrInstance);
                }
                case "Boolean": {
                    return new JSBooleanType(false, source, staticOrInstance);
                }
                case "BigInt": {
                    return new JSBigIntType(false, source, staticOrInstance);
                }
            }
        }
        switch (typeStringUnified) {
            case "Object": {
                return new JSObjectType(source, staticOrInstance);
            }
            case "Array": {
                return new JSPrimitiveArrayType(source, staticOrInstance);
            }
            case "ReadonlyArray": {
                return new JSPrimitiveReadonlyArrayType(source, staticOrInstance);
            }
            case "unique symbol": {
                return new JSUniqueSymbolTypeImpl(source, staticOrInstance, false);
            }
        }
        if (isFromJSDoc && "this".equals(typeStringUnified)) {
            return new JSThisType(source);
        }
        if (JSCommonTypeNames.FUNCTION_CLASS_NAMES.contains(typeStringUnified)) {
            return new JSPrimitiveFunctionType(source, staticOrInstance);
        }
        if (!source.isTypeScript()) {
            if ("int".equals(typeString)) {
                return new JSIntType(true, source, staticOrInstance);
            }
            if ("Integer".equals(typeString)) {
                return new JSIntType(false, source, staticOrInstance);
            }
            if ("uint".equals(typeStringUnified)) {
                return new JSUintType(source, staticOrInstance);
            }
        }
        if (source.isEcma()) {
            return null;
        }
        return switch (typeStringUnified) {
            case "true" -> new JSBooleanLiteralTypeImpl(true, false, source);
            case "false" -> new JSBooleanLiteralTypeImpl(false, false, source);
            case "unknown" -> {
                if (source.isTypeScript()) {
                    yield JSUnknownType.TS_INSTANCE;
                }
                yield JSUnknownType.JS_INSTANCE;
            }
            case "object" -> {
                if (source.isTypeScript()) {
                    yield new TypeScriptObjectJSTypeImpl(source, staticOrInstance);
                }
                yield null;
            }
            default -> null;
        };
    }

    @NotNull
    private static JSType createPrimitiveType(@NotNull SpecialPrimitiveTypeFactory factory, @NotNull Key<JSType> key, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance) {
        PsiElement element2;
        if (factory == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(7);
        }
        if (key == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(8);
        }
        if (source == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(9);
        }
        if (staticOrInstance == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(10);
        }
        if (staticOrInstance == JSTypeContext.INSTANCE && (element2 = JSSpecialNamedTypeImpl.getGenericSourceElement(source)) != null) {
            JSType data2 = (JSType)element2.getUserData(key);
            if (data2 != null) {
                JSType jSType = data2;
                if (jSType == null) {
                    JSSpecialNamedTypeImpl.$$$reportNull$$$0(11);
                }
                return jSType;
            }
            data2 = factory.createType(true, JSTypeSourceFactory.copyTypeSource(source, element2), staticOrInstance);
            element2.putUserData(key, (Object)data2);
            JSType jSType = data2;
            if (jSType == null) {
                JSSpecialNamedTypeImpl.$$$reportNull$$$0(12);
            }
            return jSType;
        }
        JSType jSType = factory.createType(true, source, staticOrInstance);
        if (jSType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @NotNull
    private static JSType createSimpleType(@NotNull SpecialSimpleTypeFactory factory, @NotNull Key<JSType> key, @NotNull JSTypeSource source) {
        PsiElement element2;
        if (factory == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(14);
        }
        if (key == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(15);
        }
        if (source == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(16);
        }
        if ((element2 = JSSpecialNamedTypeImpl.getGenericSourceElement(source)) != null) {
            JSType data2 = (JSType)element2.getUserData(key);
            if (data2 != null) {
                JSType jSType = data2;
                if (jSType == null) {
                    JSSpecialNamedTypeImpl.$$$reportNull$$$0(17);
                }
                return jSType;
            }
            data2 = factory.createType(JSTypeSourceFactory.copyTypeSource(source, element2));
            element2.putUserData(key, (Object)data2);
            JSType jSType = data2;
            if (jSType == null) {
                JSSpecialNamedTypeImpl.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        JSType jSType = factory.createType(source);
        if (jSType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @Nullable
    private static PsiElement getGenericSourceElement(@NotNull JSTypeSource source) {
        if (source == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(20);
        }
        PsiElement element2 = source.getSourceElement();
        if (source.isStrict() && element2 != null && !(element2 instanceof JSDocComment) && !(element2 instanceof JSExpression) && !source.isEcma()) {
            PsiFile scope2 = source.getScope();
            return scope2 instanceof JSFile ? scope2 : ES6PsiUtil.getNonStrictExportScope(element2);
        }
        return null;
    }

    @Override
    public JSClass resolveClass() {
        if (!this.isEcma()) {
            return null;
        }
        PsiElement clazz = JSResolveUtil.findType(JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(this.getResolvedTypeText()), (PsiElement)this.getScope(), this.isEcma());
        return clazz instanceof JSClass ? (JSClass)clazz : null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSResolvedTypeInfo resolvedType;
        if (elementType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(21);
        }
        if (processingContext == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(22);
        }
        if (elementType instanceof JSSpecialNamedTypeImpl) {
            return this.isEquivalentTo(elementType, processingContext) || this.getClass().equals(elementType.getClass()) && this.getTypeHelper().areNamedTypesAssignable(this, (JSSpecialNamedTypeImpl)elementType, processingContext);
        }
        if (elementType instanceof JSResolvableType && (resolvedType = ((JSResolvableType)elementType).resolveType()).isEnum()) {
            return this instanceof JSNumberType;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(23);
        }
        boolean fromSuper = super.isEquivalentToWithSameClass(type2, context2, allowResolve);
        if (!allowResolve || !fromSuper) {
            return fromSuper;
        }
        if (context2 != null && context2.get(EQ_SKIP_SCOPE) == Boolean.TRUE) {
            return true;
        }
        JSTypeSource source = this.getSource();
        JSTypeSource otherSource = type2.getSource();
        if (Objects.equals(source.getScope(), otherSource.getScope())) {
            return true;
        }
        Object own = this.getScopeId();
        Object other = ((JSSpecialNamedTypeImpl)type2).getScopeId();
        return own.equals(other);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(25);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSSpecialNamedTypeImpl.$$$reportNull$$$0(26);
            }
            return assignableResult;
        }
        if (elementType instanceof JSTypeImpl) {
            JSTypeCastUtil.AssignableResult assignableResult = this.isDirectAssignableWithNamedType((JSNamedType)elementType, processingContext);
            if (assignableResult == null) {
                JSSpecialNamedTypeImpl.$$$reportNull$$$0(27);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = result2;
        if (assignableResult == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(28);
        }
        return assignableResult;
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectAssignableWithNamedType(@NotNull JSNamedType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(29);
        }
        if (processingContext == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(30);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().areNamedTypesAssignable(this, elementType, processingContext));
        if (assignableResult == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(31);
        }
        return assignableResult;
    }

    @Override
    @NotNull
    protected String getQualifiedNameText() {
        String string = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        if (string == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 17, 18, 19, 26, 27, 28, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl";
                break;
            }
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 22: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrimitiveType";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectAssignableWithNamedType";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSourceElement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableWithNamedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 17, 18, 19, 26, 27, 28, 31, 32 -> new IllegalStateException(string);
        };
    }

    static interface SpecialPrimitiveTypeFactory {
        @NotNull
        public JSType createType(boolean var1, JSTypeSource var2, JSTypeContext var3);
    }

    static interface SpecialSimpleTypeFactory {
        @NotNull
        public JSType createType(JSTypeSource var1);
    }
}

