/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTupleTypeImpl
extends JSTypeBaseImpl
implements JSTupleType {
    private final boolean myStrict;
    private final boolean myReadonly;
    private final int myFirstOptional;
    private final List<String> myNames;
    private final List<JSType> myTypes;

    @ApiStatus.Internal
    public JSTupleTypeImpl(JSTypeSource source, List<? extends JSType> types, List<String> names, boolean strict, int firstOptional, boolean isReadonly) {
        super(source);
        this.myTypes = types.stream().map(el -> JSCompositeTypeBaseImpl.asNotNull(el, source)).toList();
        assert (names.isEmpty() || types.size() == names.size());
        this.myNames = names;
        this.myStrict = strict;
        this.myFirstOptional = firstOptional;
        this.myReadonly = isReadonly;
    }

    JSTupleTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(1);
        }
        super(source);
        this.myTypes = JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream);
        this.myStrict = JSTypeSerializer.readBoolean(inputStream);
        this.myReadonly = JSTypeSerializer.readBoolean(inputStream);
        this.myFirstOptional = JSTypeSerializer.readInt(inputStream);
        this.myNames = JSTypeSerializer.STRING_LIST.read(source, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(2);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myTypes, outputStream);
        JSTypeSerializer.writeBoolean(this.myStrict, outputStream);
        JSTypeSerializer.writeBoolean(this.myReadonly, outputStream);
        JSTypeSerializer.writeInt(this.myFirstOptional, outputStream);
        JSTypeSerializer.STRING_LIST.write(this.myNames, outputStream);
    }

    @Override
    @NotNull
    protected String getTypeSeparator(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(3);
        }
        String separatorChar = ",";
        Object object = format == JSType.TypeTextFormat.PRESENTABLE || this.isTypeScript() && format == JSType.TypeTextFormat.CODE ? separatorChar + " " : separatorChar;
        if (object == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    public int getOptionalStart() {
        return this.myFirstOptional;
    }

    @Override
    public int getMinLength() {
        if (this.myFirstOptional != -1) {
            return this.myFirstOptional;
        }
        List<JSType> types = this.getTypes();
        for (int i = types.size() - 1; i >= 0; --i) {
            JSType type2 = types.get(i);
            if (!JSTupleTypeImpl.isRest(type2)) continue;
            return i;
        }
        return types.size();
    }

    @Override
    public int getMaxLength() {
        List<JSType> types = this.getTypes();
        if (!types.isEmpty() && ContainerUtil.exists(types, el -> JSTupleTypeImpl.isVariableType(el))) {
            return Integer.MAX_VALUE;
        }
        return types.size();
    }

    @Override
    @NotNull
    public List<JSType> getTypes() {
        List<JSType> list = this.myTypes;
        if (list == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public boolean isReadonly() {
        return this.myReadonly;
    }

    @Override
    @NotNull
    public List<String> getNames() {
        List<String> list = this.myNames;
        if (list == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean allowWidening() {
        return !this.myStrict;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(7);
        }
        if (builder2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(8);
        }
        if (this.isTypeScript() && this.isReadonly()) {
            builder2.append("readonly ");
        }
        builder2.append("[");
        String delimiter = this.getTypeSeparator(format);
        List<JSType> toProcess = this.getTypes();
        for (int i = 0; i < toProcess.size(); ++i) {
            JSType currentType = toProcess.get(i);
            if (i != 0) {
                builder2.append(delimiter);
            }
            this.buildNestedTypePresentation(currentType, i, format, builder2);
        }
        builder2.append("]");
    }

    @Override
    @NotNull
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(9);
        }
        List<JSType> types = this.getTypes();
        ArrayList<JSType> newTypes = new ArrayList<JSType>(types.size());
        for (JSType type2 : types) {
            JSTupleType tupleType;
            JSType substitute = context2.substituteNested(type2);
            if (substitute instanceof JSSpreadType && (tupleType = (JSTupleType)ObjectUtils.tryCast((Object)((JSSpreadType)((Object)substitute)).getInnerType(), JSTupleType.class)) != null) {
                newTypes.addAll(tupleType.getTypes());
                continue;
            }
            newTypes.add(substitute);
        }
        if (ContainerUtil.equalsIdentity(types, newTypes)) {
            JSTupleTypeImpl jSTupleTypeImpl = this;
            if (jSTupleTypeImpl == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(10);
            }
            return jSTupleTypeImpl;
        }
        List newNames = !this.myNames.isEmpty() && this.myNames.size() != newTypes.size() ? ContainerUtil.emptyList() : this.myNames;
        JSType jSType = JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, newNames, this.myStrict, this.myFirstOptional, this.myReadonly);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        List<JSType> oldTypes;
        List newTypes;
        if (childTransform == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(12);
        }
        if (newSource == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(13);
        }
        if (ContainerUtil.equalsIdentity((List)(newTypes = ContainerUtil.map(oldTypes = this.getTypes(), t -> JSTypeUtils.transformTypeHierarchySafe(t, childTransform))), oldTypes)) {
            JSTupleTypeImpl jSTupleTypeImpl = this;
            if (jSTupleTypeImpl == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(14);
            }
            return jSTupleTypeImpl;
        }
        return this.createType(newTypes, newSource);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(15);
        }
        for (JSType type2 : this.getTypes()) {
            type2.accept(visitor);
        }
    }

    private void buildNestedTypePresentation(@NotNull JSType t, int index, @NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        String name;
        JSType resType;
        boolean wrap;
        if (t == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(16);
        }
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(17);
        }
        if (builder2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(18);
        }
        if (wrap = JSTupleTypeImpl.shouldWrapNestedType(resType = this.shouldUniteWithUndefinedForOptional(index) ? JSTupleTypeImpl.uniteWithUndefined(t) : t)) {
            builder2.append("(");
        }
        String string = name = this.myNames.size() > index ? this.myNames.get(index) : null;
        if (name != null) {
            builder2.append(name).append(": ");
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE && resType instanceof JSNullType) {
            builder2.append("*");
        } else {
            resType.buildTypeText(format, builder2);
        }
        if (wrap) {
            builder2.append(")");
        }
    }

    private static boolean shouldWrapNestedType(JSType type2) {
        return false;
    }

    private boolean shouldUniteWithUndefinedForOptional(int index) {
        List<JSType> types = this.getTypes();
        if (index < 0 || this.myFirstOptional < 0 || index < this.myFirstOptional || index >= types.size()) {
            return false;
        }
        JSType type2 = types.get(index);
        return !(type2 instanceof JSSpreadType) && !(type2 instanceof JSUndefinedType);
    }

    @NotNull
    private JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource) {
        if (transformedTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(19);
        }
        if (newSource == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(20);
        }
        JSType jSType = JSCompositeTypeFactory.createTupleType(newSource, transformedTypes, this.myNames, this.myStrict, this.myFirstOptional, this.myReadonly);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(21);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(22);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(23);
        }
        if (!this.myStrict) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        if ((elementType instanceof JSTupleType || elementType instanceof JSArrayType) && this.isInferenceForNestedTypes(processingContext)) {
            return this.inferGenericsWithTupleOrArray(elementType, processingContext);
        }
        if (!(elementType instanceof JSTupleType)) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        if (!this.myReadonly && ((JSTupleType)elementType).isReadonly()) {
            return false;
        }
        List<JSType> elementTypes = ((JSTupleType)elementType).getTypes();
        List<JSType> currentTypes = this.getTypes();
        int min = Math.min(elementTypes.size(), currentTypes.size());
        for (int i = 0; i < min; ++i) {
            JSType nestedElement;
            JSType nestedCurrent = currentTypes.get(i);
            if (nestedCurrent instanceof JSSpreadType) {
                nestedCurrent = ((JSSpreadType)((Object)nestedCurrent)).getComponentType();
            }
            if ((nestedElement = elementTypes.get(i)) instanceof JSSpreadType) {
                nestedElement = ((JSSpreadType)((Object)nestedElement)).getComponentType();
            }
            if (nestedCurrent.isDirectlyAssignableType(nestedElement, processingContext)) continue;
            return false;
        }
        if (currentTypes.size() == elementTypes.size()) {
            JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
            JSType lastOther = (JSType)ContainerUtil.getLastItem(elementTypes);
            if (this.isTypeScript() && lastOther instanceof JSSpreadType && lastCurrent != null && !(lastCurrent instanceof JSSpreadType)) {
                return false;
            }
        }
        if (currentTypes.size() < elementTypes.size()) {
            JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
            if (!(lastCurrent instanceof JSSpreadType)) {
                return !this.isTypeScript();
            }
            if (currentTypes.size() - elementTypes.size() + 1 == 0 && ContainerUtil.getLastItem(elementTypes) instanceof JSSpreadType) {
                return true;
            }
            return !this.isTypeScript() || JSTupleTypeImpl.checkWithSpreads(processingContext, elementTypes, min, ((JSSpreadType)((Object)lastCurrent)).getComponentType(), false);
        }
        if (elementTypes.size() < currentTypes.size()) {
            JSType lastItem = (JSType)ContainerUtil.getLastItem(elementTypes);
            if (!(lastItem instanceof JSSpreadType)) {
                return this.myFirstOptional != -1 && min >= this.myFirstOptional || elementTypes.size() - currentTypes.size() + 1 == 0 && ContainerUtil.getLastItem(currentTypes) instanceof JSSpreadType;
            }
            JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
            if (this.isTypeScript() && lastCurrent instanceof JSSpreadType) {
                return false;
            }
            JSType componentType = ((JSSpreadType)((Object)lastItem)).getComponentType();
            return JSTupleTypeImpl.checkWithSpreads(processingContext, currentTypes, min, componentType, true);
        }
        return true;
    }

    private boolean isInferenceForNestedTypes(@NotNull ProcessingContext processingContext) {
        List generics;
        JSGenericMappings mappings;
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(24);
        }
        return (mappings = JSGenericTypesEvaluator.getGenericMappings(processingContext)) != null && !(generics = StreamEx.of(this.getTypes()).map(el -> el instanceof JSSpreadType ? ((JSSpreadType)((Object)el)).getInnerType() : null).select(JSGenericParameterType.class).toList()).isEmpty() && ContainerUtil.exists((Iterable)generics, el -> el.isApplying());
    }

    private static boolean areTupleTypesDefinitelyUnrelated(@NotNull JSTupleType thisType, @NotNull JSTupleType otherType) {
        if (thisType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(25);
        }
        if (otherType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(26);
        }
        if (!JSTupleTypeImpl.hasVariadic(thisType) && thisType.getMinLength() > otherType.getMinLength()) {
            return true;
        }
        if (JSTupleTypeImpl.hasRest(thisType)) {
            return !JSTupleTypeImpl.hasRest(otherType) || JSTupleTypeImpl.getFixedLength(thisType.getTypes()) < JSTupleTypeImpl.getFixedLength(otherType.getTypes());
        }
        return false;
    }

    private static boolean hasRest(@NotNull JSTupleType thisType) {
        if (thisType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(27);
        }
        for (JSType type2 : thisType.getTypes()) {
            if (!JSTupleTypeImpl.isRest(type2)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasVariadic(@NotNull JSTupleType thisType) {
        if (thisType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(28);
        }
        for (JSType type2 : thisType.getTypes()) {
            if (!JSTupleTypeImpl.isVariadic(type2)) continue;
            return true;
        }
        return false;
    }

    private boolean inferGenericsWithTupleOrArray(@NotNull JSType sourceType, @NotNull ProcessingContext processingContext) {
        int i;
        boolean targetHasVariables;
        if (sourceType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(29);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(30);
        }
        if (!(sourceType instanceof JSTupleType) && !(sourceType instanceof JSArrayType)) {
            return true;
        }
        JSTupleType sourceTuple = (JSTupleType)ObjectUtils.tryCast((Object)sourceType, JSTupleType.class);
        if (sourceTuple != null && JSTupleTypeImpl.areTupleTypesDefinitelyUnrelated(this, sourceTuple)) {
            return false;
        }
        List<JSType> targetTypes = this.getTypes();
        List<Object> sourceTypes = sourceTuple != null ? sourceTuple.getTypes() : Collections.emptyList();
        int sourceArity = sourceTypes.size();
        int targetArity = targetTypes.size();
        if (sourceTuple != null && this.isTupleTypeStructureMatching(sourceTuple)) {
            for (int i2 = 0; i2 < targetTypes.size(); ++i2) {
                JSType otherNestedType = (JSType)sourceTypes.get(i2);
                JSType thisNestedType = targetTypes.get(i2);
                if (thisNestedType.isDirectlyAssignableType(otherNestedType, processingContext)) continue;
                return false;
            }
            return true;
        }
        int sourceFixedLength = sourceTuple != null ? JSTupleTypeImpl.getFixedLength(sourceTypes) : 0;
        int targetFixedLength = JSTupleTypeImpl.getFixedLength(targetTypes);
        int startLength = Math.min(sourceFixedLength, targetFixedLength);
        JSType sourceRestComponent = sourceTuple != null ? JSTupleTypeImpl.getSourceRestType(sourceTypes, sourceArity) : ((JSArrayType)sourceType).getType();
        boolean bl = targetHasVariables = targetFixedLength != targetArity;
        int endLength = !targetHasVariables ? 0 : (sourceRestComponent != null ? JSTupleTypeImpl.getEndLengthOfType(this) : Math.min(JSTupleTypeImpl.getEndLengthOfType(this), sourceTuple != null ? JSTupleTypeImpl.getEndLengthOfType(sourceTuple) : 0));
        int sourceEndLength = sourceRestComponent != null ? 0 : endLength;
        for (i = 0; i < startLength; ++i) {
            JSType otherNestedType = (JSType)sourceTypes.get(i);
            JSType thisNestedType = targetTypes.get(i);
            if (thisNestedType.isDirectlyAssignableType(otherNestedType, processingContext)) continue;
            return false;
        }
        if (sourceRestComponent != null && sourceArity - startLength == 1) {
            for (i = startLength; i < targetArity - endLength; ++i) {
                JSType toProcess;
                JSType targetNested = targetTypes.get(i);
                JSType jSType = toProcess = JSTupleTypeImpl.isVariadic(targetNested) ? new JSArrayTypeImpl(sourceRestComponent, sourceRestComponent.getSource()) : sourceRestComponent;
                if (targetNested.isDirectlyAssignableType(toProcess, processingContext)) continue;
                return false;
            }
        } else {
            int middleLength = targetArity - startLength - endLength;
            if (middleLength == 2) {
                if (sourceTuple != null && targetArity > startLength + 1) {
                    JSType startType0 = targetTypes.get(startLength);
                    JSType startType1 = targetTypes.get(startLength + 1);
                    if (JSTupleTypeImpl.isVariadic(startType1) && JSTupleTypeImpl.isVariadic(startType0)) {
                        JSType innerType0 = ((JSSpreadType)((Object)startType0)).getInnerType();
                        JSType innerType1 = ((JSSpreadType)((Object)startType1)).getInnerType();
                        int arity = JSGenericTypesEvaluator.getImpliedArity(innerType0, processingContext);
                        if (arity != -1) {
                            JSType first = this.sliceTupleType(sourceTuple, startLength, sourceEndLength + sourceArity - arity);
                            if (!innerType0.isDirectlyAssignableType(first, processingContext)) {
                                return false;
                            }
                            JSType second = this.sliceTupleType(sourceTuple, startLength + arity, sourceEndLength);
                            if (!innerType1.isDirectlyAssignableType(second, processingContext)) {
                                return false;
                            }
                        }
                    }
                }
            } else if (middleLength == 1 && targetArity > startLength) {
                JSType type2 = targetTypes.get(startLength);
                if (JSTupleTypeImpl.isVariadic(type2)) {
                    JSType sourceSlice = sourceTuple != null ? this.sliceTupleType(sourceTuple, startLength, sourceEndLength) : sourceType;
                    JSType innerType = ((JSSpreadType)((Object)type2)).getInnerType();
                    if (!innerType.isDirectlyAssignableType(sourceSlice, processingContext)) {
                        return false;
                    }
                } else if (JSTupleTypeImpl.isRest(type2)) {
                    JSType nestedType = sourceRestComponent;
                    if (nestedType == null && sourceTuple != null) {
                        JSType arrayType;
                        JSType arrayOrTuple = this.sliceTupleType(sourceTuple, startLength, sourceEndLength);
                        JSType jSType = arrayType = arrayOrTuple instanceof JSTupleType ? ((JSTupleType)arrayOrTuple).toArrayType(false) : arrayOrTuple;
                        if (arrayType instanceof JSArrayType) {
                            nestedType = ((JSArrayType)arrayType).getType();
                        }
                    }
                    if (nestedType != null && !type2.isDirectlyAssignableType(nestedType, processingContext)) {
                        return false;
                    }
                }
            }
        }
        for (i = 0; i < endLength; ++i) {
            JSType sourceNestedType = sourceRestComponent != null || sourceTuple == null ? sourceRestComponent : (JSType)sourceTypes.get(sourceArity - i - 1);
            JSType targetNestedType = targetTypes.get(targetArity - i - 1);
            if (targetNestedType.isDirectlyAssignableType(sourceNestedType, processingContext)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private JSType sliceTupleType(@NotNull JSTupleType type2, int index, int endSkipCount) {
        if (type2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(31);
        }
        List<JSType> types = type2.getTypes();
        List<String> names = type2.getNames();
        int endIndex = endSkipCount > 0 ? types.size() - endSkipCount : types.size();
        JSTypeSource source = this.getSource();
        if (index > JSTupleTypeImpl.getFixedLength(types)) {
            JSType last = (JSType)ContainerUtil.getLastItem(types);
            if (JSTupleTypeImpl.isRest(last)) {
                JSSpreadType spread = (JSSpreadType)((Object)last);
                JSType jSType = spread.getInnerType();
                if (jSType == null) {
                    JSTupleTypeImpl.$$$reportNull$$$0(32);
                }
                return jSType;
            }
            return new JSArrayTypeImpl(JSAnyType.get(source), source);
        }
        List<JSType> newTypes = types.subList(index, endIndex);
        List<String> newNames = !names.isEmpty() ? names.subList(index, endIndex) : names;
        return new JSTupleTypeImpl(source, newTypes, newNames, !this.allowWidening(), this.myFirstOptional < newTypes.size() ? this.myFirstOptional : -1, this.isReadonly());
    }

    @Nullable
    private static JSType getSourceRestType(@NotNull List<JSType> sourceTypes, int sourceArity) {
        if (sourceTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(33);
        }
        if (sourceArity > 0 && JSTupleTypeImpl.isRest(sourceTypes.get(sourceArity - 1))) {
            JSSpreadType type2 = (JSSpreadType)ObjectUtils.tryCast((Object)sourceTypes.get(sourceArity - 1), JSSpreadType.class);
            return type2 != null ? type2.getComponentType() : null;
        }
        return null;
    }

    private static int getEndLengthOfType(@NotNull JSTupleType type2) {
        if (type2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(34);
        }
        List<JSType> types = type2.getTypes();
        int arity = types.size();
        for (int i = types.size() - 1; i >= 0; --i) {
            if (!JSTupleTypeImpl.isVariableType(types.get(i))) continue;
            return arity - i - 1;
        }
        return types.size();
    }

    private static int getFixedLength(@NotNull List<JSType> types) {
        if (types == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(35);
        }
        int size = types.size();
        for (int i = 0; i < size; ++i) {
            if (!JSTupleTypeImpl.isVariableType(types.get(i))) continue;
            return i;
        }
        return types.size();
    }

    private boolean isTupleTypeStructureMatching(@NotNull JSTupleType elementType) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(36);
        }
        List<JSType> ownTypes = this.getTypes();
        List<JSType> otherTypes = elementType.getTypes();
        if (ownTypes.size() != otherTypes.size()) {
            return false;
        }
        for (int i = 0; i < ownTypes.size(); ++i) {
            JSType otherNestedType = otherTypes.get(i);
            JSType thisNestedType = ownTypes.get(i);
            if (JSTupleTypeImpl.isVariableType(otherNestedType) == JSTupleTypeImpl.isVariableType(thisNestedType)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkWithSpreads(@NotNull ProcessingContext processingContext, @NotNull List<JSType> currentTypes, int min, @NotNull JSType componentType, boolean forward) {
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(37);
        }
        if (currentTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(38);
        }
        if (componentType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(39);
        }
        for (int i = min; i < currentTypes.size(); ++i) {
            JSType type2 = currentTypes.get(i);
            if (type2 instanceof JSSpreadType) {
                type2 = ((JSSpreadType)((Object)type2)).getComponentType();
            }
            if ((forward ? type2 : componentType).isDirectlyAssignableType(forward ? componentType : type2, processingContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public JSType getTypeByIndex(int index) {
        JSType type2;
        if (index < 0) {
            return null;
        }
        List<JSType> types = this.getTypes();
        int lastIndex = types.size() - 1;
        if (index <= lastIndex) {
            JSType type3 = types.get(index);
            if (index == lastIndex && type3 instanceof JSSpreadType) {
                return ((JSSpreadType)((Object)type3)).getComponentType();
            }
            if (this.myFirstOptional < 0 || index < this.myFirstOptional || type3 instanceof JSUndefinedType) {
                return type3;
            }
            return JSTupleTypeImpl.uniteWithUndefined(type3);
        }
        if (lastIndex >= 0 && (type2 = types.get(lastIndex)) instanceof JSSpreadType) {
            return ((JSSpreadType)((Object)type2)).getComponentType();
        }
        return null;
    }

    @NotNull
    private static JSType uniteWithUndefined(@NotNull JSType type2) {
        if (type2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(40);
        }
        JSTypeSource source = type2.getSource();
        JSType jSType = JSCompositeTypeFactory.createUnionType(source, type2, new JSUndefinedType(source, true));
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(41);
        }
        return jSType;
    }

    private static boolean isVariableType(@NotNull JSType candidate) {
        if (candidate == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(42);
        }
        return candidate instanceof JSSpreadType;
    }

    public static boolean isRest(@Nullable JSType candidate) {
        if (!(candidate instanceof JSSpreadType)) {
            return false;
        }
        return ((JSSpreadType)((Object)candidate)).isRest();
    }

    private static boolean isVariadic(@NotNull JSType candidate) {
        if (candidate == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(43);
        }
        if (!(candidate instanceof JSSpreadType)) {
            return false;
        }
        return ((JSSpreadType)((Object)candidate)).isVariadic();
    }

    @Override
    @Nullable
    public String getNameByIndex(int index) {
        if (this.myNames.size() > index) {
            return this.myNames.get(index);
        }
        return null;
    }

    @Override
    public boolean hasTypeByIndex(int index) {
        if (index < 0) {
            return false;
        }
        List<JSType> types = this.getTypes();
        int lastIndex = types.size() - 1;
        if (index <= lastIndex) {
            return true;
        }
        if (lastIndex >= 0) {
            return types.get(lastIndex) instanceof JSSpreadType;
        }
        return false;
    }

    @Override
    @Nullable
    public JSType excludePrefix(int length) {
        if (length <= 0) {
            return this;
        }
        List<JSType> types = this.getTypes();
        int lastIndex = types.size() - 1;
        if (length > lastIndex) {
            JSType lastType;
            if (lastIndex >= 0 && (lastType = types.get(lastIndex)) instanceof JSSpreadType) {
                return JSCompositeTypeFactory.createTupleType(this.getSource(), ContainerUtil.createMaybeSingletonList((Object)lastType), this.myStrict, -1, this.myReadonly);
            }
            return null;
        }
        List<JSType> newTypes = types.subList(length, types.size());
        return JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, this.myStrict, this.myFirstOptional == -1 || this.myFirstOptional + length >= newTypes.size() ? -1 : this.myFirstOptional + length, this.myReadonly);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(44);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(45);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(46);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.toArrayType(true).isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(47);
        }
        return assignableResult3;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(48);
        }
        return this.createType(this.getTypes(), source);
    }

    @Override
    @NotNull
    public JSType toArrayType(boolean allowResolve) {
        return this.toArrayImpl(allowResolve);
    }

    @NotNull
    private JSType toArrayImpl(boolean allowResolve) {
        JSTypeSource source = this.getSource();
        List<JSType> types = this.getTypes();
        List providers = ContainerUtil.map(types, el -> () -> el instanceof JSSpreadType ? ((JSSpreadType)((Object)el)).getComponentType() : el);
        JSType commonType = JSTypeUtils.getCommonType(providers, source.getSourceElement(), allowResolve);
        if (commonType instanceof JSNullType || !this.isTypeScript() && commonType instanceof TypeScriptNeverType) {
            commonType = JSAnyType.get(source.getSourceElement());
        }
        return this.myReadonly ? new JSReadonlyArrayTypeImpl(commonType, source) : new JSArrayTypeImpl(commonType, source);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType parent = this.toArrayImpl(true).asRecordType();
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>(parent.getTypeMembers());
        List<JSType> types = this.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            members.add(new PropertySignatureImpl(String.valueOf(i), types.get(i), false, false));
        }
        return new JSRecordTypeImpl(parent.getSource(), members);
    }

    @Override
    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create("Array", null);
    }

    @Override
    public boolean hasQualifiedName() {
        return true;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(super.hashCodeImpl(), JSTypeHashCodeUtil.getHashCode(this.getTypes()), this.myStrict, this.myFirstOptional, this.myReadonly);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(49);
        }
        return JSTypeCastUtil.areListsEquivalent(this.getTypes(), ((JSTupleType)type2).getTypes(), processingContext, allowResolve) && this.myReadonly == ((JSTupleTypeImpl)type2).myReadonly && this.myStrict == ((JSTupleTypeImpl)type2).myStrict && this.myFirstOptional == ((JSTupleTypeImpl)type2).myFirstOptional;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        StringBuilder type2 = new StringBuilder("[");
        List<JSType> types = this.getTypes();
        int size = types.size();
        int i = 0;
        for (JSType jsType : types) {
            type2.append(JSTypeUtils.defaultValueOfType(jsType));
            if (i < size - 1) {
                type2.append(",");
            }
            ++i;
        }
        String string = type2.append("]").toString();
        if (string == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(50);
        }
        return string;
    }

    @Override
    @NotNull
    public JSTupleType transformTypes(@NotNull BiFunction<? super JSType, Long, JSType> converter, boolean makeStrict) {
        if (converter == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(51);
        }
        List<JSType> originalTypes = this.getTypes();
        ArrayList<JSType> result2 = new ArrayList<JSType>(originalTypes.size());
        for (int i = 0; i < originalTypes.size(); ++i) {
            result2.add(converter.apply(originalTypes.get(i), Long.valueOf(i)));
        }
        if (ContainerUtil.equalsIdentity(result2, originalTypes)) {
            JSTupleTypeImpl jSTupleTypeImpl = this;
            if (jSTupleTypeImpl == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(52);
            }
            return jSTupleTypeImpl;
        }
        return new JSTupleTypeImpl(this.getSource(), result2, this.myNames, this.myStrict || makeStrict, this.myFirstOptional, this.myReadonly);
    }

    @Override
    public int getFirstOptional() {
        return this.myFirstOptional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 10, 11, 14, 21, 32, 41, 46, 47, 50, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 21: 
            case 32: 
            case 41: 
            case 46: 
            case 47: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 22: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 23: 
            case 24: 
            case 30: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 31: 
            case 34: 
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTypes";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sliceTupleType";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWithUndefined";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 21: 
            case 32: 
            case 41: 
            case 46: 
            case 47: 
            case 50: 
            case 52: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildNestedTypePresentation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInferenceForNestedTypes";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "areTupleTypesDefinitelyUnrelated";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasRest";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasVariadic";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericsWithTupleOrArray";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sliceTupleType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRestType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEndLengthOfType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFixedLength";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isTupleTypeStructureMatching";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkWithSpreads";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "uniteWithUndefined";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isVariableType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isVariadic";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "transformTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 10, 11, 14, 21, 32, 41, 46, 47, 50, 52 -> new IllegalStateException(string);
        };
    }
}

