/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.HighlightingDuplicateProblem;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceProjectErrors;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\u0017H\u0016R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceFileProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "Lcom/intellij/analysis/problemsView/HighlightingDuplicateProblem;", "myProvider", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors;", "myError", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors;Lcom/intellij/lang/javascript/integration/JSAnnotationError;Lcom/intellij/openapi/vfs/VirtualFile;)V", "file", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "getProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "text", "", "getText", "()Ljava/lang/String;", "line", "", "getLine", "()I", "column", "getColumn", "description", "getDescription", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "tooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "getTooltipText", "equals", "", "other", "", "hashCode", "intellij.javascript.impl"})
public final class JSLanguageServiceFileProblem
implements FileProblem,
HighlightingDuplicateProblem {
    @NotNull
    private final JSLanguageServiceProjectErrors<?> myProvider;
    @NotNull
    private final JSAnnotationError myError;
    @NotNull
    private final VirtualFile vFile;

    public JSLanguageServiceFileProblem(@NotNull JSLanguageServiceProjectErrors<?> myProvider2, @NotNull JSAnnotationError myError, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter(myProvider2, (String)"myProvider");
        Intrinsics.checkNotNullParameter((Object)myError, (String)"myError");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        this.myProvider = myProvider2;
        this.myError = myError;
        this.vFile = vFile;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.vFile;
    }

    @NotNull
    public ProblemsProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public String getText() {
        String string = this.myError.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        return string;
    }

    public int getLine() {
        return this.myError.getLine();
    }

    public int getColumn() {
        return this.myError.getColumn();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public Icon getIcon() {
        return HighlightDisplayLevel.ERROR.getIcon();
    }

    @Nullable
    public final String getTooltipText() {
        return this.myError.getTooltipText();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        JSLanguageServiceFileProblem problem = (JSLanguageServiceFileProblem)other;
        return Intrinsics.areEqual((Object)this.myError, (Object)problem.myError) && Intrinsics.areEqual((Object)this.getFile(), (Object)problem.getFile());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.myError, this.getFile()};
        return Objects.hash(objectArray);
    }
}

