/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAnnotationErrorsFilter;
import com.intellij.lang.javascript.service.JSLanguageServiceInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceProjectErrors;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticEventKind;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002./B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ.\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\u0014\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J&\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\b\u0010'\u001a\u00020 H\u0014J\b\u0010(\u001a\u00020 H\u0014J\b\u0010)\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00060"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "project", "Lcom/intellij/openapi/project/Project;", "myProtocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "myReporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;", "filter", "Lcom/intellij/lang/javascript/service/JSAnnotationErrorsFilter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;Lcom/intellij/lang/javascript/service/JSAnnotationErrorsFilter;)V", "myProjectErrorsQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "myReceivedDiagnosticsListeners", "", "Ljava/util/function/Consumer;", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors$DiagnosticData;", "getPathAndErrors", "Lcom/intellij/openapi/util/Pair;", "", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "answer", "languageServiceInfo", "Lcom/intellij/lang/typescript/compiler/languageService/LanguageServiceInfo;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "addReceivedDiagnosticsListener", "", "listener", "receivedDiagnostics", "serviceError", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProjectErrors$ServiceError;", "path", "errors", "queueUpdate", "cancelAllUpdates", "logCurrentErrors", "allErrors", "getAllErrors", "()Ljava/util/List;", "dispose", "DiagnosticData", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServiceProjectErrors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServiceProjectErrors.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1869#2,2:130\n*S KotlinDebug\n*F\n+ 1 TypeScriptServiceProjectErrors.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors\n*L\n78#1:130,2\n*E\n"})
public final class TypeScriptServiceProjectErrors
extends JSLanguageServiceProjectErrors<JSLanguageServiceAnswer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSLanguageServiceProtocol myProtocol;
    @NotNull
    private final JSLanguageServiceInfoReporter myReporter;
    @NotNull
    private final MergingUpdateQueue myProjectErrorsQueue;
    @NotNull
    private final List<Consumer<DiagnosticData>> myReceivedDiagnosticsListeners;
    @JvmField
    @NotNull
    public static final Key<Boolean> TOOL_WINDOW_IS_SHOWN;
    public static final int MERGE_INTERVAL_MILLS = 200;

    public TypeScriptServiceProjectErrors(@NotNull Project project, @NotNull JSLanguageServiceProtocol myProtocol, @NotNull JSLanguageServiceInfoReporter myReporter, @NotNull JSAnnotationErrorsFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myProtocol, (String)"myProtocol");
        Intrinsics.checkNotNullParameter((Object)myReporter, (String)"myReporter");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        super(project, filter2);
        this.myProtocol = myProtocol;
        this.myReporter = myReporter;
        this.myProjectErrorsQueue = new MergingUpdateQueue("TypeScript service project errors queue", 200, true, null, (Disposable)this.getMyDisposable(), null, Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
        this.myReceivedDiagnosticsListeners = new CopyOnWriteArrayList();
    }

    @Override
    @Nullable
    protected Pair<String, List<JSAnnotationError>> getPathAndErrors(@NotNull JSLanguageServiceAnswer answer2, @Nullable LanguageServiceInfo languageServiceInfo) {
        Intrinsics.checkNotNullParameter((Object)answer2, (String)"answer");
        JsonObject element2 = answer2.getElement();
        JsonElement body = element2.get("body");
        if (body == null) {
            return null;
        }
        Object object = this.getGson().fromJson(body, TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo responseInfo = (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo)object;
        LocalFilePath localFilePath = responseInfo.file;
        String path2 = localFilePath != null ? localFilePath.getPath() : null;
        List<JSAnnotationError> newElements = TypeScriptServerServiceImpl.Companion.parseDiagnosticsForFile(path2, responseInfo.diagnostics, this.getProject(), languageServiceInfo);
        return Pair.create((Object)path2, newElements);
    }

    private final Gson getGson() {
        return this.myProtocol instanceof JSLanguageServiceNodeStdProtocolBase ? ((JSLanguageServiceNodeStdProtocolBase)this.myProtocol).getGson() : JSLanguageServiceQueue.SharedGson.GSON;
    }

    public final void addReceivedDiagnosticsListener(@NotNull Consumer<DiagnosticData> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.myReceivedDiagnosticsListeners.add(listener2);
    }

    @Override
    protected void receivedDiagnostics(@NotNull JSLanguageServiceProjectErrors.ServiceError serviceError, @NotNull String path2, @NotNull List<? extends JSAnnotationError> errors) {
        DiagnosticEventKind eventKind;
        Intrinsics.checkNotNullParameter((Object)((Object)serviceError), (String)"serviceError");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        switch (WhenMappings.$EnumSwitchMapping$0[serviceError.ordinal()]) {
            case 1: {
                DiagnosticEventKind diagnosticEventKind = DiagnosticEventKind.syntaxDiag;
                break;
            }
            case 2: {
                DiagnosticEventKind diagnosticEventKind = DiagnosticEventKind.semanticDiag;
                break;
            }
            case 3: {
                DiagnosticEventKind diagnosticEventKind = DiagnosticEventKind.suggestionDiag;
                break;
            }
            default: {
                DiagnosticEventKind diagnosticEventKind = eventKind = null;
            }
        }
        if (eventKind == null) {
            return;
        }
        DiagnosticData diagnosticData = new DiagnosticData(eventKind, path2, errors);
        Iterable $this$forEach$iv = this.myReceivedDiagnosticsListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consumer listener2 = (Consumer)element$iv;
            boolean bl = false;
            try {
                listener2.accept(diagnosticData);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException || e instanceof CancellationException) continue;
                JSLanguageServiceProjectErrors.Companion.getLOGGER().error("Exception in diagnostics listener", (Throwable)e);
            }
        }
    }

    @Override
    protected void queueUpdate() {
        Update.Companion companion = Update.Companion;
        this.myProjectErrorsQueue.queue(new Update(this, companion){
            final /* synthetic */ TypeScriptServiceProjectErrors this$0;
            {
                this.this$0 = $receiver;
                super((Object)$super_call_param$1, false, 0, 6, null);
            }

            public void run() {
                TypeScriptServiceProjectErrors.access$logCurrentErrors(this.this$0);
            }
        });
    }

    @Override
    protected void cancelAllUpdates() {
        this.myProjectErrorsQueue.cancelAllUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logCurrentErrors() {
        List<JSAnnotationError> result2 = null;
        TypeScriptServiceProjectErrors typeScriptServiceProjectErrors = this;
        synchronized (typeScriptServiceProjectErrors) {
            boolean bl = false;
            if (this.getMyDisposed()) {
                return;
            }
            if (this.getMyProjectContext() == null) {
                return;
            }
            result2 = this.getAllErrors();
            Unit unit = Unit.INSTANCE;
        }
        this.myReporter.logCurrentErrors(null, result2);
    }

    private final synchronized List<JSAnnotationError> getAllErrors() {
        return SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.getMyGlobalErrors()), (Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.getMyErrors().values()))));
    }

    @Override
    public void dispose() {
        this.myReceivedDiagnosticsListeners.clear();
        super.dispose();
    }

    public static final /* synthetic */ void access$logCurrentErrors(TypeScriptServiceProjectErrors $this) {
        $this.logCurrentErrors();
    }

    static {
        Key key = Key.create((String)"problems.tool.window.open");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TOOL_WINDOW_IS_SHOWN = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors$Companion;", "", "<init>", "()V", "TOOL_WINDOW_IS_SHOWN", "Lcom/intellij/openapi/util/Key;", "", "MERGE_INTERVAL_MILLS", "", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors$DiagnosticData;", "", "kind", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticEventKind;", "path", "", "errors", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "<init>", "(Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticEventKind;Ljava/lang/String;Ljava/util/List;)V", "getKind", "()Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticEventKind;", "getPath", "()Ljava/lang/String;", "getErrors", "()Ljava/util/List;", "intellij.javascript.impl"})
    public static final class DiagnosticData {
        @NotNull
        private final DiagnosticEventKind kind;
        @NotNull
        private final String path;
        @NotNull
        private final List<JSAnnotationError> errors;

        public DiagnosticData(@NotNull DiagnosticEventKind kind, @NotNull String path2, @NotNull List<? extends JSAnnotationError> errors) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            this.kind = kind;
            this.path = path2;
            this.errors = errors;
        }

        @NotNull
        public final DiagnosticEventKind getKind() {
            return this.kind;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final List<JSAnnotationError> getErrors() {
            return this.errors;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSLanguageServiceProjectErrors.ServiceError.values().length];
            try {
                nArray[JSLanguageServiceProjectErrors.ServiceError.SYNTAX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLanguageServiceProjectErrors.ServiceError.SEMANTICS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSLanguageServiceProjectErrors.ServiceError.SUGGESTIONS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

