/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public final class ConstantOnRHSOfComparisonJSInspection
extends JavaScriptInspection {
    private final SwapComparisonFix fix = new SwapComparisonFix();

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("constant.on.right.side.of.comparison.error.string", new Object[0]);
        if (string == null) {
            ConstantOnRHSOfComparisonJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantOnRHSOfComparisonVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/ConstantOnRHSOfComparisonJSInspection", "buildErrorString"));
    }

    private static class SwapComparisonFix
    extends InspectionJSFix {
        private SwapComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("flip.comparison.fix", new Object[0]);
            if (string == null) {
                SwapComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSBinaryExpression expression = (JSBinaryExpression)descriptor.getPsiElement();
            JSExpression rhs = expression.getROperand();
            JSExpression lhs = expression.getLOperand();
            IElementType sign = expression.getOperationSign();
            assert (rhs != null);
            String rhsText = rhs.getText();
            String flippedComparison = ComparisonUtils.getFlippedComparison(sign);
            String lhsText = lhs.getText();
            SwapComparisonFix.replaceExpression(expression, rhsText + " " + flippedComparison + " " + lhsText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/ConstantOnRHSOfComparisonJSInspection$SwapComparisonFix", "getFamilyName"));
        }
    }

    private static class ConstantOnRHSOfComparisonVisitor
    extends BaseInspectionVisitor {
        private ConstantOnRHSOfComparisonVisitor() {
        }

        @Override
        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                ConstantOnRHSOfComparisonVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isComparison(expression)) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression rhs = expression.getROperand();
            if (lhs instanceof JSLiteralExpression || !(rhs instanceof JSLiteralExpression)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/style/ConstantOnRHSOfComparisonJSInspection$ConstantOnRHSOfComparisonVisitor", "visitJSBinaryExpression"));
        }
    }
}

