/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.model.common.persistence.mapping.AttributeType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiMember;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistenceAttributesProvider {
    public static final ExtensionPointName<PersistenceAttributesProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.javaee.jpa.persistenceAttributesProvider");
    static volatile Set<String> cachedAttributeAnnotations = null;
    static volatile Iterable<AttributeType> cachedAttributeTypes = null;

    public abstract AttributeType[] getAttributes();

    public static Iterable<AttributeType> values() {
        Iterable<AttributeType> current = cachedAttributeTypes;
        if (current != null) {
            return current;
        }
        ArrayList<AttributeType> attributes = new ArrayList<AttributeType>();
        for (PersistenceAttributesProvider provider : EP_NAME.getExtensionList()) {
            ContainerUtil.addAll(attributes, (Object[])provider.getAttributes());
        }
        cachedAttributeTypes = attributes;
        return attributes;
    }

    @NotNull
    public static Set<String> getAttributeAnnotations() {
        Set<String> current = cachedAttributeAnnotations;
        if (current != null) {
            Set<String> set = current;
            if (set == null) {
                PersistenceAttributesProvider.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<String> allAnnotations = new HashSet<String>();
        for (AttributeType value : PersistenceAttributesProvider.values()) {
            JavaeeClass javaeeClass = value.getAttributeAnnotation();
            if (javaeeClass == null) continue;
            ContainerUtil.addAllNotNull(allAnnotations, (Object[])javaeeClass.all());
        }
        cachedAttributeAnnotations = allAnnotations;
        HashSet<String> hashSet = allAnnotations;
        if (hashSet == null) {
            PersistenceAttributesProvider.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    public static AttributeType getAttributeType(@NotNull String anno) {
        if (anno == null) {
            PersistenceAttributesProvider.$$$reportNull$$$0(2);
        }
        for (AttributeType value : PersistenceAttributesProvider.values()) {
            JavaeeClass javaeeClass = value.getAttributeAnnotation();
            if (javaeeClass == null || !javaeeClass.isFqn(anno)) continue;
            return value;
        }
        return null;
    }

    public static Set<JamMemberMeta<PsiMember, ? extends JamAttributeBase>> getAllJamMetas() {
        LinkedHashSet<JamMemberMeta<PsiMember, ? extends JamAttributeBase>> metas = new LinkedHashSet<JamMemberMeta<PsiMember, ? extends JamAttributeBase>>();
        for (AttributeType value : PersistenceAttributesProvider.values()) {
            ContainerUtil.addAll(metas, (Object[])value.getJamMetas());
        }
        return metas;
    }

    @Nullable
    public static AttributeType getAnnotationAttributeType(AttributeType type) {
        JavaeeClass annotation = type.getAttributeAnnotation();
        if (annotation == null) {
            return null;
        }
        for (AttributeType value : PersistenceAttributesProvider.values()) {
            if (!annotation.equals((Object)value.getAttributeAnnotation())) continue;
            return value;
        }
        return null;
    }

    static {
        EP_NAME.addChangeListener(() -> {
            cachedAttributeAnnotations = null;
            cachedAttributeTypes = null;
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/PersistenceAttributesProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/PersistenceAttributesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

