/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ConsoleRunContextParametersTuner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.engine.JakartaEngine;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.engine.JpaEngineBase;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.providers.EclipseLinkProvider;
import com.intellij.jpa.remote.JpaConsoleCommon;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaConsoleRunContext
implements ConsoleRunConfiguration.RunContext {
    public static final String MAIN_CLASS = "com.intellij.jpa.console.RemoteJpaServer";
    private final PersistencePackagePointer myUnitFile;

    JpaConsoleRunContext(PersistencePackagePointer unitFile) {
        this.myUnitFile = unitFile;
    }

    public static PersistencePackagePointer[] getPossiblePersistenceUnits(Project project) {
        ArrayList<PersistencePackagePointer> model = new ArrayList<PersistencePackagePointer>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Project)project)) {
            if (!(facet instanceof JpaFacet) || !JpaConsoleRunContext.isJpaEngineAvailable(facet)) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                model.add(PersistencePackageAsVirtualFileImpl.findFile(unit, facet));
            }
        }
        return model.toArray(new PersistencePackagePointer[0]);
    }

    private static boolean isJpaEngineAvailable(PersistenceFacet facet) {
        return JpaEngine.isAvailable(facet.getModule()) || JakartaEngine.isAvailable(facet.getModule());
    }

    public static boolean shouldAddGroovy(@Nullable Module module) {
        if (module == null) {
            return true;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("groovy.lang.GroovyShell", GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)) == null;
    }

    public static void addDataSourceJarsToClassPath(@NotNull PathsList cp, @NotNull PersistencePackage unit, @NotNull PersistenceFacet facet) {
        String dataSourceId;
        if (cp == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(0);
        }
        if (unit == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(2);
        }
        if ((dataSourceId = facet.getDataSourceId(unit)) == null) {
            return;
        }
        LocalDataSource dataSource = DbSrcUtilsCore.findDataSource((Project)facet.getModule().getProject(), (String)dataSourceId);
        if (dataSource != null) {
            JdbcConsoleRunContext.addJdbcDrivers((PathsList)cp, (LocalDataSource)dataSource);
        }
    }

    @Nullable
    public static LocalDataSource getDataSource(@NotNull PersistencePackagePointer unitFile) {
        PersistencePackage unit;
        if (unitFile == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(3);
        }
        if ((unit = unitFile.findElement()) == null) {
            return null;
        }
        PersistenceFacet facet = unitFile.getPersistenceFacet();
        if (facet == null || facet.getModule().isDisposed()) {
            return null;
        }
        String dataSourceId = facet.getDataSourceId(unit);
        if (dataSourceId == null) {
            return null;
        }
        return DbSrcUtilsCore.findDataSource((Project)facet.getModule().getProject(), (String)dataSourceId);
    }

    public static void addModuleClassPath(@NotNull PathsList cp, @Nullable Module module) {
        if (cp == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(4);
        }
        if (module == null) {
            return;
        }
        OrderEnumerator.orderEntries((Module)module).withoutSdk().recursively().classes().collectPaths(cp);
    }

    @Nullable
    public static Sdk getSdk(@NotNull PersistencePackagePointer unitFile) {
        JavaSdkVersion version;
        PersistenceFacet facet;
        Module module;
        if (unitFile == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(5);
        }
        Module module2 = module = (facet = unitFile.getPersistenceFacet()) == null ? null : facet.getModule();
        if (module == null || module.isDisposed()) {
            return null;
        }
        Project project = module.getProject();
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
        VirtualFile homeDirectory = moduleSdk == null ? null : moduleSdk.getHomeDirectory();
        Sdk contextSdk = homeDirectory == null || !homeDirectory.isValid() ? projectJdk : moduleSdk;
        JavaSdkVersion javaSdkVersion = version = contextSdk != null ? JavaSdk.getInstance().getVersion(contextSdk) : null;
        if (version != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            return contextSdk;
        }
        return null;
    }

    @Nullable
    public Sdk getSdk() {
        return JpaConsoleRunContext.getSdk(this.myUnitFile);
    }

    public String getMainClassName() {
        return MAIN_CLASS;
    }

    public void collectClassPath(PathsList cp) throws ExecutionException {
        PersistencePackage unit = this.myUnitFile.findElement();
        if (unit == null) {
            throw new ExecutionException(JpaMessages.message("jpa.console.unit.not.found", new Object[0]));
        }
        PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
        if (facet == null || facet.getModule().isDisposed()) {
            throw new ExecutionException(JpaMessages.message("jpa.console.facet.not.found", new Object[0]));
        }
        Module module = facet.getModule();
        JdbcConsoleRunContext.addUtilJars((PathsList)cp, (boolean)JpaConsoleRunContext.shouldAddGroovy(module));
        JdbcConsoleRunContext.addJdbcConsoleJars((PathsList)cp);
        JdbcConsoleRunContext.addClassJar((PathsList)cp, JpaEngine.class, (String)this.getMainClassName());
        JdbcConsoleRunContext.addClassJar((PathsList)cp, JpaEngine.class, (String)JpaConsoleCommon.class.getName());
        JpaConsoleRunContext.addDataSourceJarsToClassPath(cp, unit, facet);
        JpaConsoleRunContext.addModuleClassPath(cp, module);
    }

    public void tuneParams(@NotNull Project project, @NotNull SimpleJavaParameters params) {
        File tempPURoot;
        if (project == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(6);
        }
        if (params == null) {
            JpaConsoleRunContext.$$$reportNull$$$0(7);
        }
        File genPath = JpaEngineBase.getTempDirectory(this.myUnitFile.getPersistenceFacet().getModule().getProject());
        PersistencePackage unit = this.myUnitFile.findElement();
        JpaImplementationProvider provider = JpaUtil.findJpaProvider(this.myUnitFile.getPersistenceFacet(), unit, true);
        String path = this.myUnitFile.getModuleName().replace(' ', '_') + "-PU-" + System.currentTimeMillis();
        if (provider instanceof EclipseLinkProvider) {
            tempPURoot = new File(genPath, path + File.separator + "gen");
            params.getVMParametersList().add("-Declipselink.persistencexml=" + tempPURoot.getName() + "/META-INF/persistence.xml");
            params.getClassPath().addFirst(tempPURoot.getParentFile().getAbsolutePath());
        } else {
            tempPURoot = new File(genPath, path);
            params.getClassPath().addFirst(tempPURoot.getAbsolutePath());
        }
        tempPURoot.mkdirs();
        params.getVMParametersList().add("-Dcom.jetbrains.jpa.root=" + tempPURoot.getAbsolutePath());
        LocalDataSource dataSource = JpaConsoleRunContext.getDataSource(this.myUnitFile);
        if (dataSource == null) {
            return;
        }
        for (ConsoleRunContextParametersTuner parametersTuner : (ConsoleRunContextParametersTuner[])PARAMETERS_TUNERS.getExtensions()) {
            parametersTuner.tuneParams(project, dataSource, params);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/engine/JpaConsoleRunContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDataSourceJarsToClassPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addModuleClassPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSdk";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tuneParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

