/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation;

import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.ide.util.PackageUtil;
import com.intellij.java.JavaBundle;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.javaee.util.AnnotationManipulator;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.model.common.persistence.JpaConstants;
import com.intellij.jpa.model.common.persistence.mapping.Basic;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerMethod;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerMethodContainer;
import com.intellij.jpa.model.common.persistence.mapping.ManyToMany;
import com.intellij.jpa.model.common.persistence.mapping.OneToMany;
import com.intellij.jpa.model.common.persistence.mapping.PersistentObject;
import com.intellij.jpa.model.common.persistence.mapping.Transient;
import com.intellij.jpa.model.xml.persistence.mapping.AccessType;
import com.intellij.jpa.model.xml.persistence.mapping.AssociationOverride;
import com.intellij.jpa.model.xml.persistence.mapping.AttributeBase;
import com.intellij.jpa.model.xml.persistence.mapping.AttributeOverride;
import com.intellij.jpa.model.xml.persistence.mapping.AttributeWithColumn;
import com.intellij.jpa.model.xml.persistence.mapping.CascadeType;
import com.intellij.jpa.model.xml.persistence.mapping.CollectionTable;
import com.intellij.jpa.model.xml.persistence.mapping.Column;
import com.intellij.jpa.model.xml.persistence.mapping.ColumnBase;
import com.intellij.jpa.model.xml.persistence.mapping.ColumnResult;
import com.intellij.jpa.model.xml.persistence.mapping.DiscriminatorType;
import com.intellij.jpa.model.xml.persistence.mapping.Embeddable;
import com.intellij.jpa.model.xml.persistence.mapping.Embedded;
import com.intellij.jpa.model.xml.persistence.mapping.EmbeddedId;
import com.intellij.jpa.model.xml.persistence.mapping.Entity;
import com.intellij.jpa.model.xml.persistence.mapping.EntityBase;
import com.intellij.jpa.model.xml.persistence.mapping.EntityListener;
import com.intellij.jpa.model.xml.persistence.mapping.EntityMappings;
import com.intellij.jpa.model.xml.persistence.mapping.EntityResult;
import com.intellij.jpa.model.xml.persistence.mapping.Enumerated;
import com.intellij.jpa.model.xml.persistence.mapping.FetchType;
import com.intellij.jpa.model.xml.persistence.mapping.FieldResult;
import com.intellij.jpa.model.xml.persistence.mapping.GenerationType;
import com.intellij.jpa.model.xml.persistence.mapping.Id;
import com.intellij.jpa.model.xml.persistence.mapping.InheritanceType;
import com.intellij.jpa.model.xml.persistence.mapping.JoinColumn;
import com.intellij.jpa.model.xml.persistence.mapping.JoinTable;
import com.intellij.jpa.model.xml.persistence.mapping.ManyToOne;
import com.intellij.jpa.model.xml.persistence.mapping.MapKey;
import com.intellij.jpa.model.xml.persistence.mapping.MappedSuperclass;
import com.intellij.jpa.model.xml.persistence.mapping.NamedNativeQuery;
import com.intellij.jpa.model.xml.persistence.mapping.NamedQuery;
import com.intellij.jpa.model.xml.persistence.mapping.OneToOne;
import com.intellij.jpa.model.xml.persistence.mapping.PersistentObjectBase;
import com.intellij.jpa.model.xml.persistence.mapping.PrimaryKeyJoinColumn;
import com.intellij.jpa.model.xml.persistence.mapping.QueryHint;
import com.intellij.jpa.model.xml.persistence.mapping.RelationAttributeBase;
import com.intellij.jpa.model.xml.persistence.mapping.SecondaryTable;
import com.intellij.jpa.model.xml.persistence.mapping.SqlResultSetMapping;
import com.intellij.jpa.model.xml.persistence.mapping.Table;
import com.intellij.jpa.model.xml.persistence.mapping.Temporal;
import com.intellij.jpa.model.xml.persistence.mapping.TemporalType;
import com.intellij.jpa.model.xml.persistence.mapping.UniqueConstraint;
import com.intellij.jpa.model.xml.persistence.mapping.Version;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ORMToAnnotationsConverter
implements AnnotationManipulator<PsiModifierListOwner> {
    private final Module myModule;
    private final JavaCodeStyleManager myCodeStyleManager;
    private final Map<PsiElement, MyUsageInfo> usageInfos = new HashMap<PsiElement, MyUsageInfo>();
    private boolean myAddDefaultNames;
    private AccessType myDefaultAccessType = null;
    private final Map<String, Pair<String, String>> myAttributeNameMap = new HashMap<String, Pair<String, String>>();

    public ORMToAnnotationsConverter(Module module) {
        this.myModule = module;
        this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)module.getProject());
        this.myAddDefaultNames = true;
    }

    public ORMToAnnotationsConverter(Module module, AccessType accessType) {
        this(module);
        this.myDefaultAccessType = accessType;
    }

    public void setAddDefaultNames(boolean addDefaultNames) {
        this.myAddDefaultNames = addDefaultNames;
    }

    private void addUsageInfo(MyUsageInfo info) {
        MyUsageInfo usageInfo;
        if (info instanceof ReplaceUsageInfo || info instanceof DeleteUsageInfo) {
            this.usageInfos.put(info.getElement(), info);
        }
        if ((usageInfo = this.usageInfos.get(info.getElement())) == null) {
            this.usageInfos.put(info.getElement(), info);
        } else if (usageInfo instanceof AddUsageInfo) {
            AddUsageInfo addUsageInfo = (AddUsageInfo)usageInfo;
            addUsageInfo.list.addAll(((AddUsageInfo)info).list);
        }
    }

    private void processUsageInfos() throws Exception {
        if (CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myModule.getProject(), this.usageInfos.keySet())) {
            Collection<MyUsageInfo> myUsageInfos = this.usageInfos.values();
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            for (MyUsageInfo info : myUsageInfos) {
                results.add(info.processUsage());
            }
            for (PsiElement result : results) {
                if (result == null || !result.isValid()) continue;
                this.myCodeStyleManager.shortenClassReferences(result);
            }
        }
        this.clear();
    }

    private PsiAnnotation findAddedAnnotation(PsiModifierList modifierList, PsiAnnotation psiCurrentAnno, String annotationName) {
        UsageInfo info;
        if (psiCurrentAnno != null && (info = (UsageInfo)this.usageInfos.get(psiCurrentAnno)) instanceof ReplaceUsageInfo) {
            ReplaceUsageInfo replaceUsageInfo = (ReplaceUsageInfo)info;
            return (PsiAnnotation)replaceUsageInfo.myNewElement;
        }
        if (modifierList != null && (info = this.usageInfos.get(modifierList)) instanceof AddUsageInfo) {
            AddUsageInfo addUsageInfo = (AddUsageInfo)info;
            for (PsiElement psiElement : addUsageInfo.list) {
                PsiAnnotation psiAnnotation;
                if (!(psiElement instanceof PsiAnnotation) || !annotationName.equals((psiAnnotation = (PsiAnnotation)psiElement).getQualifiedName())) continue;
                return psiAnnotation;
            }
        }
        return psiCurrentAnno;
    }

    private void clear() {
        this.usageInfos.clear();
    }

    public void migrateORM(List<EntityMappings> entityMappingsList, JavaeeType javaeeType) throws Exception {
        this.clear();
        if (!this.createMissingClassesAndFields(entityMappingsList, javaeeType)) {
            return;
        }
        for (EntityMappings entityMappings : entityMappingsList) {
            for (Entity entity : entityMappings.getEntities()) {
                this.migrateEntity(entityMappings, entity);
            }
            for (Embeddable embeddable : entityMappings.getEmbeddables()) {
                this.migrateEmbeddable(entityMappings, embeddable, javaeeType);
            }
            for (MappedSuperclass mappedSuperclass : entityMappings.getMappedSuperclasses()) {
                this.migrateMappedSuperClass(entityMappings, mappedSuperclass, javaeeType);
            }
        }
        this.processUsageInfos();
    }

    public void applyChanges() throws Exception {
        this.processUsageInfos();
    }

    public boolean createMissingClassesAndFields(List<EntityMappings> entityMappingsList, JavaeeType javaeeType) throws Exception {
        PostprocessReformattingAspect.getInstance((Project)this.myModule.getProject()).doPostponedFormatting();
        ArrayList psiClasses = new ArrayList();
        for (EntityMappings entityMappings : entityMappingsList) {
            for (Entity entity : entityMappings.getEntities()) {
                ContainerUtil.addIfNotNull(psiClasses, (Object)((PsiClass)entity.getClazz().getValue()));
                ContainerUtil.addIfNotNull(psiClasses, (Object)((PsiClass)entity.getIdClass().getClazz().getValue()));
            }
            for (Embeddable embeddable : entityMappings.getEmbeddables()) {
                ContainerUtil.addIfNotNull(psiClasses, (Object)((PsiClass)embeddable.getClazz().getValue()));
            }
            for (MappedSuperclass mappedSuperclass : entityMappings.getMappedSuperclasses()) {
                ContainerUtil.addIfNotNull(psiClasses, (Object)((PsiClass)mappedSuperclass.getClazz().getValue()));
                ContainerUtil.addIfNotNull(psiClasses, (Object)((PsiClass)mappedSuperclass.getIdClass().getClazz().getValue()));
            }
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myModule.getProject(), psiClasses)) {
            return false;
        }
        Ref exception = new Ref();
        for (EntityMappings entityMappings : entityMappingsList) {
            Processor processor = t -> {
                PsiClass psiObjectClass;
                try {
                    psiObjectClass = this.ensureClassExists((PersistentObject)t);
                }
                catch (IncorrectOperationException e) {
                    Messages.showErrorDialog((Project)this.myModule.getProject(), (String)e.getMessage(), (String)JavaBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]));
                    return true;
                }
                AccessType accessType = this.getAccessType((PersistentObjectBase)t, entityMappings);
                List attrList = t.getAllAttributes();
                if (psiObjectClass != null) {
                    this.ensurePropertiesImplemented(psiObjectClass, accessType, false, attrList, entityMappingsList, (Ref<Exception>)exception, javaeeType);
                }
                if (t instanceof EntityBase) {
                    EntityBase entityBase = (EntityBase)t;
                    GenericAttributeValue<PsiClass> clazz = entityBase.getIdClass().getClazz();
                    PsiClass idClass = (PsiClass)clazz.getValue();
                    try {
                        PsiClass serializableClass;
                        if (!StringUtil.isEmpty((String)clazz.getStringValue()) && idClass == null) {
                            idClass = ORMToAnnotationsConverter.createClass(this.myModule, JpaUtil.getQualifiedName(t, clazz.getStringValue()));
                        }
                        if (idClass != null && (serializableClass = JavaPsiFacade.getInstance((Project)idClass.getProject()).findClass("java.io.Serializable", ProjectScope.getAllScope((Project)idClass.getProject()))) != null && !idClass.isInheritor(serializableClass, true)) {
                            idClass.getImplementsList().addAfter((PsiElement)JavaPsiFacade.getInstance((Project)idClass.getProject()).getElementFactory().createClassReferenceElement(serializableClass), null);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        Messages.showErrorDialog((Project)this.myModule.getProject(), (String)e.getMessage(), (String)JavaBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]));
                        return true;
                    }
                    if (idClass != null) {
                        this.ensurePropertiesImplemented(idClass, accessType, true, attrList, entityMappingsList, (Ref<Exception>)exception, javaeeType);
                    }
                }
                return true;
            };
            ContainerUtil.process(entityMappings.getEntities(), (Processor)processor);
            ContainerUtil.process(entityMappings.getEmbeddables(), (Processor)processor);
            ContainerUtil.process(entityMappings.getMappedSuperclasses(), (Processor)processor);
            if (exception.isNull()) continue;
            throw (Exception)exception.get();
        }
        return true;
    }

    private void ensurePropertiesImplemented(PsiClass psiClass, AccessType accessType, boolean idAttrsOnly, List<? extends com.intellij.jpa.model.common.persistence.mapping.AttributeBase> attrList, List<EntityMappings> entityMappingsList, Ref<Exception> exception, JavaeeType javaeeType) {
        ArrayList<PsiField> idFields = new ArrayList<PsiField>();
        for (com.intellij.jpa.model.common.persistence.mapping.AttributeBase attributeBase : attrList) {
            try {
                boolean idAttr;
                boolean bl = idAttr = attributeBase instanceof Id || attributeBase instanceof EmbeddedId;
                if (!idAttr && idAttrsOnly) continue;
                PsiField psiField = this.ensurePropertyExists((String)attributeBase.getName().getValue(), accessType, ORMToAnnotationsConverter.getDefaultType((AttributeBase)attributeBase, entityMappingsList), psiClass, javaeeType);
                if (!idAttr) continue;
                ContainerUtil.addIfNotNull(idFields, (Object)psiField);
            }
            catch (IncorrectOperationException e) {
                if (!exception.isNull()) continue;
                exception.set((Object)e);
            }
        }
        ORMToAnnotationsConverter.ensureEqualsAndHashCodeImplemented(psiClass, idFields);
    }

    public static void ensureEqualsAndHashCodeImplemented(PsiClass aClass, Collection<PsiField> idFields) {
        if (idFields.isEmpty()) {
            return;
        }
        PsiField[] psiFields = idFields.toArray(PsiField.EMPTY_ARRAY);
        new GenerateEqualsHelper(aClass.getProject(), aClass, psiFields, psiFields, PsiField.EMPTY_ARRAY, false).executeWithDefaultTemplateWhenNotApplicable();
    }

    public PsiField ensurePropertyExists(String name, AccessType accessType, String defaultType, PsiClass psiClass, JavaeeType javaeeType) throws IncorrectOperationException {
        String fixedName = ORMToAnnotationsConverter.fixPropertyName(name, psiClass);
        PsiMember[] psiMember = this.findPropertyPsiMember(fixedName, AccessType.FIELD, psiClass);
        if (psiMember[0] == null && (accessType == null || accessType == AccessType.FIELD)) {
            psiMember[0] = ORMToAnnotationsConverter.createPropertyField(psiClass, fixedName, defaultType);
        } else if (psiMember[1] == null && accessType == AccessType.PROPERTY) {
            psiMember[1] = ORMToAnnotationsConverter.createPropertyGetter(psiClass, fixedName, defaultType, psiMember);
        }
        PsiMember targetMember = psiMember[accessType == null || accessType == AccessType.FIELD ? 0 : 1];
        assert (targetMember != null);
        this.myAttributeNameMap.put(fixedName + ":" + psiClass.getQualifiedName(), (Pair<String, String>)Pair.create((Object)(psiMember[0] == null ? null : psiMember[0].getName()), psiMember[1] == null ? null : PropertyUtilBase.getPropertyNameByGetter((PsiMethod)((PsiMethod)psiMember[1]))));
        if (targetMember.getContainingClass() != psiClass) {
            this.createAnnotation((PsiModifierListOwner)targetMember.getContainingClass(), JpaAnnotationConstants.MAPPED_SUPERCLASS_ANNO.fqn(javaeeType), true, new String[0]);
        }
        return (PsiField)psiMember[0];
    }

    @Nullable
    public PsiClass ensureClassExists(PersistentObject obj) throws IncorrectOperationException {
        PsiClass aClass = (PsiClass)obj.getClazz().getValue();
        if (aClass != null) {
            return aClass;
        }
        return ORMToAnnotationsConverter.createClass(this.myModule, JpaUtil.getQualifiedName(obj));
    }

    private void migrateMappedSuperClass(EntityMappings entityMappings, MappedSuperclass mappedSuperclass, JavaeeType javaeeType) throws Exception {
        PsiClass psiTargetClass = (PsiClass)mappedSuperclass.getClazz().getValue();
        if (psiTargetClass == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.MAPPED_SUPERCLASS_ANNO.fqn(javaeeType), true, new String[0]);
        this.migrateEntityBase(entityMappings, mappedSuperclass, psiTargetClass, javaeeType);
        JavaCodeStyleManager.getInstance((Project)psiTargetClass.getProject()).shortenClassReferences((PsiElement)psiTargetClass);
    }

    private void createEntityListenerAnnotations(EntityListenerMethodContainer entity, JavaeeType javaeeType) {
        Ref ref = new Ref();
        entity.processEntityListenerMethods(null, (Processor<EntityListenerMethod>)((Processor)t -> {
            if (t.getMethod() != null) {
                try {
                    this.createAnnotation((PsiModifierListOwner)t.getMethod(), t.getType().getMethodAnnotation().fqn(javaeeType), true, new String[0]);
                }
                catch (IncorrectOperationException e) {
                    ref.set((Object)e);
                }
            }
            return true;
        }));
        if (ref.get() != null) {
            throw (IncorrectOperationException)((Object)ref.get());
        }
    }

    private void migrateEmbeddable(EntityMappings entityMappings, Embeddable embeddable, JavaeeType javaeeType) {
        PsiClass psiTargetClass = (PsiClass)embeddable.getClazz().getValue();
        if (psiTargetClass == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.EMBEDDABLE_ANNO.fqn(javaeeType), true, new String[0]);
        this.migrateAttributes(embeddable, psiTargetClass, entityMappings);
        JavaCodeStyleManager.getInstance((Project)psiTargetClass.getProject()).shortenClassReferences((PsiElement)psiTargetClass);
    }

    private void migrateEntity(EntityMappings entityMappings, Entity entity) throws Exception {
        Object generator;
        String discriminatorValue;
        InheritanceType inheritanceType;
        PsiClass psiTargetClass = (PsiClass)entity.getClazz().getValue();
        if (psiTargetClass == null) {
            return;
        }
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)psiTargetClass, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
        this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.ENTITY_ANNO.fqn(javaeeType), true, "name", AnnotationTextUtil.quote((String)((String)entity.getName().getValue())), AnnotationTextUtil.quote((String)psiTargetClass.getName()));
        this.migrateEntityBase(entityMappings, entity, psiTargetClass, javaeeType);
        this.createTableAnnotation((PsiMember)psiTargetClass, entity.getTable(), (String)entity.getName().getValue(), javaeeType);
        this.createSecondaryTablesAnnotation(entity.getSecondaryTables(), (PsiMember)psiTargetClass, javaeeType);
        if (!entity.getPrimaryKeyJoinColumns().isEmpty()) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.PRIMARY_KEY_JOIN_COLUMNS_ANNO.fqn(javaeeType), true, "value", ORMToAnnotationsConverter.createPkJoinColumnsArray(entity.getPrimaryKeyJoinColumns(), (PsiMember)psiTargetClass, javaeeType), null);
        }
        if ((inheritanceType = (InheritanceType)((Object)entity.getInheritance().getStrategy().getValue())) != null) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.INHERITANCE_ANNO.fqn(javaeeType), true, "strategy", JpaConstants.INHERITANCE_TYPE_PREFIX.fqn(javaeeType) + inheritanceType.name(), String.valueOf(JpaConstants.INHERITANCE_TYPE_PREFIX) + InheritanceType.SINGLE_TABLE.name());
        }
        if ((discriminatorValue = (String)entity.getDiscriminatorValue().getValue()) != null) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.DISCRIMINATOR_VALUE_ANNO.fqn(javaeeType), true, "value", AnnotationTextUtil.quote((String)discriminatorValue), null);
        }
        if (entity.getDiscriminatorColumn().getXmlTag() != null) {
            DiscriminatorType type = (DiscriminatorType)((Object)entity.getDiscriminatorColumn().getDiscriminatorType().getValue());
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.DISCRIMINATOR_COLUMN_ANNO.fqn(javaeeType), true, "name", AnnotationTextUtil.quote((String)((String)entity.getDiscriminatorColumn().getName().getValue())), null, "discriminatorType", type == null ? null : JpaConstants.DISCRIMINATOR_TYPE_PREFIX.fqn(javaeeType) + type.name(), String.valueOf(JpaConstants.DISCRIMINATOR_TYPE_PREFIX) + DiscriminatorType.STRING.name(), "columnDefinition", AnnotationTextUtil.quote((String)((String)entity.getDiscriminatorColumn().getColumnDefinition().getValue())), null, "length", ORMToAnnotationsConverter.toString(entity.getDiscriminatorColumn().getLength().getValue()), null);
        }
        if (entity.getSequenceGenerator().getXmlTag() != null) {
            generator = entity.getSequenceGenerator();
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.SEQUENCE_GENERATOR_ANNO.fqn(javaeeType), true, "name", AnnotationTextUtil.quote((String)((String)generator.getName().getValue())), null, "sequenceName", AnnotationTextUtil.quote((String)((String)generator.getTableName().getValue())), null, "initialValue", ORMToAnnotationsConverter.toString(generator.getInitialValue().getValue()), null, "allocationSize", ORMToAnnotationsConverter.toString(generator.getAllocationSize().getValue()), null);
        }
        if (entity.getTableGenerator().getXmlTag() != null) {
            generator = entity.getTableGenerator();
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.TABLE_GENERATOR_ANNO.fqn(javaeeType), true, "name", AnnotationTextUtil.quote((String)((String)generator.getName().getValue())), null, "catalog", AnnotationTextUtil.quote((String)generator.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote((String)generator.getSchema().getStringValue()), null, "pkColumnName", AnnotationTextUtil.quote((String)generator.getPkColumnName().getStringValue()), null, "valueColumnName", AnnotationTextUtil.quote((String)generator.getValueColumnName().getStringValue()), null, "pkColumnValue", AnnotationTextUtil.quote((String)generator.getPkColumnValue().getStringValue()), null, "initialValue", ORMToAnnotationsConverter.toString(generator.getInitialValue().getValue()), null, "allocationSize", ORMToAnnotationsConverter.toString(generator.getAllocationSize().getValue()), null, "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(generator.getUniqueConstraints(), (PsiMember)psiTargetClass, javaeeType), null);
        }
        this.createAttributeOverridesAnnotation(entity.getAttributeOverrides(), (PsiMember)psiTargetClass, javaeeType);
        this.createAssociationOverridesAnnotation(entity.getAssociationOverrides(), (PsiMember)psiTargetClass, javaeeType);
        this.createNamedQueriesAnnotation(entity.getNamedQueries(), psiTargetClass, false, javaeeType);
        this.createNamedQueriesAnnotation(entity.getNamedNativeQueries(), psiTargetClass, true, javaeeType);
        this.createSqlResultSetMappingsAnnotation(entity.getSqlResultSetMappings(), psiTargetClass, entityMappings, javaeeType);
        JavaCodeStyleManager.getInstance((Project)psiTargetClass.getProject()).shortenClassReferences((PsiElement)psiTargetClass);
    }

    private void createSqlResultSetMappingsAnnotation(List<SqlResultSetMapping> list, PsiClass psiTargetClass, EntityMappings entityMappings, JavaeeType javaeeType) {
        Ref error = new Ref();
        this.createMultiAnnotation(list, (PsiMember)psiTargetClass, JpaAnnotationConstants.SQL_RESULT_SET_MAPPING_ANNO.fqn(javaeeType), JpaAnnotationConstants.SQL_RESULT_SET_MAPPINGS_ANNO.fqn(javaeeType), s -> {
            try {
                return ORMToAnnotationsConverter.createSqlResultSetMappingsAnnotationText(s, psiTargetClass, entityMappings);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private static String createSqlResultSetMappingsAnnotationText(SqlResultSetMapping mapping, PsiClass psiTargetClass, EntityMappings entityMappings) throws IncorrectOperationException {
        ArrayList<String> entityResultList = new ArrayList<String>();
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)psiTargetClass, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
        for (EntityResult entityResult : mapping.getEntityResults()) {
            String className = ORMToAnnotationsConverter.getClassQName(entityResult.getEntityClass().getStringValue(), entityMappings.getPackage().getStringValue());
            ArrayList<String> fieldResultList = new ArrayList<String>();
            for (FieldResult fieldResult : entityResult.getFieldResults()) {
                String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, (String)JpaAnnotationConstants.FIELD_RESULT_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)((String)fieldResult.getName().getValue())), null, "column", AnnotationTextUtil.quote((String)fieldResult.getColumn().getStringValue()), null});
                fieldResultList.add(text);
            }
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, (String)JpaAnnotationConstants.ENTITY_RESULT_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"entityClass", className == null ? null : className + ".class", null, "fields", AnnotationTextUtil.createStringArrayInitializer(fieldResultList, (String[])new String[0]), null, "discriminatorColumn", AnnotationTextUtil.quote((String)entityResult.getDiscriminatorColumn().getStringValue()), null});
            entityResultList.add(text);
        }
        ArrayList<String> columnResultList = new ArrayList<String>();
        for (ColumnResult result : mapping.getColumnResults()) {
            columnResultList.add(result.getName().getStringValue());
        }
        return AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, (String)JpaAnnotationConstants.SQL_RESULT_SET_MAPPING_ANNO.fqn(javaeeType), (boolean)false, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)((String)mapping.getName().getValue())), null, "entities", AnnotationTextUtil.createStringArrayInitializer(entityResultList, (String[])new String[0]), null, "columns", AnnotationTextUtil.createStringArrayInitializer(columnResultList, (String[])new String[]{"\""}), null});
    }

    private void createNamedQueriesAnnotation(List<? extends NamedQuery> list, PsiClass psiTargetClass, boolean isNative, JavaeeType javaeeType) {
        Ref error = new Ref();
        this.createMultiAnnotation(list, (PsiMember)psiTargetClass, isNative ? JpaAnnotationConstants.NAMED_NATIVE_QUERY_ANNO.fqn(javaeeType) : JpaAnnotationConstants.NAMED_QUERY_ANNO.fqn(javaeeType), isNative ? JpaAnnotationConstants.NAMED_NATIVE_QUERIES_ANNO.fqn(javaeeType) : JpaAnnotationConstants.NAMED_QUERIES_ANNO.fqn(javaeeType), s -> {
            try {
                return ORMToAnnotationsConverter.createNamedQueryAnnotationText(s, psiTargetClass, javaeeType);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private static String createNamedQueryAnnotationText(NamedQuery queryBase, PsiClass psiTargetClass, JavaeeType javaeeType) throws IncorrectOperationException {
        if (queryBase instanceof NamedNativeQuery) {
            NamedNativeQuery query = (NamedNativeQuery)queryBase;
            String resultClass = query.getResultClass().getStringValue();
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, (String)JpaAnnotationConstants.NAMED_QUERY_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)((String)query.getName().getValue())), null, "query", AnnotationTextUtil.quote((String)((String)query.getQuery().getValue())), null, "hints", ORMToAnnotationsConverter.createHintsArray(query.getHints(), psiTargetClass, javaeeType), null, "resultClass", resultClass == null ? null : resultClass + ".class", null, "resultSetMapping", AnnotationTextUtil.quote((String)((String)query.getResultSetMapping().getValue())), null});
        }
        NamedQuery query = queryBase;
        return AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, (String)JpaAnnotationConstants.NAMED_QUERY_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)((String)query.getName().getValue())), null, "query", AnnotationTextUtil.quote((String)((String)query.getQuery().getValue())), null, "hints", ORMToAnnotationsConverter.createHintsArray(query.getHints(), psiTargetClass, javaeeType), null});
    }

    private static String createHintsArray(List<QueryHint> hints, PsiClass psiTargetClass, JavaeeType javaeeType) throws IncorrectOperationException {
        if (hints.isEmpty()) {
            return null;
        }
        ArrayList<String> annoList = new ArrayList<String>();
        for (QueryHint hint : hints) {
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, (String)JpaAnnotationConstants.QUERY_HINT_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)((String)hint.getName().getValue())), null, "value", AnnotationTextUtil.quote((String)((String)hint.getValue().getValue())), null});
            annoList.add(text);
        }
        return AnnotationTextUtil.createStringArrayInitializer(annoList, (String[])new String[0]);
    }

    private void migrateEntityBase(EntityMappings entityMappings, EntityBase entity, PsiClass psiTargetClass, JavaeeType javaeeType) {
        String idClass;
        Boolean excludeSuperListeners;
        this.createEntityListenerAnnotations(entity, javaeeType);
        Boolean excludeDefListeners = (Boolean)entity.getExcludeDefaultListeners().getValue();
        if (excludeDefListeners != null && excludeDefListeners.booleanValue()) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.EXCLUDE_DEFAULT_LISTENERS_ANNO.fqn(javaeeType), true, new String[0]);
        }
        if ((excludeSuperListeners = (Boolean)entity.getExcludeSuperclassListeners().getValue()) != null && excludeSuperListeners.booleanValue()) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.EXCLUDE_SUPERCLASS_LISTENERS_ANNO.fqn(javaeeType), true, new String[0]);
        }
        if (!entity.getEntityListeners().getEntityListeners().isEmpty()) {
            ArrayList<String> classNamesList = new ArrayList<String>();
            for (EntityListener entityListener : entity.getEntityListeners().getEntityListeners()) {
                classNamesList.add(entityListener.getClazz().getStringValue());
                PsiClass psiListenerClass = (PsiClass)entityListener.getClazz().getValue();
                if (psiListenerClass == null) continue;
                this.createEntityListenerAnnotations(entityListener, javaeeType);
            }
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.ENTITY_LISTENERS_ANNO.fqn(javaeeType), true, "value", AnnotationTextUtil.createStringArrayInitializer(classNamesList, (String[])new String[]{null, ".class"}), null);
        }
        if (entity.getIdClass().getXmlTag() != null && (idClass = ORMToAnnotationsConverter.getClassQName(entity.getIdClass().getClazz().getStringValue(), entityMappings.getPackage().getStringValue())) != null) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, JpaAnnotationConstants.ID_CLASS_ANNO.fqn(javaeeType), true, "value", idClass + ".class", null);
        }
        this.migrateAttributes(entity, psiTargetClass, entityMappings);
    }

    private void migrateAttributes(PersistentObjectBase persistent, PsiClass psiTargetClass, EntityMappings entityMappings) throws IncorrectOperationException {
        AccessType accessType = this.getAccessType(persistent, entityMappings);
        String defaultPackage = entityMappings.getPackage().getStringValue();
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)psiTargetClass, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
        for (PersistentAttribute attribute : persistent.getObjectModelHelper().getAttributes()) {
            if (attribute instanceof Basic) {
                Basic _basic = (Basic)attribute;
                this.createBasicAttribute(_basic, accessType, psiTargetClass, javaeeType);
                continue;
            }
            if (attribute instanceof com.intellij.jpa.model.common.persistence.mapping.EmbeddedId) {
                com.intellij.jpa.model.common.persistence.mapping.EmbeddedId _embeddedId = (com.intellij.jpa.model.common.persistence.mapping.EmbeddedId)attribute;
                this.createEmbeddedIdAttribute(_embeddedId, accessType, psiTargetClass, javaeeType);
                continue;
            }
            if (attribute instanceof com.intellij.jpa.model.common.persistence.mapping.Id) {
                com.intellij.jpa.model.common.persistence.mapping.Id _id = (com.intellij.jpa.model.common.persistence.mapping.Id)attribute;
                this.createIdAttribute(_id, accessType, psiTargetClass, javaeeType);
                continue;
            }
            if (attribute instanceof com.intellij.jpa.model.common.persistence.mapping.Embedded) {
                com.intellij.jpa.model.common.persistence.mapping.Embedded _embedded = (com.intellij.jpa.model.common.persistence.mapping.Embedded)attribute;
                this.createEmbeddedAttribute(_embedded, accessType, psiTargetClass, javaeeType);
                continue;
            }
            if (attribute instanceof com.intellij.jpa.model.common.persistence.mapping.Version) {
                com.intellij.jpa.model.common.persistence.mapping.Version _version = (com.intellij.jpa.model.common.persistence.mapping.Version)attribute;
                this.createVersionAttribute(_version, accessType, psiTargetClass, javaeeType);
                continue;
            }
            if (attribute instanceof Transient) {
                Transient _aTransient = (Transient)attribute;
                this.createTransientAttribute(_aTransient, accessType, psiTargetClass, javaeeType);
                continue;
            }
            if (attribute instanceof com.intellij.jpa.model.common.persistence.mapping.ManyToOne) {
                com.intellij.jpa.model.common.persistence.mapping.ManyToOne _manyToOne = (com.intellij.jpa.model.common.persistence.mapping.ManyToOne)attribute;
                this.createManyToOneAttribute(_manyToOne, accessType, psiTargetClass, defaultPackage, javaeeType);
                continue;
            }
            if (attribute instanceof OneToMany) {
                OneToMany _oneToMany = (OneToMany)attribute;
                this.createOneToManyAttribute(_oneToMany, accessType, psiTargetClass, defaultPackage, javaeeType);
                continue;
            }
            if (attribute instanceof com.intellij.jpa.model.common.persistence.mapping.OneToOne) {
                com.intellij.jpa.model.common.persistence.mapping.OneToOne _oneToOne = (com.intellij.jpa.model.common.persistence.mapping.OneToOne)attribute;
                this.createOneToOneAttribute(_oneToOne, accessType, psiTargetClass, defaultPackage, javaeeType);
                continue;
            }
            if (!(attribute instanceof ManyToMany)) continue;
            ManyToMany _manyToMany = (ManyToMany)attribute;
            this.createManyToManyAttribute(_manyToMany, accessType, psiTargetClass, defaultPackage, javaeeType);
        }
    }

    public void createManyToManyAttribute(ManyToMany _manyToMany, AccessType accessType, PsiClass psiTargetClass, String defaultPackage, JavaeeType javaeeType) throws IncorrectOperationException {
        com.intellij.jpa.model.xml.persistence.mapping.ManyToMany manyToMany = (com.intellij.jpa.model.xml.persistence.mapping.ManyToMany)_manyToMany;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)manyToMany.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)((Object)manyToMany.getFetch().getValue());
        String targetEntity = ORMToAnnotationsConverter.getClassQName(manyToMany.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.MANY_TO_MANY_ANNO.fqn(javaeeType), true, "cascade", ORMToAnnotationsConverter.createCascadeArrayInitializer(manyToMany.getCascade(), javaeeType), null, "fetch", fetch == null ? null : JpaConstants.FETCH_TYPE_PREFIX.fqn(javaeeType) + fetch.name(), null, "mappedBy", AnnotationTextUtil.quote((String)manyToMany.getMappedBy().getStringValue()), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.ONE_TO_ONE_ANNO.fqn(javaeeType), JpaAnnotationConstants.MANY_TO_ONE_ANNO.fqn(javaeeType), JpaAnnotationConstants.ONE_TO_MANY_ANNO.fqn(javaeeType));
        if (manyToMany.getMapKey().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.MAP_KEY_ANNO.fqn(javaeeType), true, "name", AnnotationTextUtil.quote((String)manyToMany.getMapKey().getTargetAttribute().getStringValue()), null);
        }
        if (manyToMany.getOrderBy().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.ORDER_BY_ANNO.fqn(javaeeType), true, "value", AnnotationTextUtil.quote((String)((String)manyToMany.getOrderBy().getValue())), null);
        }
        this.createJoinTableOrColumnsAnnotation(manyToMany, psiMember, javaeeType);
    }

    public void createOneToOneAttribute(com.intellij.jpa.model.common.persistence.mapping.OneToOne _oneToOne, AccessType accessType, PsiClass psiTargetClass, String defaultPackage, JavaeeType javaeeType) throws IncorrectOperationException {
        OneToOne oneToOne = (OneToOne)_oneToOne;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)oneToOne.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)((Object)oneToOne.getFetch().getValue());
        Boolean optional = (Boolean)oneToOne.getOptional().getValue();
        String targetEntity = ORMToAnnotationsConverter.getClassQName(oneToOne.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.ONE_TO_ONE_ANNO.fqn(javaeeType), true, "cascade", ORMToAnnotationsConverter.createCascadeArrayInitializer(oneToOne.getCascade(), javaeeType), null, "fetch", fetch == null ? null : JpaConstants.FETCH_TYPE_PREFIX.fqn(javaeeType) + fetch.name(), null, "mappedBy", AnnotationTextUtil.quote((String)oneToOne.getMappedBy().getStringValue()), null, "optional", optional == null ? null : optional.toString(), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.MANY_TO_MANY_ANNO.fqn(javaeeType), JpaAnnotationConstants.MANY_TO_ONE_ANNO.fqn(javaeeType), JpaAnnotationConstants.ONE_TO_MANY_ANNO.fqn(javaeeType));
        this.createJoinTableOrColumnsAnnotation(oneToOne, psiMember, javaeeType);
    }

    public void createOneToManyAttribute(OneToMany _oneToMany, AccessType accessType, PsiClass psiTargetClass, String defaultPackage, JavaeeType javaeeType) throws IncorrectOperationException {
        com.intellij.jpa.model.xml.persistence.mapping.OneToMany oneToMany = (com.intellij.jpa.model.xml.persistence.mapping.OneToMany)_oneToMany;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)oneToMany.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)((Object)oneToMany.getFetch().getValue());
        String targetEntity = ORMToAnnotationsConverter.getClassQName(oneToMany.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.ONE_TO_MANY_ANNO.fqn(javaeeType), true, "cascade", ORMToAnnotationsConverter.createCascadeArrayInitializer(oneToMany.getCascade(), javaeeType), null, "fetch", fetch == null ? null : JpaConstants.FETCH_TYPE_PREFIX.fqn(javaeeType) + fetch.name(), null, "mappedBy", AnnotationTextUtil.quote((String)oneToMany.getMappedBy().getStringValue()), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.MANY_TO_MANY_ANNO.fqn(javaeeType), JpaAnnotationConstants.MANY_TO_ONE_ANNO.fqn(javaeeType), JpaAnnotationConstants.ONE_TO_ONE_ANNO.fqn(javaeeType));
        if (oneToMany.getMapKey().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.MAP_KEY_ANNO.fqn(javaeeType), true, "name", AnnotationTextUtil.quote((String)oneToMany.getMapKey().getTargetAttribute().getStringValue()), null);
        }
        if (oneToMany.getOrderBy().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.ORDER_BY_ANNO.fqn(javaeeType), true, "value", AnnotationTextUtil.quote((String)((String)oneToMany.getOrderBy().getValue())), null);
        }
        this.createJoinTableOrColumnsAnnotation(oneToMany, psiMember, javaeeType);
    }

    public void createManyToOneAttribute(com.intellij.jpa.model.common.persistence.mapping.ManyToOne _manyToOne, AccessType accessType, PsiClass psiTargetClass, String defaultPackage, JavaeeType javaeeType) throws IncorrectOperationException {
        ManyToOne manyToOne = (ManyToOne)_manyToOne;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)manyToOne.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)((Object)manyToOne.getFetch().getValue());
        Boolean optional = (Boolean)manyToOne.getOptional().getValue();
        String targetEntity = ORMToAnnotationsConverter.getClassQName(manyToOne.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.MANY_TO_ONE_ANNO.fqn(javaeeType), true, "cascade", ORMToAnnotationsConverter.createCascadeArrayInitializer(manyToOne.getCascade(), javaeeType), null, "fetch", fetch == null ? null : JpaConstants.FETCH_TYPE_PREFIX.fqn(javaeeType) + fetch.name(), null, "optional", optional == null ? null : optional.toString(), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.MANY_TO_MANY_ANNO.fqn(javaeeType), JpaAnnotationConstants.ONE_TO_MANY_ANNO.fqn(javaeeType), JpaAnnotationConstants.ONE_TO_ONE_ANNO.fqn(javaeeType));
        this.createJoinTableOrColumnsAnnotation(manyToOne, psiMember, javaeeType);
    }

    public void createTransientAttribute(Transient _aTransient, AccessType accessType, PsiClass psiTargetClass, JavaeeType javaeeType) throws IncorrectOperationException {
        com.intellij.jpa.model.xml.persistence.mapping.Transient aTransient = (com.intellij.jpa.model.xml.persistence.mapping.Transient)_aTransient;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)aTransient.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.TRANSIENT_ANNO.fqn(javaeeType), true, new String[0]);
    }

    public void createVersionAttribute(com.intellij.jpa.model.common.persistence.mapping.Version _version, AccessType accessType, PsiClass psiTargetClass, JavaeeType javaeeType) throws IncorrectOperationException {
        Version version = (Version)_version;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)version.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.VERSION_ANNO.fqn(javaeeType), true, new String[0]);
        this.createAttributeWithColumnCommonAnnotations(version, psiMember, javaeeType);
    }

    public void createEmbeddedAttribute(com.intellij.jpa.model.common.persistence.mapping.Embedded _embedded, AccessType accessType, PsiClass psiTargetClass, JavaeeType javaeeType) throws IncorrectOperationException {
        Embedded embedded = (Embedded)_embedded;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)embedded.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.EMBEDDED_ANNO.fqn(javaeeType), true, new String[0]);
        this.createAttributeOverridesAnnotation(embedded.getAttributeOverrides(), psiMember[0], javaeeType);
        this.dropAnnotations((PsiModifierListOwner)psiMember[1], JpaAnnotationConstants.ATTRIBUTE_OVERRIDE_ANNO.fqn(javaeeType), JpaAnnotationConstants.ATTRIBUTE_OVERRIDES_ANNO.fqn(javaeeType));
    }

    public void createBasicAttribute(Basic _basic, AccessType accessType, PsiClass psiTargetClass, @NotNull JavaeeType javaeeType) throws IncorrectOperationException {
        com.intellij.jpa.model.xml.persistence.mapping.Basic basic;
        PsiMember[] psiMember;
        if (javaeeType == null) {
            ORMToAnnotationsConverter.$$$reportNull$$$0(0);
        }
        if ((psiMember = this.findPropertyPsiMember((String)(basic = (com.intellij.jpa.model.xml.persistence.mapping.Basic)_basic).getName().getValue(), accessType, psiTargetClass))[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)((Object)basic.getFetch().getValue());
        Boolean optional = (Boolean)basic.getOptional().getValue();
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.BASIC_ANNO.fqn(javaeeType), true, "fetch", fetch == null ? null : JpaConstants.FETCH_TYPE_PREFIX.fqn(javaeeType) + fetch.name(), JpaConstants.FETCH_TYPE_PREFIX.fqn(javaeeType) + FetchType.EAGER.name(), "optional", optional == null ? null : optional.toString(), null);
        if (basic.getLob().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.LOB_ANNO.fqn(javaeeType), true, new String[0]);
        }
        if (basic.getEnumerated().getXmlTag() != null) {
            Enumerated enumerated = (Enumerated)((Object)basic.getEnumerated().getValue());
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.ENUMERATED_ANNO.fqn(javaeeType), true, "value", enumerated == null ? null : JpaConstants.ENUM_TYPE_PREFIX.fqn(javaeeType) + enumerated.name(), JpaConstants.ENUM_TYPE_PREFIX.fqn(javaeeType) + Enumerated.STRING.name());
        }
        this.createAttributeWithColumnCommonAnnotations(basic, psiMember, javaeeType);
    }

    public void createEmbeddedIdAttribute(com.intellij.jpa.model.common.persistence.mapping.EmbeddedId _embeddedId, AccessType accessType, PsiClass psiTargetClass, JavaeeType javaeeType) throws IncorrectOperationException {
        EmbeddedId embeddedId = (EmbeddedId)_embeddedId;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)embeddedId.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.EMBEDDED_ID_ANNO.fqn(javaeeType), true, new String[0]);
        this.createAttributeOverridesAnnotation(embeddedId.getAttributeOverrides(), psiMember[0], javaeeType);
        this.dropAnnotations((PsiModifierListOwner)psiMember[1], JpaAnnotationConstants.ATTRIBUTE_OVERRIDE_ANNO.fqn(javaeeType), JpaAnnotationConstants.ATTRIBUTE_OVERRIDES_ANNO.fqn(javaeeType));
    }

    public void createIdAttribute(com.intellij.jpa.model.common.persistence.mapping.Id _id, AccessType accessType, PsiClass psiTargetClass, JavaeeType javaeeType) throws IncorrectOperationException {
        Id id = (Id)_id;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)id.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.ID_ANNO.fqn(javaeeType), true, new String[0]);
        if (id.getGeneratedValue().getXmlTag() != null) {
            GenerationType generatorType = (GenerationType)((Object)id.getGeneratedValue().getStrategy().getValue());
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.GENERATED_VALUE_ANNO.fqn(javaeeType), true, "strategy", generatorType == null ? null : JpaConstants.GENERATION_TYPE_PREFIX.fqn(javaeeType) + generatorType.name(), JpaConstants.GENERATION_TYPE_PREFIX.fqn(javaeeType) + GenerationType.AUTO.name(), "generator", AnnotationTextUtil.quote((String)((String)id.getGeneratedValue().getGenerator().getValue())), null);
        }
        this.createAttributeWithColumnCommonAnnotations(id, psiMember, javaeeType);
    }

    private void createAttributeWithColumnCommonAnnotations(AttributeWithColumn attributeWithColumn, PsiMember[] psiMember, JavaeeType javaeeType) throws IncorrectOperationException {
        if (attributeWithColumn.getTemporal().getValue() != null) {
            Temporal temporal = (Temporal)((Object)attributeWithColumn.getTemporal().getValue());
            this.createAnnotation((PsiModifierListOwner[])psiMember, JpaAnnotationConstants.TEMPORAL_ANNO.fqn(javaeeType), true, "value", temporal == null ? null : JpaConstants.TEMPORAL_TYPE_PREFIX.fqn(javaeeType) + temporal.name(), JpaConstants.TEMPORAL_TYPE_PREFIX.fqn(javaeeType) + TemporalType.TIMESTAMP.name());
        }
        if (attributeWithColumn.getColumn().getXmlTag() != null) {
            this.createColumnAnnotation(psiMember[0], attributeWithColumn.getColumn(), (String)attributeWithColumn.getName().getValue(), javaeeType);
            this.dropAnnotations((PsiModifierListOwner)psiMember[1], ORMToAnnotationsConverter.getColumnAnnotationName(attributeWithColumn.getColumn(), javaeeType));
        }
    }

    private static String createCascadeArrayInitializer(CascadeType cascade, JavaeeType javaeeType) {
        ArrayList<String> list = new ArrayList<String>();
        if (Boolean.TRUE.equals(cascade.getCascadeAll().getValue())) {
            list.add("ALL");
        }
        if (Boolean.TRUE.equals(cascade.getCascadeMerge().getValue())) {
            list.add("MERGE");
        }
        if (Boolean.TRUE.equals(cascade.getCascadePersist().getValue())) {
            list.add("PERSIST");
        }
        if (Boolean.TRUE.equals(cascade.getCascadeRefresh().getValue())) {
            list.add("REFRESH");
        }
        if (Boolean.TRUE.equals(cascade.getCascadeRemove().getValue())) {
            list.add("REMOVE");
        }
        return AnnotationTextUtil.createStringArrayInitializer(list, (String[])new String[]{JpaConstants.CASCADE_TYPE_PREFIX.fqn(javaeeType), ""});
    }

    private void createJoinTableOrColumnsAnnotation(RelationAttributeBase attribute, PsiMember[] psiMember, JavaeeType javaeeType) throws IncorrectOperationException {
        RelationAttributeBase.NonManyToManyBase nonManyToManyBase;
        if (attribute.getJoinTable().getXmlTag() != null) {
            this.createTableAnnotation(psiMember[0], attribute.getJoinTable(), null, javaeeType);
            this.dropAnnotations((PsiModifierListOwner)psiMember[1], ORMToAnnotationsConverter.getTableAnnotationName(attribute.getJoinTable(), javaeeType));
        } else if (attribute instanceof RelationAttributeBase.NonManyToManyBase && !(nonManyToManyBase = (RelationAttributeBase.NonManyToManyBase)attribute).getJoinColumns().isEmpty()) {
            String columnNameDef = null;
            this.createJoinColumnsAnnotation(nonManyToManyBase.getJoinColumns(), psiMember[0], columnNameDef, javaeeType);
            this.dropAnnotations((PsiModifierListOwner)psiMember[1], JpaAnnotationConstants.JOIN_COLUMN_ANNO.fqn(javaeeType), JpaAnnotationConstants.JOIN_COLUMNS_ANNO.fqn(javaeeType));
        }
    }

    private void createSecondaryTablesAnnotation(List<SecondaryTable> list, PsiMember psiMember, JavaeeType javaeeType) {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, JpaAnnotationConstants.SECONDARY_TABLE_ANNO.fqn(javaeeType), JpaAnnotationConstants.SECONDARY_TABLES_ANNO.fqn(javaeeType), s -> {
            try {
                return this.createTableAnnotationText(psiMember, (Table)s, null, null, javaeeType);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private <T> void createMultiAnnotation(List<? extends T> list, PsiMember psiMember, String singleAnnoName, String multiAnnoName, Function<? super T, String> function) throws IncorrectOperationException {
        AnnotationTextUtil.createMultiAnnotation((Collection)ContainerUtil.mapNotNull(list, function), (Object)psiMember, (String)singleAnnoName, (String)multiAnnoName, (AnnotationManipulator)this);
    }

    private void createAttributeOverridesAnnotation(List<AttributeOverride> list, PsiMember psiMember, JavaeeType javaeeType) throws IncorrectOperationException {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, JpaAnnotationConstants.ATTRIBUTE_OVERRIDE_ANNO.fqn(javaeeType), JpaAnnotationConstants.ATTRIBUTE_OVERRIDES_ANNO.fqn(javaeeType), s -> {
            try {
                String columnAnno = this.createColumnAnnotationText(psiMember, s.getColumn(), (String)s.getName().getValue(), null, javaeeType);
                return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)JpaAnnotationConstants.ATTRIBUTE_OVERRIDE_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)((String)s.getName().getValue())), null, "column", columnAnno, null});
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private void createAssociationOverridesAnnotation(List<AssociationOverride> list, PsiMember psiMember, JavaeeType javaeeType) throws IncorrectOperationException {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, JpaAnnotationConstants.ASSOCIATION_OVERRIDE_ANNO.fqn(javaeeType), JpaAnnotationConstants.ASSOCIATION_OVERRIDES_ANNO.fqn(javaeeType), s -> {
            try {
                String joinColumns = AnnotationTextUtil.createStringArrayInitializer(this.createColumnsAnnosList(s.getJoinColumns(), psiMember, javaeeType), (String[])new String[0]);
                return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)JpaAnnotationConstants.ASSOCIATION_OVERRIDE_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)((String)s.getName().getValue())), null, "joinColumns", joinColumns, null});
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private void createJoinColumnsAnnotation(List<JoinColumn> list, PsiMember psiMember, String columnNameDef, JavaeeType javaeeType) throws IncorrectOperationException {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, JpaAnnotationConstants.JOIN_COLUMN_ANNO.fqn(javaeeType), JpaAnnotationConstants.JOIN_COLUMNS_ANNO.fqn(javaeeType), s -> {
            try {
                return this.createColumnAnnotationText(psiMember, (ColumnBase)s, columnNameDef, null, javaeeType);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private List<String> createColumnsAnnosList(List<? extends ColumnBase> columns, PsiMember psiMember, JavaeeType javaeeType) throws IncorrectOperationException {
        ArrayList<String> annoList = new ArrayList<String>();
        for (ColumnBase columnBase : columns) {
            String text = this.createColumnAnnotationText(psiMember, columnBase, null, null, javaeeType);
            annoList.add(text);
        }
        return annoList;
    }

    private void createColumnAnnotation(PsiMember psiMember, ColumnBase column, String defColumnName, JavaeeType javaeeType) throws IncorrectOperationException {
        if (column.getXmlTag() == null) {
            return;
        }
        PsiModifierList modifierList = psiMember.getModifierList();
        String annotationName = ORMToAnnotationsConverter.getColumnAnnotationName(column, javaeeType);
        PsiAnnotation annotation = modifierList.findAnnotation(annotationName);
        String text = this.createColumnAnnotationText(psiMember, column, defColumnName, annotation, javaeeType);
        this.addAnnotation((PsiModifierListOwner)psiMember, text, annotation);
    }

    private void createTableAnnotation(PsiMember psiMember, Table table, String defaultTableName, JavaeeType javaeeType) throws IncorrectOperationException {
        if (table.getXmlTag() == null) {
            return;
        }
        PsiModifierList modifierList = psiMember.getModifierList();
        PsiAnnotation annotation = modifierList.findAnnotation(ORMToAnnotationsConverter.getTableAnnotationName(table, javaeeType));
        String text = this.createTableAnnotationText(psiMember, table, annotation, defaultTableName, javaeeType);
        this.addAnnotation((PsiModifierListOwner)psiMember, text, annotation);
    }

    @Nullable
    private String createColumnAnnotationText(PsiMember psiMember, ColumnBase columnBase, String defColumnName, PsiAnnotation curAnnotation, JavaeeType javaeeType) throws IncorrectOperationException {
        if (columnBase.getXmlTag() == null) {
            return null;
        }
        String realDefColumnName = this.myAddDefaultNames ? null : defColumnName;
        Boolean unique = (Boolean)columnBase.getUnique().getValue();
        Boolean nullable = (Boolean)columnBase.getNullable().getValue();
        Boolean insertable = (Boolean)columnBase.getInsertable().getValue();
        Boolean updatable = (Boolean)columnBase.getUpdatable().getValue();
        String annotationName = ORMToAnnotationsConverter.getColumnAnnotationName(columnBase, javaeeType);
        if (columnBase instanceof Column) {
            Column column = (Column)columnBase;
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)annotationName, (boolean)true, (PsiAnnotation)curAnnotation, (String[])new String[]{"name", AnnotationTextUtil.quote((String)columnBase.getName().getStringValue()), AnnotationTextUtil.quote((String)realDefColumnName), "unique", unique == null ? null : unique.toString(), null, "nullable", nullable == null ? null : nullable.toString(), null, "insertable", insertable == null ? null : insertable.toString(), null, "updatable", updatable == null ? null : updatable.toString(), null, "columnDefinition", AnnotationTextUtil.quote((String)((String)columnBase.getColumnDefinition().getValue())), null, "table", AnnotationTextUtil.quote((String)columnBase.getTable().getStringValue()), null, "length", ORMToAnnotationsConverter.toString(column.getLength().getValue()), null, "precision", ORMToAnnotationsConverter.toString(column.getPrecision().getValue()), null, "scale", ORMToAnnotationsConverter.toString(column.getScale().getValue()), null});
        }
        if (columnBase instanceof JoinColumn) {
            JoinColumn column = (JoinColumn)columnBase;
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)annotationName, (boolean)true, (PsiAnnotation)curAnnotation, (String[])new String[]{"name", AnnotationTextUtil.quote((String)columnBase.getName().getStringValue()), AnnotationTextUtil.quote((String)realDefColumnName), "referencedColumnName", AnnotationTextUtil.quote((String)((String)column.getReferencedColumnName().getValue())), null, "unique", unique == null ? null : unique.toString(), null, "nullable", nullable == null ? null : nullable.toString(), null, "insertable", insertable == null ? null : insertable.toString(), null, "updatable", updatable == null ? null : updatable.toString(), null, "columnDefinition", AnnotationTextUtil.quote((String)((String)columnBase.getColumnDefinition().getValue())), null, "table", AnnotationTextUtil.quote((String)columnBase.getTable().getStringValue()), null});
        }
        assert (false) : columnBase;
        return null;
    }

    private static String getColumnAnnotationName(ColumnBase columnBase, JavaeeType javaeeType) {
        return columnBase instanceof JoinColumn ? JpaAnnotationConstants.JOIN_COLUMN_ANNO.fqn(javaeeType) : JpaAnnotationConstants.COLUMN_ANNO.fqn(javaeeType);
    }

    private static String getTableAnnotationName(Table table, JavaeeType javaeeType) {
        if (table instanceof JoinTable) {
            return JpaAnnotationConstants.JOIN_TABLE_ANNO.fqn(javaeeType);
        }
        if (table instanceof CollectionTable) {
            return JpaAnnotationConstants.COLLECTION_TABLE_ANNO.fqn(javaeeType);
        }
        if (table instanceof SecondaryTable) {
            return JpaAnnotationConstants.SECONDARY_TABLE_ANNO.fqn(javaeeType);
        }
        return JpaAnnotationConstants.TABLE_ANNO.fqn(javaeeType);
    }

    public PsiMember[] findPropertyPsiMember(String name, AccessType type, PsiClass psiTargetClass) throws IncorrectOperationException {
        PsiMember[] result = new PsiMember[]{null, null};
        Pair<String, String> pair = this.myAttributeNameMap.get(name + ":" + psiTargetClass.getQualifiedName());
        PsiField psiField = psiTargetClass.findFieldByName(pair != null ? (String)pair.getFirst() : name, true);
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)psiTargetClass, (String)(pair != null ? (String)pair.getSecond() : name), (boolean)false, (boolean)true);
        result[type == null || type == AccessType.FIELD ? 0 : 1] = psiField;
        result[type == null || type == AccessType.FIELD ? 1 : 0] = getter;
        return result;
    }

    private AccessType getAccessType(PersistentObjectBase obj, EntityMappings entityMappings) {
        if (this.myDefaultAccessType != null) {
            return this.myDefaultAccessType;
        }
        AccessType access = (AccessType)((Object)obj.getAccess().getValue());
        AccessType defaultAccess = (AccessType)((Object)entityMappings.getAccess().getValue());
        if (access != null) {
            return access;
        }
        if (defaultAccess != null) {
            return defaultAccess;
        }
        return AccessType.PROPERTY;
    }

    @Nullable
    private String createTableAnnotationText(PsiMember psiMember, Table tableBase, PsiAnnotation curAnnotation, String defaultTableName, JavaeeType javaeeType) throws IncorrectOperationException {
        String annotationName = ORMToAnnotationsConverter.getTableAnnotationName(tableBase, javaeeType);
        if (tableBase instanceof JoinTable) {
            JoinTable table = (JoinTable)tableBase;
            String joinColumns = AnnotationTextUtil.createStringArrayInitializer(this.createColumnsAnnosList(table.getJoinColumns(), psiMember, javaeeType), (String[])new String[0]);
            String inverseJoinColumns = AnnotationTextUtil.createStringArrayInitializer(this.createColumnsAnnosList(table.getInverseJoinColumns(), psiMember, javaeeType), (String[])new String[0]);
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)annotationName, (boolean)true, (PsiAnnotation)curAnnotation, (String[])new String[]{"catalog", AnnotationTextUtil.quote((String)table.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote((String)table.getSchema().getStringValue()), null, "name", AnnotationTextUtil.quote((String)table.getTableName().getStringValue()), AnnotationTextUtil.quote((String)defaultTableName), "joinColumns", joinColumns, null, "inverseJoinColumns", inverseJoinColumns, null, "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(table.getUniqueConstraints(), psiMember, javaeeType), null});
        }
        if (tableBase instanceof SecondaryTable) {
            SecondaryTable table = (SecondaryTable)tableBase;
            String pkJoinColumns = ORMToAnnotationsConverter.createPkJoinColumnsArray(table.getPrimaryKeyJoinColumns(), psiMember, javaeeType);
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)annotationName, (boolean)true, (PsiAnnotation)curAnnotation, (String[])new String[]{"catalog", AnnotationTextUtil.quote((String)table.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote((String)table.getSchema().getStringValue()), null, "name", AnnotationTextUtil.quote((String)table.getTableName().getStringValue()), AnnotationTextUtil.quote((String)defaultTableName), "pkJoinColumns", pkJoinColumns, null, "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(table.getUniqueConstraints(), psiMember, javaeeType), null});
        }
        Table table = tableBase;
        return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)annotationName, (boolean)true, (PsiAnnotation)curAnnotation, (String[])new String[]{"catalog", AnnotationTextUtil.quote((String)table.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote((String)table.getSchema().getStringValue()), null, "name", AnnotationTextUtil.quote((String)table.getTableName().getStringValue()), AnnotationTextUtil.quote((String)defaultTableName), "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(table.getUniqueConstraints(), psiMember, javaeeType), null});
    }

    private static String createPkJoinColumnsArray(List<PrimaryKeyJoinColumn> primaryKeyJoinColumns, PsiMember psiMember, JavaeeType javaeeType) throws IncorrectOperationException {
        ArrayList<String> annosList = new ArrayList<String>();
        for (PrimaryKeyJoinColumn column : primaryKeyJoinColumns) {
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)JpaAnnotationConstants.PRIMARY_KEY_JOIN_COLUMN_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"name", AnnotationTextUtil.quote((String)column.getName().getStringValue()), null, "referencedColumnName", AnnotationTextUtil.quote((String)((String)column.getReferencedColumnName().getValue())), null, "columnDefinition", AnnotationTextUtil.quote((String)((String)column.getColumnDefinition().getValue())), null});
            annosList.add(text);
        }
        return AnnotationTextUtil.createStringArrayInitializer(annosList, (String[])new String[0]);
    }

    private static String createUniqueConstraintsArray(List<UniqueConstraint> uniqueConstraints, PsiMember psiMember, JavaeeType javaeeType) throws IncorrectOperationException {
        ArrayList<String> annosList = new ArrayList<String>();
        for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, (String)JpaAnnotationConstants.UNIQUE_CONSTRAINT_ANNO.fqn(javaeeType), (boolean)true, null, (String[])new String[]{"columnNames", AnnotationTextUtil.createGenericValueArrayInitializer(uniqueConstraint.getColumnNames(), (String[])new String[]{"\""}), null});
            annosList.add(text);
        }
        return AnnotationTextUtil.createStringArrayInitializer(annosList, (String[])new String[0]);
    }

    @Nullable
    public static PsiClass createClass(Module module, String classQName) throws IncorrectOperationException {
        if (classQName == null) {
            return null;
        }
        String pkgName = StringUtil.getPackageName((String)classQName);
        PsiDirectory psiDirectory = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)(StringUtil.isNotEmpty((String)pkgName) ? pkgName : ""), null, (boolean)false);
        if (psiDirectory == null) {
            return null;
        }
        return CreateClassUtil.createClassNamed((String)classQName, (String)"#DEFAULT_CLASS_TEMPLATE", (PsiDirectory)psiDirectory);
    }

    private static PsiMethod createPropertyGetter(PsiClass psiTargetClass, String fixedName, String defaultType, PsiMember[] psiMember) throws IncorrectOperationException {
        String fieldName = ORMToAnnotationsConverter.fixFieldName(fixedName, psiTargetClass);
        PsiField field = psiTargetClass.findFieldByName(fieldName, false);
        if (field == null) {
            field = ORMToAnnotationsConverter.createPropertyField(psiTargetClass, fieldName, defaultType);
        }
        PsiMethod psiGetter = PropertyUtilBase.generateGetterPrototype((PsiField)field);
        PsiMethod psiSetter = PropertyUtilBase.generateSetterPrototype((PsiField)field);
        if (!PropertyUtilBase.getPropertyNameByGetter((PsiMethod)psiGetter).equals(fixedName)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiTargetClass.getProject()).getElementFactory();
            psiGetter.getNameIdentifier().replace((PsiElement)factory.createIdentifier("get" + StringUtil.capitalize((String)fixedName)));
            psiSetter.getNameIdentifier().replace((PsiElement)factory.createIdentifier("set" + StringUtil.capitalize((String)fixedName)));
        }
        PsiMethod psiMethod = (PsiMethod)psiTargetClass.add((PsiElement)psiGetter);
        psiTargetClass.add((PsiElement)psiSetter);
        psiMember[0] = field;
        return psiMethod;
    }

    private static PsiField createPropertyField(PsiClass psiTargetClass, String fixedName, String defaultType) throws IncorrectOperationException {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiTargetClass.getProject()).getElementFactory();
        PsiField psiField = psiElementFactory.createFieldFromText("private " + defaultType + " " + fixedName + ";", (PsiElement)psiTargetClass);
        return (PsiField)psiTargetClass.add((PsiElement)psiField);
    }

    @NotNull
    public static String fixPropertyName(String text, PsiClass targetClass) {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)targetClass.getProject());
        if (text.equalsIgnoreCase("class")) {
            return "clazz";
        }
        if (psiNameHelper.isIdentifier(text, PsiUtil.getLanguageLevel((PsiElement)targetClass))) {
            String string = text;
            if (string == null) {
                ORMToAnnotationsConverter.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (text.isEmpty()) {
            return "a";
        }
        StringBuilder sb = new StringBuilder();
        char ch = text.charAt(0);
        if (!Character.isJavaIdentifierStart(ch)) {
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            } else {
                sb.append('_');
            }
        } else {
            sb.append(ch);
        }
        for (int i = 1; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                sb.append('_');
                continue;
            }
            sb.append(ch);
        }
        String string = sb.toString();
        if (string == null) {
            ORMToAnnotationsConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String fixFieldName(String fixedPropertyName, PsiClass targetClass) {
        String suggestedName;
        PsiManager psiManager = targetClass.getManager();
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)psiManager.getProject()).suggestVariableName(VariableKind.FIELD, fixedPropertyName, null, null);
        String string = suggestedName = suggestedNameInfo.names.length == 0 ? fixedPropertyName : suggestedNameInfo.names[0];
        if (!PsiNameHelper.getInstance((Project)psiManager.getProject()).isIdentifier(suggestedName, PsiUtil.getLanguageLevel((PsiElement)targetClass))) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)suggestedName);
        }
        return suggestedName;
    }

    private static String getClassQName(String className, String packageName) {
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) < 0 && packageName != null && !packageName.isEmpty()) {
            return packageName + "." + className;
        }
        return className;
    }

    @NonNls
    public static String getDefaultType(AttributeBase attr, List<EntityMappings> entityMappingsList) {
        if (attr.getDefaultTypeName() != null) {
            return attr.getDefaultTypeName();
        }
        if (attr instanceof Id) {
            Id id = (Id)attr;
            if (id.getTemporal().getValue() != null) {
                return ORMToAnnotationsConverter.getTemporalDefaultType((Temporal)((Object)id.getTemporal().getValue()));
            }
            return "java.lang.Long";
        }
        if (attr instanceof EmbeddedId) {
            String name = (String)attr.getName().getValue();
            return name == null ? "java.lang.Object" : StringUtil.capitalize((String)name);
        }
        if (attr instanceof com.intellij.jpa.model.xml.persistence.mapping.Basic) {
            com.intellij.jpa.model.xml.persistence.mapping.Basic basic = (com.intellij.jpa.model.xml.persistence.mapping.Basic)attr;
            if (basic.getTemporal().getValue() != null) {
                return ORMToAnnotationsConverter.getTemporalDefaultType((Temporal)((Object)basic.getTemporal().getValue()));
            }
            if (basic.getLob().getXmlTag() != null) {
                return "byte[]";
            }
            if (basic.getEnumerated().getXmlTag() != null) {
                return "java.lang.Enum";
            }
            return "java.lang.String";
        }
        if (attr instanceof Embedded) {
            String name = (String)attr.getName().getValue();
            return name == null ? "java.lang.Object" : StringUtil.capitalize((String)name);
        }
        if (attr instanceof Version) {
            Version version = (Version)attr;
            if (version.getTemporal().getValue() != null) {
                return ORMToAnnotationsConverter.getTemporalDefaultType((Temporal)((Object)version.getTemporal().getValue()));
            }
            return "java.lang.Long";
        }
        if (attr instanceof com.intellij.jpa.model.xml.persistence.mapping.ManyToMany) {
            com.intellij.jpa.model.xml.persistence.mapping.ManyToMany manyToMany = (com.intellij.jpa.model.xml.persistence.mapping.ManyToMany)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType(manyToMany, true, manyToMany.getMapKey(), entityMappingsList);
        }
        if (attr instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType(manyToOne, false, null, entityMappingsList);
        }
        if (attr instanceof com.intellij.jpa.model.xml.persistence.mapping.OneToMany) {
            com.intellij.jpa.model.xml.persistence.mapping.OneToMany oneToMany = (com.intellij.jpa.model.xml.persistence.mapping.OneToMany)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType(oneToMany, true, oneToMany.getMapKey(), entityMappingsList);
        }
        if (attr instanceof OneToOne) {
            OneToOne oneToOne = (OneToOne)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType(oneToOne, false, null, entityMappingsList);
        }
        if (attr instanceof com.intellij.jpa.model.xml.persistence.mapping.Transient) {
            return "java.lang.String";
        }
        return "java.lang.Integer";
    }

    private static String getTemporalDefaultType(Temporal value) {
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case Temporal.DATE -> "java.sql.Date";
            case Temporal.TIME -> "java.sql.Time";
            case Temporal.TIMESTAMP -> "java.sql.Timestamp";
        };
    }

    @NonNls
    private static String getDefaultCMRType(RelationAttributeBase mapping, boolean toMany, MapKey mapKey, List<EntityMappings> entityMappingsList) {
        String className;
        String entityName = mapping.getTargetEntityClass().getStringValue();
        if (entityName == null) {
            return "java.lang.Object";
        }
        Entity targetEntity = null;
        block0: for (EntityMappings entityMappings : entityMappingsList) {
            for (Entity entity : entityMappings.getEntities()) {
                if (!entityName.equals(entity.getName().getValue())) continue;
                targetEntity = entity;
                break block0;
            }
        }
        String string = className = targetEntity == null ? entityName : targetEntity.getClazz().getStringValue();
        if (toMany) {
            if (mapKey.getXmlTag() != null) {
                return "java.util.Map<java.lang.Object, " + (className == null ? "?" : className) + ">";
            }
            return "java.util.Collection<" + (className == null ? "?" : className) + ">";
        }
        return className == null ? "java.lang.Object" : className;
    }

    public void addAnnotation(PsiModifierListOwner psiMember, String text, PsiAnnotation annotation) throws IncorrectOperationException {
        if (text == null) {
            return;
        }
        PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)psiMember.getProject()).getElementFactory().createAnnotationFromText(text, null);
        if (annotation == null) {
            this.addUsageInfo(new AddUsageInfo((PsiElement)psiMember.getModifierList(), (PsiElement)psiAnnotation));
        } else {
            this.addUsageInfo(new ReplaceUsageInfo((PsiElement)annotation, (PsiElement)psiAnnotation));
        }
    }

    public void removeAnnotation(PsiModifierListOwner owner, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
        this.addUsageInfo(new DeleteUsageInfo((PsiElement)existingAnnotation));
    }

    public PsiAnnotation findAnnotation(PsiModifierListOwner psiMember, String annotationName) {
        PsiModifierList list = psiMember.getModifierList();
        return this.findAddedAnnotation(list, list.findAnnotation(annotationName), annotationName);
    }

    @NotNull
    public PsiElement getElement(PsiModifierListOwner owner) {
        PsiModifierListOwner psiModifierListOwner = owner;
        if (psiModifierListOwner == null) {
            ORMToAnnotationsConverter.$$$reportNull$$$0(3);
        }
        return psiModifierListOwner;
    }

    private void createAnnotation(PsiModifierListOwner[] object, String annotationName, boolean merge, String ... arguments) throws IncorrectOperationException {
        assert (object.length == 2);
        this.createAnnotation(object[0], annotationName, merge, arguments);
        this.dropAnnotations(object[1], annotationName);
    }

    private void dropAnnotations(PsiModifierListOwner[] object, String ... annotationNames) {
        assert (object.length == 2);
        this.dropAnnotations(object[0], annotationNames);
        this.dropAnnotations(object[1], annotationNames);
    }

    private void dropAnnotations(PsiModifierListOwner object, String ... annotationNames) {
        if (object != null) {
            for (String annotationName : annotationNames) {
                PsiAnnotation psiAnnotation = object.getModifierList().findAnnotation(annotationName);
                if (psiAnnotation == null) continue;
                this.addUsageInfo(new DeleteUsageInfo((PsiElement)psiAnnotation));
            }
        }
    }

    private void createAnnotation(PsiModifierListOwner object, String annotationName, boolean merge, String ... arguments) throws IncorrectOperationException {
        PsiModifierList modifierList = object.getModifierList();
        PsiAnnotation annotation = this.findAddedAnnotation(modifierList, modifierList.findAnnotation(annotationName), annotationName);
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)object, (String)annotationName, (boolean)merge, (PsiAnnotation)annotation, (String[])arguments);
        this.addAnnotation(object, text, annotation);
    }

    private static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static boolean canModify(PsiElement psiElement) {
        return psiElement != null && CommonRefactoringUtil.checkReadOnlyStatus((Project)psiElement.getProject(), (PsiElement)psiElement);
    }

    @Nullable
    public static String getTargetEntityClassName(PsiMember psiMember) {
        PsiType type = PersistenceCommonUtil.getTargetEntityType((PsiMember)psiMember);
        return type == null ? null : type.getCanonicalText();
    }

    public static void ensureJpaApiLibraryExists(Module module) {
        ORMToAnnotationsConverter.ensureJpaApiLibraryExists(module, JavaeeType.discover((Module)module, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO));
    }

    public static void ensureJpaApiLibraryExists(Module module, JavaeeType javaeeType) {
        PsiClass entityClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(JpaAnnotationConstants.ENTITY_ANNO.fqn(javaeeType), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (entityClass == null) {
            JavaeeLibrariesUtil.addJavaeeLibrary((Module)module, (JavaeeVersion)JavaeeVersion.JAVAEE_6);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/generation/ORMToAnnotationsConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/generation/ORMToAnnotationsConverter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fixPropertyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBasicAttribute";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    static class ReplaceUsageInfo
    extends MyUsageInfo {
        PsiElement myNewElement;

        ReplaceUsageInfo(PsiElement element, PsiElement newElement) {
            super(element);
            this.myNewElement = newElement;
        }

        @Override
        public PsiElement processUsage() {
            if (!ORMToAnnotationsConverter.canModify(this.getElement())) {
                return null;
            }
            return this.getElement().replace(this.myNewElement);
        }
    }

    static class DeleteUsageInfo
    extends MyUsageInfo {
        DeleteUsageInfo(PsiElement element) {
            super(element);
        }

        @Override
        public PsiElement processUsage() {
            if (!ORMToAnnotationsConverter.canModify(this.getElement())) {
                return null;
            }
            this.getElement().delete();
            return null;
        }
    }

    static abstract class MyUsageInfo
    extends UsageInfo {
        MyUsageInfo(PsiElement element) {
            super(element);
        }

        @Nullable
        public abstract PsiElement processUsage() throws Exception;
    }

    static class AddUsageInfo
    extends MyUsageInfo {
        List<PsiElement> list = new ArrayList<PsiElement>();

        AddUsageInfo(PsiElement element, PsiElement newElement) {
            super(element);
            this.list.add(newElement);
        }

        @Override
        public PsiElement processUsage() {
            if (!ORMToAnnotationsConverter.canModify(this.getElement())) {
                return null;
            }
            PsiElement anchor = null;
            for (PsiElement psiElement : this.list) {
                anchor = this.getElement().addAfter(psiElement, anchor);
            }
            return this.getElement();
        }
    }
}

