/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaUastInspectionUtil;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.jpa.requests.SimpleAnnotatedMethodRequest;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.ParametersKt;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmSubstitutor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

public final class JpaEntityListenerWarningsInspection
extends AbstractUastJpaInspection {
    @Override
    protected void checkClass(UClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        if (role.getEntityListener() == null) {
            return;
        }
        JpaEntityListenerWarningsInspection.checkNoListenerMethodsDefinedWarning(aClass, holder);
    }

    private static void checkNoListenerMethodsDefinedWarning(UClass aClass, ProblemsHolder holder) {
        Optional<Pair<EntityListenerMethodType, UMethod>> anyAnnotatedMethod = JpaUastInspectionUtil.findEntityListenerMethods(aClass).findAny();
        if (anyAnnotatedMethod.isPresent()) {
            return;
        }
        PsiElement anchorPsi = UDeclarationKt.getAnchorPsi((UDeclaration)aClass);
        PsiElement classSourcePsi = aClass.getSourcePsi();
        if (anchorPsi == null || classSourcePsi == null) {
            return;
        }
        SmartPsiElementPointer classPointer = SmartPointerManager.getInstance((Project)holder.getProject()).createSmartPsiElementPointer(classSourcePsi);
        holder.registerProblem(anchorPsi, JpaHighlightingMessages.message("entity.listener.class.has.no.annotated.methods", aClass.getName()), new LocalQuickFix[]{new CreateListenerMethodsFix((SmartPsiElementPointer<PsiElement>)classPointer)});
    }

    private static void createEntityListenerMethods(UClass aClass, Project project, PsiFile file, Editor editor) {
        if (file == null || editor == null) {
            return;
        }
        PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)aClass.getJavaPsi().getManager(), (GlobalSearchScope)aClass.getJavaPsi().getResolveScope());
        Map<String, UMethod> existingMethods = JpaEntityListenerWarningsInspection.findExistingListenerMethods(aClass, javaLangObject);
        for (EntityListenerMethodType type : EntityListenerMethodType.values()) {
            if (existingMethods.get(StringUtil.decapitalize((String)type.getTypeName())) != null) continue;
            JpaEntityListenerWarningsInspection.runAction((IntentionAction)ContainerUtil.getFirstItem(JpaEntityListenerWarningsInspection.createMethodAction(aClass, type, javaLangObject)), project, editor, file);
        }
        UClass updatedUClass = (UClass)UastContextKt.toUElement((PsiElement)aClass.getSourcePsi(), UClass.class);
        if (updatedUClass != null) {
            aClass = updatedUClass;
        } else {
            Logger.getInstance(JpaEntityListenerWarningsInspection.class).error("Wasn't able to update uClass", new Attachment[]{new Attachment(file.getName(), file.getText())});
        }
        existingMethods = JpaEntityListenerWarningsInspection.findExistingListenerMethods(aClass, javaLangObject);
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)file, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
        for (EntityListenerMethodType type : EntityListenerMethodType.values()) {
            PsiMethod psiMethod;
            UMethod method = existingMethods.get(StringUtil.decapitalize((String)type.getTypeName()));
            if (method == null || method.findAnnotation(type.getMethodAnnotation().fqn(javaeeType)) != null || (psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)method, PsiMethod.class)) == null) continue;
            JpaEntityListenerWarningsInspection.runAction((IntentionAction)ContainerUtil.getFirstItem((List)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)psiMethod, (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)type.getMethodAnnotation().fqn(javaeeType), (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]))), project, editor, file);
        }
    }

    private static Map<String, UMethod> findExistingListenerMethods(UClass aClass, PsiClassType objectType) {
        return ((StreamEx)StreamEx.of((Object[])aClass.getMethods()).filter(method -> method.getUastParameters().size() == 1 && TypeConversionUtil.isAssignable((PsiType)objectType, (PsiType)((UParameter)method.getUastParameters().get(0)).getType()))).toMap(method -> method.getName(), method -> method);
    }

    private static void runAction(IntentionAction action, Project project, Editor editor, PsiFile file) {
        if (action == null) {
            return;
        }
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)file)) {
            JpaEntityListenerWarningsInspection.runActionInner(action, project, editor, file);
        } else {
            ApplicationManager.getApplication().runWriteAction(() -> JpaEntityListenerWarningsInspection.runActionInner(action, project, editor, file));
        }
    }

    private static void runActionInner(IntentionAction action, Project project, Editor editor, PsiFile file) {
        Document document;
        action.invoke(project, editor, file);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState != null) {
            templateState.gotoEnd(false);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    private static List<IntentionAction> createMethodAction(UClass aClass, EntityListenerMethodType type, PsiClassType objectType) {
        return JvmElementActionFactories.createMethodActions((JvmClass)aClass.getJavaPsi(), (CreateMethodRequest)new SimpleAnnotatedMethodRequest(StringUtil.decapitalize((String)type.getTypeName()), Collections.singletonList(JvmModifier.PUBLIC), (JvmType)PsiTypes.voidType(), AnnotationRequestsKt.annotationRequest((String)type.getMethodAnnotation().fqn((PsiElement)aClass.getPsi()), (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]), ParametersKt.expectedParameter((JvmType)objectType, (String[])new String[]{"o"}), (JvmSubstitutor)new PsiJvmSubstitutor(aClass.getJavaPsi().getProject(), PsiSubstitutor.EMPTY)));
    }

    private static class CreateListenerMethodsFix
    extends IntentionAndQuickFixAction {
        @FileModifier.SafeFieldForPreview
        private final SmartPsiElementPointer<PsiElement> classPointer;

        private CreateListenerMethodsFix(SmartPsiElementPointer<PsiElement> classPointer) {
            this.classPointer = classPointer;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("intention.family.generate.entity.listener.methods", new Object[0]);
            if (string == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            UClass uClass;
            if (project == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(2);
            }
            if ((uClass = (UClass)UastContextKt.toUElementOfExpectedTypes((PsiElement)this.classPointer.getElement(), (Class[])new Class[]{UClass.class})) == null) {
                return;
            }
            JpaEntityListenerWarningsInspection.createEntityListenerMethods(uClass, project, psiFile, editor);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (project == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(5);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            PsiElement myTargetElement;
            if (target == null) {
                CreateListenerMethodsFix.$$$reportNull$$$0(7);
            }
            if ((myTargetElement = this.classPointer.getElement()) == null) {
                return null;
            }
            PsiElement sameElementInCopy = PsiTreeUtil.findSameElementInCopy((PsiElement)myTargetElement, (PsiFile)target);
            SmartPsiElementPointer nonPhysicalTarget = SmartPointerManager.getInstance((Project)myTargetElement.getProject()).createSmartPsiElementPointer(sameElementInCopy);
            return new CreateListenerMethodsFix((SmartPsiElementPointer<PsiElement>)nonPhysicalTarget);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection$CreateListenerMethodsFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection$CreateListenerMethodsFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

