/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.jpa.model.annotations.mapping.EmbeddableImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.EntityListenerImpl;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.jpa.model.annotations.mapping.MappedSuperclassImpl;
import com.intellij.jpa.model.annotations.mapping.NamedQueryBaseImpl;
import com.intellij.jpa.model.annotations.mapping.PersistentObjectImpl;
import com.intellij.jpa.model.annotations.mapping.ScopedEntityMappingsImpl;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.model.common.persistence.mapping.EntityListener;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerSet;
import com.intellij.jpa.model.common.persistence.mapping.EntityMappings;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.helpers.PersistenceMappingsModelHelper;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMappingsImpl
extends CommonModelElement.ModuleBase
implements JamEntityMappings,
PersistenceMappingsModelHelper {
    private final Module myModule;
    private final CachedValue<List<EntityImpl>> myEntitiesCachedValue;
    private final CachedValue<List<EntityListenerImpl>> myEntityListenersCachedValue;

    public EntityMappingsImpl(@NotNull Module module) {
        if (module == null) {
            EntityMappingsImpl.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myEntitiesCachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.calculateEntities(), (Object[])PersistenceCommonUtil.getPersistenceModificationTrackerDependencies((Project)module.getProject())), false);
        this.myEntityListenersCachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(this.calculateListeners(), (Object[])PersistenceCommonUtil.getPersistenceModificationTrackerDependencies((Project)module.getProject())), false);
    }

    private String @NotNull [] getEntityAnnotations() {
        String[] stringArray = new String[]{JpaAnnotationConstants.ENTITY_ANNO.fqn(this.myModule), "org.hibernate.annotations.Entity"};
        if (stringArray == null) {
            EntityMappingsImpl.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            EntityMappingsImpl.$$$reportNull$$$0(2);
        }
        return module;
    }

    @NotNull
    public PersistenceMappingsModelHelper getModelHelper() {
        EntityMappingsImpl entityMappingsImpl = this;
        if (entityMappingsImpl == null) {
            EntityMappingsImpl.$$$reportNull$$$0(3);
        }
        return entityMappingsImpl;
    }

    public GenericValue<PsiPackage> getPackage() {
        return AnnotationGenericValue.NULL;
    }

    public List<NamedQueryBaseImpl.NamedImpl> getNamedQueries() {
        return Collections.emptyList();
    }

    public List<NamedQueryBaseImpl.NativeImpl> getNamedNativeQueries() {
        return Collections.emptyList();
    }

    @Override
    public EntityListenerSet getDefaultEntityListeners() {
        return new MyEntityListenerSet();
    }

    public List<EntityListenerImpl> getEntityListeners() {
        return (List)this.myEntityListenersCachedValue.getValue();
    }

    public List<EntityImpl> getEntities() {
        return (List)this.myEntitiesCachedValue.getValue();
    }

    public List<PersistentObjectImpl> getPersistentObjects() {
        return ContainerUtil.concat((List[])new List[]{this.getEntities(), this.getMappedSuperclasses(), this.getEmbeddables()});
    }

    @NotNull
    protected List<EntityListenerImpl> calculateListeners() {
        ArrayList result = new ArrayList();
        for (PsiClass psiClass : JpaUtil.getEntityListenerClasses(this.myModule)) {
            ContainerUtil.addIfNotNull(result, (Object)((EntityListenerImpl)EntityListenerImpl.ENTITY_LISTENER_META.getJamElement((PsiModifierListOwner)psiClass)));
        }
        List<EntityListenerImpl> list = List.copyOf(result);
        if (list == null) {
            EntityMappingsImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<EntityImpl> calculateEntities() {
        JamService jamService = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList<EntityImpl> elements = new ArrayList<EntityImpl>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        for (String entityAnnotation : this.getEntityAnnotations()) {
            elements.addAll(jamService.getJamClassElements(EntityImpl.ENTITY_META, entityAnnotation, scope));
        }
        ArrayList<EntityImpl> arrayList = elements;
        if (arrayList == null) {
            EntityMappingsImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public List<EmbeddableImpl> getEmbeddables() {
        return EntityMappingsImpl.getModuleEmbeddables(this.myModule);
    }

    public List<MappedSuperclassImpl> getMappedSuperclasses() {
        return EntityMappingsImpl.getMappedSuperclasses(this.myModule);
    }

    @NotNull
    private static List<EmbeddableImpl> getModuleEmbeddables(Module module) {
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List elements = JamService.getJamService((Project)module.getProject()).getJamClassElements(EmbeddableImpl.EMBEDDABLE_META, JpaAnnotationConstants.EMBEDDABLE_ANNO.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.create(List.copyOf(elements), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
        if (list == null) {
            EntityMappingsImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<MappedSuperclassImpl> getMappedSuperclasses(Module module) {
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List elements = JamService.getJamService((Project)module.getProject()).getJamClassElements(MappedSuperclassImpl.MAPPED_SUPERCLASS_META, JpaAnnotationConstants.MAPPED_SUPERCLASS_ANNO.fqn(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.create(List.copyOf(elements), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
        if (list == null) {
            EntityMappingsImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static Condition<PsiClass> createUnitMappingsCondition(@Nullable GlobalSearchScope searchScope, @Nullable Collection<String> classNames, Collection<String> jarNames, Collection<String> packageNames) {
        return aClass -> {
            if (aClass == null) {
                return false;
            }
            String qName = aClass.getQualifiedName();
            if (classNames != null && classNames.contains(qName)) {
                return true;
            }
            if (packageNames != null && !packageNames.isEmpty()) {
                PsiPackage aPackage;
                PsiDirectory psiDirectory = aClass.getContainingFile().getContainingDirectory();
                PsiPackage psiPackage = aPackage = psiDirectory == null ? null : JavaDirectoryService.getInstance().getPackage(psiDirectory);
                if (aPackage != null && packageNames.contains(aPackage.getQualifiedName())) {
                    return true;
                }
            }
            VirtualFile virtualFile = aClass.getContainingFile().getVirtualFile();
            if (jarNames != null && !jarNames.isEmpty()) {
                VirtualFile jarFile;
                JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                if (virtualFile != null && virtualFile.getFileSystem() == jarFileSystem && (jarFile = jarFileSystem.getVirtualFileForJar(virtualFile)) != null && jarNames.contains(jarFile.getName())) {
                    return true;
                }
            }
            return EntityMappingsImpl.allEmpty(classNames, packageNames, jarNames) && searchScope != null && virtualFile != null && searchScope.contains(virtualFile);
        };
    }

    public static boolean allEmpty(Collection<String> ... collections) {
        for (Collection<String> collection : collections) {
            if (collection == null || collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public EntityMappings createCustomMappings(Condition<PsiClass> condition) {
        return new ScopedEntityMappingsImpl(this, condition);
    }

    public PropertyMemberType getDeclaredAccess() {
        return null;
    }

    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List<EntityListenerImpl> list = this.getEntityListeners();
        if (list == null) {
            EntityMappingsImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<EntityImpl> getPersistentEntities() {
        List<EntityImpl> list = this.getEntities();
        if (list == null) {
            EntityMappingsImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<MappedSuperclassImpl> getPersistentSuperclasses() {
        List<MappedSuperclassImpl> list = this.getMappedSuperclasses();
        if (list == null) {
            EntityMappingsImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<EmbeddableImpl> getPersistentEmbeddables() {
        List<EmbeddableImpl> list = this.getEmbeddables();
        if (list == null) {
            EntityMappingsImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateListeners";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateEntities";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleEmbeddables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedSuperclasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentListeners";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentEntities";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentSuperclasses";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentEmbeddables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    class MyEntityListenerSet
    extends CommonModelElement.ModuleBase
    implements EntityListenerSet,
    JamElement {
        MyEntityListenerSet() {
        }

        @Override
        public List<? extends EntityListener> getEntityListeners() {
            return Collections.emptyList();
        }

        @NotNull
        public Module getModule() {
            Module module = EntityMappingsImpl.this.getModule();
            if (module == null) {
                MyEntityListenerSet.$$$reportNull$$$0(0);
            }
            return module;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityMappingsImpl$MyEntityListenerSet", "getModule"));
        }
    }
}

