/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters;

import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistenceConvertersRegistry {
    private final Map<Class, Collection<Info>> myInfoMap = new HashMap<Class, Collection<Info>>();

    public <T extends DomElement> void registerValueConverter(Class<T> paramClass, Condition<T> condition, @NonNls String paramName, Converter converter) {
        Info info = this.getOrCreateInfo(paramClass, condition);
        info.myProviderSpecificMap.put(paramName, converter);
    }

    public <T extends DomElement> void registerGenericValueConverter(Class<T> paramClass, Condition<T> condition, @NonNls JavaeeClass paramName, Converter converter) {
        Info info = this.getOrCreateInfo(paramClass, condition);
        info.myJavaxMap.put(paramName.javax(), converter);
        info.myJakartaMap.put(paramName.jakarta(), converter);
    }

    protected <T extends DomElement> Info getOrCreateInfo(Class<T> paramClass, Condition<T> condition) {
        SmartList infos = this.myInfoMap.get(paramClass);
        if (infos == null) {
            infos = new SmartList();
            this.myInfoMap.put(paramClass, (Collection<Info>)infos);
        }
        for (Info info : infos) {
            if (info.myCondition != condition) continue;
            return info;
        }
        Info info = new Info();
        info.myProviderSpecificMap = new HashMap();
        info.myJavaxMap = new HashMap();
        info.myJakartaMap = new HashMap();
        info.myNameConverter = new NameConverter(info);
        info.myCondition = condition;
        infos.add(info);
        return info;
    }

    @Nullable
    public Converter<?> getValueConverter(DomElement domElement) {
        String name;
        Info info = this.getInfo(domElement);
        String string = name = info == null ? null : ElementPresentationManager.getElementName((Object)domElement);
        if (name == null) {
            return null;
        }
        Converter<?> converter = info.myProviderSpecificMap.get(name);
        if (converter != null) {
            return converter;
        }
        if (PersistenceConvertersRegistry.isJavax(domElement.getModule())) {
            return info.myJavaxMap.get(name);
        }
        return info.myJakartaMap.get(name);
    }

    @Nullable
    public Converter<?> getNameConverter(DomElement domElement) {
        Info info = this.getInfo(domElement);
        return info == null ? null : info.myNameConverter;
    }

    @NotNull
    public <T extends DomElement> Map<String, Converter> getConverters(Class<T> domClass) {
        Collection<Info> infos = this.myInfoMap.get(domClass);
        if (infos == null) {
            Map<String, Converter> map = Collections.emptyMap();
            if (map == null) {
                PersistenceConvertersRegistry.$$$reportNull$$$0(0);
            }
            return map;
        }
        HashMap<String, Converter> map = new HashMap<String, Converter>();
        for (Info info : infos) {
            map.putAll(info.myProviderSpecificMap);
        }
        HashMap<String, Converter> hashMap = map;
        if (hashMap == null) {
            PersistenceConvertersRegistry.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Nullable
    public <T extends DomElement> Converter getConverter(Class<T> domClass, String name) {
        Collection<Info> infos = this.myInfoMap.get(domClass);
        if (infos == null) {
            return null;
        }
        for (Info info : infos) {
            if (!info.myProviderSpecificMap.containsKey(name)) continue;
            return info.myProviderSpecificMap.get(name);
        }
        return null;
    }

    @Nullable
    protected Info getInfo(DomElement domElement) {
        for (Class<?> aClass : domElement.getClass().getInterfaces()) {
            Collection<Info> infos;
            if (!ReflectionUtil.isAssignable(DomElement.class, aClass) || (infos = this.myInfoMap.get(aClass)) == null) continue;
            for (Info info : infos) {
                if (!info.myCondition.value((Object)domElement)) continue;
                return info;
            }
        }
        return null;
    }

    public static boolean isJavax(Module module) {
        if (module == null) {
            Logger.getInstance(PersistenceConvertersRegistry.class).info("null argument passed for `module` parameter: using default javax namespace");
            return true;
        }
        return JavaeeType.discover((Module)module, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO).equals((Object)JavaeeType.JAVAX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistenceConvertersRegistry", "getConverters"));
    }

    protected static class Info {
        private Condition<DomElement> myCondition;
        private Map<String, Converter<?>> myProviderSpecificMap;
        private Map<String, Converter<?>> myJavaxMap;
        private Map<String, Converter<?>> myJakartaMap;
        private Converter<?> myNameConverter;

        protected Info() {
        }
    }

    private static class NameConverter
    extends ResolvingConverter<String> {
        private final Info myInfo;

        NameConverter(Info info) {
            this.myInfo = info;
        }

        @NotNull
        public Collection<String> getVariants(@NotNull ConvertContext context) {
            if (context == null) {
                NameConverter.$$$reportNull$$$0(0);
            }
            SmartList variants = new SmartList();
            variants.addAll(this.myInfo.myProviderSpecificMap.keySet());
            if (PersistenceConvertersRegistry.isJavax(context.getModule())) {
                variants.addAll(this.myInfo.myJavaxMap.keySet());
            } else {
                variants.addAll(this.myInfo.myJakartaMap.keySet());
            }
            SmartList smartList = variants;
            if (smartList == null) {
                NameConverter.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
            if (context == null) {
                NameConverter.$$$reportNull$$$0(2);
            }
            return s;
        }

        public String toString(@Nullable String s, @NotNull ConvertContext context) {
            if (context == null) {
                NameConverter.$$$reportNull$$$0(3);
            }
            return s;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/model/xml/impl/converters/PersistenceConvertersRegistry$NameConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/model/xml/impl/converters/PersistenceConvertersRegistry$NameConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariants";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

