/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.orm.structure;

import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.logical.impl.mappers.LogicalModelMapperProvider;
import com.intellij.ide.structureView.logical.model.LogicalModelPresentationProvider;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.jpa.jpb.model.JpaIcons;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.orm.ep.OrmMappingProvider;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.structuretw.OrmEntityAssociationAttribute;
import com.intellij.jpa.jpb.model.orm.structuretw.OrmEntityAttributeLogicalModel;
import com.intellij.jpa.orm.model.JpaOrmEntity;
import com.intellij.jpa.orm.structure.OrmEntityAttributeLogicalModelNavigatablePresentationProvider;
import com.intellij.jpa.util.OrmDbElementsUtilKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J,\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u0017j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0018`\u00192\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jpa/orm/structure/OrmEntityNavigatablePresentationProvider;", "Lcom/intellij/ide/structureView/logical/model/LogicalModelPresentationProvider;", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "Lcom/intellij/ide/structureView/logical/impl/mappers/LogicalModelMapperProvider;", "<init>", "()V", "associationPresentationProvider", "Lcom/intellij/jpa/orm/structure/OrmEntityAttributeLogicalModelNavigatablePresentationProvider;", "getName", "", "t", "getIcon", "Ljavax/swing/Icon;", "getColoredText", "", "Lcom/intellij/ide/util/treeView/PresentableNodeDescriptor$ColoredFragment;", "handleClick", "Ljava/util/concurrent/CompletableFuture;", "", "fragmentIndex", "", "type", "attributes", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nOrmEntityNavigatablePresentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmEntityNavigatablePresentationProvider.kt\ncom/intellij/jpa/orm/structure/OrmEntityNavigatablePresentationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class OrmEntityNavigatablePresentationProvider
extends LogicalModelPresentationProvider<OrmEntity>
implements LogicalModelMapperProvider<OrmEntity> {
    @NotNull
    private final OrmEntityAttributeLogicalModelNavigatablePresentationProvider associationPresentationProvider = new OrmEntityAttributeLogicalModelNavigatablePresentationProvider();

    @NotNull
    public String getName(@NotNull OrmEntity t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t instanceof OrmEntityAssociationAttribute) {
            return this.associationPresentationProvider.getName((OrmEntityAttributeLogicalModel)t);
        }
        return t.getName();
    }

    @NotNull
    public Icon getIcon(@NotNull OrmEntity t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t instanceof OrmEntityAssociationAttribute) {
            return this.associationPresentationProvider.getIcon((OrmEntityAttributeLogicalModel)t);
        }
        if (t instanceof JpaOrmEntity) {
            if (((JpaOrmEntity)t).isMappedSuperclass()) {
                Icon icon = JpaIcons.MappedSuperclass;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MappedSuperclass");
                return icon;
            }
            if (((JpaOrmEntity)t).isEmbeddable()) {
                Icon icon = JpaIcons.Embeddable;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Embeddable");
                return icon;
            }
        }
        Icon icon = AllIcons.Javaee.PersistenceEntity;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PersistenceEntity");
        return icon;
    }

    @NotNull
    public List<PresentableNodeDescriptor.ColoredFragment> getColoredText(@NotNull OrmEntity t) {
        List result;
        block6: {
            block5: {
                DbTable table;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof OrmEntityAssociationAttribute) {
                    return this.associationPresentationProvider.getColoredText((OrmEntityAttributeLogicalModel)t);
                }
                result = new ArrayList();
                result.add(new PresentableNodeDescriptor.ColoredFragment(t.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                if (t instanceof JpaOrmEntity) {
                    if (((JpaOrmEntity)t).isMappedSuperclass()) {
                        result.add(new PresentableNodeDescriptor.ColoredFragment(" @MappedSuperclass", SimpleTextAttributes.GRAYED_ATTRIBUTES));
                    } else if (((JpaOrmEntity)t).isEmbeddable()) {
                        result.add(new PresentableNodeDescriptor.ColoredFragment(" @Embeddable", SimpleTextAttributes.GRAYED_ATTRIBUTES));
                    }
                }
                if ((table = OrmDbElementsUtilKt.getDbTable$default(t, null, 2, null)) == null) break block5;
                result.add(new PresentableNodeDescriptor.ColoredFragment(" " + JpaModelBundle.message((String)"logical.orm.attribute.maps", (Object[])new Object[0]) + " ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES));
                result.add(new PresentableNodeDescriptor.ColoredFragment(table.getName(), SimpleTextAttributes.LINK_ATTRIBUTES));
                break block6;
            }
            Object object = OrmMappingProvider.Companion.findForFramework(t.getOrmFramework());
            if (object == null || (object = object.getTableName(t)) == null) break block6;
            Object tableName = object;
            boolean bl = false;
            result.add(new PresentableNodeDescriptor.ColoredFragment(" " + JpaModelBundle.message((String)"logical.orm.attribute.maps", (Object[])new Object[0]) + " ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES));
            result.add(new PresentableNodeDescriptor.ColoredFragment((String)tableName, new SimpleTextAttributes(16, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES.getFgColor(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES.getBgColor())));
        }
        return result;
    }

    @NotNull
    public CompletableFuture<Boolean> handleClick(@NotNull OrmEntity t, int fragmentIndex) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t instanceof OrmEntityAssociationAttribute) {
            return this.associationPresentationProvider.handleClick((OrmEntityAttributeLogicalModel)t, fragmentIndex);
        }
        if (fragmentIndex != 2) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ReadAction.nonBlocking(() -> OrmEntityNavigatablePresentationProvider.handleClick$lambda$1(t)).finishOnUiThread(ModalityState.any(), arg_0 -> OrmEntityNavigatablePresentationProvider.handleClick$lambda$3(arg_0 -> OrmEntityNavigatablePresentationProvider.handleClick$lambda$2(future, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return future;
    }

    @NotNull
    public String type(@NotNull OrmEntity t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t instanceof OrmEntityAssociationAttribute) {
            return this.associationPresentationProvider.type((OrmEntityAttributeLogicalModel)t);
        }
        return t.getOrmFramework().getName() + " Entity";
    }

    @NotNull
    public HashMap<String, Object> attributes(@NotNull OrmEntity t) {
        HashMap<String, Object> attrs;
        block5: {
            Object object;
            SmartPsiElementPointer smartPsiElementPointer;
            Object it;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (t instanceof OrmEntityAssociationAttribute) {
                Object object2;
                HashMap<String, Object> hashMap;
                HashMap<String, Object> attr = hashMap = this.associationPresentationProvider.attributes((OrmEntityAttributeLogicalModel)t);
                boolean bl = false;
                ((Map)attr).put("target-entity", ((OrmEntityAssociationAttribute)t).getEntity().getName());
                SmartPsiElementPointer smartPsiElementPointer2 = ((OrmEntityAssociationAttribute)t).getClassPsiPointer();
                if (smartPsiElementPointer2 != null && (smartPsiElementPointer2 = (PsiClass)smartPsiElementPointer2.getElement()) != null && (smartPsiElementPointer2 = smartPsiElementPointer2.getContainingFile()) != null && (smartPsiElementPointer2 = smartPsiElementPointer2.getVirtualFile()) != null) {
                    SmartPsiElementPointer it2 = smartPsiElementPointer2;
                    boolean bl2 = false;
                    ((Map)attr).put("file-path", it2.getPath());
                }
                if ((object2 = OrmDbElementsUtilKt.getDbTable$default(t, null, 2, null)) != null && (object2 = object2.getName()) != null) {
                    Object it3 = object2;
                    boolean bl3 = false;
                    ((Map)attr).put("db-table", it3);
                }
                return hashMap;
            }
            attrs = new HashMap<String, Object>();
            ((Map)attrs).put("name", t.getName());
            Object object3 = t.getParent();
            if (object3 != null && (object3 = object3.getName()) != null) {
                it = object3;
                boolean bl = false;
                ((Map)attrs).put("parent", it);
            }
            if ((smartPsiElementPointer = t.getClassPsiPointer()) != null && (smartPsiElementPointer = (PsiClass)smartPsiElementPointer.getElement()) != null && (smartPsiElementPointer = smartPsiElementPointer.getContainingFile()) != null && (smartPsiElementPointer = smartPsiElementPointer.getVirtualFile()) != null) {
                SmartPsiElementPointer it4 = smartPsiElementPointer;
                boolean bl = false;
                ((Map)attrs).put("file-path", it4.getPath());
            }
            if ((object = OrmDbElementsUtilKt.getDbTable$default(t, null, 2, null)) == null || (object = object.getName()) == null) break block5;
            it = object;
            boolean bl = false;
            ((Map)attrs).put("db-table", it);
        }
        return attrs;
    }

    private static final DbTable handleClick$lambda$1(OrmEntity $t) {
        return OrmDbElementsUtilKt.getDbTable$default($t, null, 2, null);
    }

    private static final Unit handleClick$lambda$2(CompletableFuture $future, DbTable table) {
        if (table != null) {
            DbNavigationUtils.navigateToDatabaseView((DbElement)((DbElement)table), (boolean)true);
        }
        $future.complete(table != null);
        return Unit.INSTANCE;
    }

    private static final void handleClick$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

