/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.editor;

import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.editor.QlQueriedClassesAndPackagesCacheKt;
import com.intellij.jpa.ql.editor.QlSyntaxHighlighter;
import com.intellij.jpa.ql.psi.QlAggregateExpression;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlArrayFunctionExpression;
import com.intellij.jpa.ql.psi.QlCastExpression;
import com.intellij.jpa.ql.psi.QlCoalesceExpression;
import com.intellij.jpa.ql.psi.QlDateTimeLiteral;
import com.intellij.jpa.ql.psi.QlDatetimeFunctionExpression;
import com.intellij.jpa.ql.psi.QlElementExpression;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlExtractExpression;
import com.intellij.jpa.ql.psi.QlFormatFunctionExpression;
import com.intellij.jpa.ql.psi.QlFunctionCallExpression;
import com.intellij.jpa.ql.psi.QlGroupByClause;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlIndicesExpression;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlNullifExpression;
import com.intellij.jpa.ql.psi.QlNumericFunctionExpression;
import com.intellij.jpa.ql.psi.QlOrderByClause;
import com.intellij.jpa.ql.psi.QlOverlayFunctionExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.jpa.ql.psi.QlStringFunctionExpression;
import com.intellij.jpa.ql.psi.QlTruncFunctionExpression;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, final @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            QlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            QlAnnotator.$$$reportNull$$$0(1);
        }
        psiElement.accept((PsiElementVisitor)new QlVisitor(){

            @Override
            public void visitAliasDefinition(@NotNull QlAliasDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                QlAnnotator.setHighlighting(o.getIdentifier(), holder, QlSyntaxHighlighter.ID_VARIABLE);
            }

            @Override
            public void visitFunctionCallExpression(@NotNull QlFunctionCallExpression o) {
                PsiElement nameToken;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((nameToken = o.getFirstChild()) != null) {
                    QlAnnotator.setHighlighting(nameToken, holder, QlSyntaxHighlighter.FUNCTION);
                }
            }

            @Override
            public void visitDatetimeFunctionExpression(@NotNull QlDatetimeFunctionExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitIndicesExpression(@NotNull QlIndicesExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitAggregateExpression(@NotNull QlAggregateExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitExtractExpression(@NotNull QlExtractExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(5);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitNumericFunctionExpression(@NotNull QlNumericFunctionExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(6);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitTruncFunctionExpression(@NotNull QlTruncFunctionExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(7);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitStringFunctionExpression(@NotNull QlStringFunctionExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(8);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitCoalesceExpression(@NotNull QlCoalesceExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(9);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitNullifExpression(@NotNull QlNullifExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(10);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitCastExpression(@NotNull QlCastExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(11);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitArrayFunctionExpression(@NotNull QlArrayFunctionExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(12);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitElementExpression(@NotNull QlElementExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(13);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitDateTimeLiteral(@NotNull QlDateTimeLiteral o) {
                if (o == null) {
                    1.$$$reportNull$$$0(14);
                }
                QlAnnotator.setHighlighting(o, holder, QlSyntaxHighlighter.DATETIME);
            }

            @Override
            public void visitOverlayFunctionExpression(@NotNull QlOverlayFunctionExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(15);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitFormatFunctionExpression(@NotNull QlFormatFunctionExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(16);
                }
                QlAnnotator.highlightFunctionName(o, holder);
            }

            @Override
            public void visitReferenceExpression(@NotNull QlReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(17);
                }
                QlIdentifier identifier = referenceExpression.getIdentifier();
                QlReferenceExpression topmostReferenceExpression = (QlReferenceExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)referenceExpression, QlReferenceExpression.class);
                if (topmostReferenceExpression != null && 1.isJvmClassOrPackage(topmostReferenceExpression)) {
                    QlAnnotator.setHighlighting(identifier, holder, QlSyntaxHighlighter.ENTITY);
                } else if (topmostReferenceExpression == null && 1.isJvmClassOrPackage(referenceExpression)) {
                    QlAnnotator.setHighlighting(identifier, holder, QlSyntaxHighlighter.ENTITY);
                } else if (1.isVariableDeclaredInQlFile(referenceExpression, identifier)) {
                    QlAnnotator.setHighlighting(identifier, holder, QlSyntaxHighlighter.ID_VARIABLE);
                } else if (1.isSegmentBeforeFirstDot(referenceExpression, identifier)) {
                    QlAnnotator.setHighlighting(identifier, holder, QlSyntaxHighlighter.ENTITY);
                } else if (1.isSegmentAfterFirstDot(referenceExpression, identifier)) {
                    QlAnnotator.setHighlighting(identifier, holder, QlSyntaxHighlighter.ATTRIBUTE);
                }
            }

            private static boolean isVariableDeclaredInQlFile(@NotNull QlReferenceExpression referenceExpression, @NotNull PsiElement identifier) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(18);
                }
                if (identifier == null) {
                    1.$$$reportNull$$$0(19);
                }
                SmartList psiElementSmartList = new SmartList();
                PsiScopeProcessor processor = 1.createResolveProcessor(identifier.getText(), (Collection<? super PsiElement>)psiElementSmartList);
                1.processDeclarationsInQlFile(referenceExpression, processor);
                return !psiElementSmartList.isEmpty();
            }

            private static PsiScopeProcessor createResolveProcessor(final String identifierText, final Collection<? super PsiElement> result) {
                class LocalAliasResolveProcessor
                implements PsiScopeProcessor,
                NameHint {
                    LocalAliasResolveProcessor() {
                    }

                    public boolean execute(@NotNull PsiElement psiElement, @NotNull ResolveState state) {
                        if (psiElement == null) {
                            LocalAliasResolveProcessor.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            LocalAliasResolveProcessor.$$$reportNull$$$0(1);
                        }
                        if (!(psiElement instanceof QlAliasDefinition)) {
                            return true;
                        }
                        String name = ((QlAliasDefinition)psiElement).getIdentifier().getText();
                        if (Comparing.equal((String)identifierText, (String)name, (boolean)false)) {
                            result.add(psiElement);
                            return false;
                        }
                        return true;
                    }

                    @Nullable
                    public String getName(@NotNull ResolveState state) {
                        if (state == null) {
                            LocalAliasResolveProcessor.$$$reportNull$$$0(2);
                        }
                        return "Local QL alias resolve processor";
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "psiElement";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "state";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/jpa/ql/editor/QlAnnotator$1$1LocalAliasResolveProcessor";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "execute";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getName";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }
                return new LocalAliasResolveProcessor();
            }

            private static void processDeclarationsInQlFile(@NotNull QlReferenceExpression referenceExpression, PsiScopeProcessor processor) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(20);
                }
                PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, (Class[])new Class[]{QlStatement.class, QlFile.class});
                ResolveState state = ResolveState.initial();
                PsiElement parent = referenceExpression.getParent();
                PsiFile containingFile = referenceExpression.getContainingFile();
                if (!(parent instanceof QlGroupByClause) && !(parent instanceof QlOrderByClause) && containingFile != null) {
                    containingFile.processDeclarations(processor, state, (PsiElement)referenceExpression, (PsiElement)referenceExpression);
                }
            }

            private static boolean isJvmClassOrPackage(@NotNull QlReferenceExpression referenceExpression) {
                Module module;
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(21);
                }
                if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)referenceExpression)) == null) {
                    return false;
                }
                String referenceExpressionText = referenceExpression.getText();
                String maybePackagePrefix = StringUtil.substringBeforeLast((String)referenceExpressionText, (String)".");
                return QlQueriedClassesAndPackagesCacheKt.isExistingPackage(maybePackagePrefix, module) || QlQueriedClassesAndPackagesCacheKt.isExistingClass(referenceExpressionText, module);
            }

            private static boolean isSegmentBeforeFirstDot(@NotNull QlReferenceExpression referenceExpression, @NotNull PsiElement identifier) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(22);
                }
                if (identifier == null) {
                    1.$$$reportNull$$$0(23);
                }
                IElementType siblingType = 1.siblingType(referenceExpression, false);
                TextRange referenceRange = referenceExpression.getTextRange();
                TextRange identifierRange = identifier.getTextRange();
                return referenceRange != null && referenceRange.equals((Object)identifierRange) && (siblingType == QlTypes.QL_DOT || siblingType == TokenType.WHITE_SPACE);
            }

            private static boolean isSegmentAfterFirstDot(@NotNull QlReferenceExpression referenceExpression, @NotNull PsiElement identifier) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(24);
                }
                if (identifier == null) {
                    1.$$$reportNull$$$0(25);
                }
                IElementType siblingType = 1.siblingType(identifier, true);
                TextRange referenceRange = referenceExpression.getTextRange();
                TextRange identifierRange = identifier.getTextRange();
                return referenceRange != null && identifierRange != null && referenceRange.getStartOffset() < identifierRange.getStartOffset() && siblingType == QlTypes.QL_DOT;
            }

            @Nullable
            private static IElementType siblingType(PsiElement currentElement, boolean prevSibling) {
                PsiElement sibling = prevSibling ? currentElement.getPrevSibling() : currentElement.getNextSibling();
                if (!(sibling instanceof LeafPsiElement)) {
                    return null;
                }
                return ((LeafPsiElement)sibling).getElementType();
            }

            @Override
            public void visitInputParameter(@NotNull QlInputParameter o) {
                if (o == null) {
                    1.$$$reportNull$$$0(26);
                }
                QlAnnotator.setHighlighting(o, holder, QlSyntaxHighlighter.PARAMETER);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 24: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 19: 
                    case 23: 
                    case 25: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "identifier";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jpa/ql/editor/QlAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAliasDefinition";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionCallExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDatetimeFunctionExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIndicesExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAggregateExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExtractExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNumericFunctionExpression";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTruncFunctionExpression";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitStringFunctionExpression";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCoalesceExpression";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNullifExpression";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCastExpression";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayFunctionExpression";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElementExpression";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDateTimeLiteral";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOverlayFunctionExpression";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFormatFunctionExpression";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 18: 
                    case 19: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isVariableDeclaredInQlFile";
                        break;
                    }
                    case 20: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDeclarationsInQlFile";
                        break;
                    }
                    case 21: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isJvmClassOrPackage";
                        break;
                    }
                    case 22: 
                    case 23: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSegmentBeforeFirstDot";
                        break;
                    }
                    case 24: 
                    case 25: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSegmentAfterFirstDot";
                        break;
                    }
                    case 26: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitInputParameter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void highlightFunctionName(@NotNull QlExpression o, @NotNull AnnotationHolder holder) {
        PsiElement nameToken;
        if (o == null) {
            QlAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            QlAnnotator.$$$reportNull$$$0(3);
        }
        if ((nameToken = o.getFirstChild()) != null) {
            QlAnnotator.setHighlighting(nameToken, holder, QlSyntaxHighlighter.FUNCTION);
        }
    }

    private static void setHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder, TextAttributesKey key) {
        if (element == null) {
            QlAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            QlAnnotator.$$$reportNull$$$0(5);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(key).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/ql/editor/QlAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightFunctionName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlighting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

