/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.actions;

import com.intellij.httpClient.actions.HttpClientActionsUsage;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class NewHttpRequestFileAction
extends CreateFileFromTemplateAction
implements DumbAware {
    NewHttpRequestFileAction() {
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        if (project == null) {
            NewHttpRequestFileAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            NewHttpRequestFileAction.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            NewHttpRequestFileAction.$$$reportNull$$$0(2);
        }
        builder.setTitle(RestClientBundle.message("http.request.new.file", new Object[0]));
        HttpRequestFileType fileType = HttpRequestFileType.INSTANCE;
        builder.addKind(fileType.getName(), fileType.getIcon(), fileType.getName() + "." + fileType.getDefaultExtension());
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            NewHttpRequestFileAction.$$$reportNull$$$0(3);
        }
        return RestClientBundle.message("http.request.action.name", new Object[0]);
    }

    protected void postProcess(@NotNull PsiFile createdElement, String templateName, Map<String, String> customProperties) {
        Document document;
        if (createdElement == null) {
            NewHttpRequestFileAction.$$$reportNull$$$0(4);
        }
        if ((document = createdElement.getViewProvider().getDocument()) == null) {
            return;
        }
        final Disposable disposable = Disposer.newDisposable();
        final Project project = createdElement.getProject();
        document.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                HttpClientActionsUsage.ModificationType type = event.getDocument().getTextLength() == 0 ? HttpClientActionsUsage.ModificationType.CONTENT_CLEARED : (event.isWholeTextReplaced() ? HttpClientActionsUsage.ModificationType.CONTENT_REPLACED : HttpClientActionsUsage.ModificationType.OTHER);
                HttpClientActionsUsage.NEW_FILE_MODIFIED.log(project, (Object)type);
                Disposer.dispose((Disposable)disposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/httpClient/http/request/actions/NewHttpRequestFileAction$1", "documentChanged"));
            }
        }, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/actions/NewHttpRequestFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

