/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.application.facet.framework;

import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.framework.JavaeeFrameworkVersionBase;
import com.intellij.javaee.framework.JavaeeProfileBasedFrameworkAvailabilityCondition;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaeeApplicationFrameworkVersion
extends JavaeeFrameworkVersionBase {
    private final JavaeeVersion myVersion;

    public JavaeeApplicationFrameworkVersion(JavaeeVersion version) {
        this.myVersion = version;
    }

    public static List<JavaeeApplicationFrameworkVersion> getAllVersions() {
        ArrayList<JavaeeApplicationFrameworkVersion> versions = new ArrayList<JavaeeApplicationFrameworkVersion>();
        for (JavaeeVersion version : JavaeeVersion.values()) {
            versions.add(new JavaeeApplicationFrameworkVersion(version));
        }
        return versions;
    }

    @NotNull
    public String getId() {
        String string = this.myVersion.getId();
        if (string == null) {
            JavaeeApplicationFrameworkVersion.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myVersion.getPresentableName();
        if (string == null) {
            JavaeeApplicationFrameworkVersion.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public FrameworkAvailabilityCondition getAvailabilityCondition() {
        return new JavaeeProfileBasedFrameworkAvailabilityCondition(this.myVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myVersion == ((JavaeeApplicationFrameworkVersion)o).myVersion;
    }

    public int hashCode() {
        return this.myVersion.hashCode();
    }

    @Override
    @NotNull
    public ConfigFileVersion getDescriptorVersion() {
        ConfigFileVersion configFileVersion = switch (this.myVersion) {
            default -> throw new IncompatibleClassChangeError();
            case JavaeeVersion.J2EE_1_4 -> DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_1_4;
            case JavaeeVersion.JAVAEE_5 -> DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_5_0;
            case JavaeeVersion.JAVAEE_6 -> DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_6_0;
            case JavaeeVersion.JAVAEE_7 -> DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_7_0;
            case JavaeeVersion.JAVAEE_8 -> DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_8_0;
            case JavaeeVersion.JAKARTA_9 -> DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_9_0;
            case JavaeeVersion.JAKARTA_10 -> DeploymentDescriptorsConstants.APPLICATION_XML_VERSION_10_0;
        };
        if (configFileVersion == null) {
            JavaeeApplicationFrameworkVersion.$$$reportNull$$$0(2);
        }
        return configFileVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/application/facet/framework/JavaeeApplicationFrameworkVersion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorVersion";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

