/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.javaee;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfiguration;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.project.PackagingModifiableModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.FacetBasedPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

public abstract class JavaeeProjectDataService<E extends ExternalEntityData, FACET extends JavaeeFacet<FACET_CONFIG>, FACET_CONFIG extends JavaeeFacetConfiguration, FACET_TYPE extends JavaeeFacetType<FACET, FACET_CONFIG>>
extends AbstractProjectDataService<E, Artifact> {
    private static final Logger LOG = Logger.getInstance(JavaeeProjectDataService.class);
    private static final boolean USE_PROJECT_OUTPUT_PATH = Boolean.getBoolean("idea.gradle.artifact.use.project.output");
    private final FACET_TYPE myJavaeeFacetType;

    public JavaeeProjectDataService(FACET_TYPE javaeeFacetType) {
        this.myJavaeeFacetType = javaeeFacetType;
    }

    protected abstract void configureJavaeeModule(@NotNull ModuleData var1, @NotNull E var2, @NotNull IdeModifiableModelsProvider var3);

    protected abstract ArtifactType getArtifactType(boolean var1);

    protected abstract Collection<String> resolveArtifactNames(@NotNull ModuleData var1, @NotNull E var2);

    public FACET_TYPE getJavaeeFacetType() {
        return this.myJavaeeFacetType;
    }

    public void importData(@NotNull Collection<? extends DataNode<E>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(2);
        }
        if (this.myJavaeeFacetType == null) {
            return;
        }
        for (DataNode<E> node : toImport) {
            Object parentNodeData;
            DataNode parentNode;
            ExternalEntityData data = (ExternalEntityData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)data.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            ModuleData moduleData = (ModuleData)parentNodeData;
            this.configureJavaeeModule(moduleData, data, modelsProvider);
        }
    }

    @NotNull
    public Computable<Collection<Artifact>> computeOrphanData(@NotNull Collection<? extends DataNode<E>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(3);
        }
        if (projectData == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(6);
        }
        Computable computable = () -> {
            GradleArtifactPropertiesProvider artifactPropertiesProvider = GradleArtifactPropertiesProvider.getInstance();
            if (artifactPropertiesProvider == null) {
                return Collections.emptyList();
            }
            SmartList orphanArtifacts = new SmartList();
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectData.getOwner());
            List linkedProjectsPaths = ContainerUtil.map((Collection)settings.getLinkedProjectsSettings(), ExternalProjectSettings::getExternalProjectPath);
            List<String> importedArtifacts = this.resolveArtifactNames(toImport);
            ModifiableArtifactModel artifactModel = ((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getModifiableArtifactModel();
            for (Artifact artifact : artifactModel.getAllArtifactsIncludingInvalid()) {
                String externalProjectPath;
                Object state;
                if (!JavaeeProjectDataService.isGradleJeeArtifact(artifact, this.myJavaeeFacetType) || !((state = artifact.getProperties((ArtifactPropertiesProvider)artifactPropertiesProvider).getState()) instanceof GradleArtifactProperties) || linkedProjectsPaths.contains(externalProjectPath = ((GradleArtifactProperties)((Object)((Object)state))).getExternalProjectPath()) && (!projectData.getLinkedExternalProjectPath().equals(externalProjectPath) || importedArtifacts.contains(artifact.getName()))) continue;
                orphanArtifacts.add(artifact);
            }
            return orphanArtifacts;
        };
        if (computable == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(7);
        }
        return computable;
    }

    public void removeData(@NotNull Computable<? extends Collection<? extends Artifact>> toRemove, @NotNull Collection<? extends DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(8);
        }
        if (toIgnore == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(9);
        }
        if (projectData == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(10);
        }
        if (project == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(11);
        }
        if (modelsProvider == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(12);
        }
        List<String> ignoredArtifacts = this.resolveArtifactNames(toIgnore);
        SmartList artifactsToRemove = new SmartList();
        artifactsToRemove.addAll((Collection)toRemove.compute());
        ModifiableArtifactModel artifactModel = ((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getModifiableArtifactModel();
        for (Artifact artifact : artifactsToRemove) {
            LOG.debug("Artifact '" + artifact.getName() + "' will be removed by " + ((Object)((Object)this)).getClass().getSimpleName());
            artifactModel.removeArtifact(artifact);
        }
        for (Artifact artifact : JavaeeProjectDataService.getArtifactList(artifactModel, this.myJavaeeFacetType)) {
            if (!ignoredArtifacts.contains(artifact.getName())) continue;
            LOG.debug("Ignored Artifact '" + artifact.getName() + "' will be removed by " + ((Object)((Object)this)).getClass().getSimpleName());
            artifactModel.removeArtifact(artifact);
        }
        if (this.myJavaeeFacetType != null) {
            SmartList orphanFacets = new SmartList();
            String gradleFacetNamePrefix = this.getFacetNamePrefix((FacetType<?, ?>)this.myJavaeeFacetType);
            NotNullLazyValue gradleArtifactsFinder = NotNullLazyValue.lazy((Supplier)new GradleArtifactsFinder(artifactModel, (JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration>)((Object)this.myJavaeeFacetType)));
            List modules = ContainerUtil.filter((Object[])modelsProvider.getModules(), module -> projectData.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module)));
            PackagingElementResolvingContext context = ((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getPackagingElementResolvingContext();
            for (Module module2 : modules) {
                for (JavaeeFacet javaeeFacet : context.getFacetsProvider().getFacetsByType(module2, this.myJavaeeFacetType.getId())) {
                    if (!javaeeFacet.getName().startsWith(gradleFacetNamePrefix)) continue;
                    boolean used = false;
                    List artifacts = (List)gradleArtifactsFinder.getValue();
                    for (Artifact artifact : artifacts) {
                        if (!JavaeeProjectDataService.isUsedIn(javaeeFacet, artifact, context)) continue;
                        used = true;
                        break;
                    }
                    if (used) continue;
                    orphanFacets.add(javaeeFacet);
                }
            }
            for (JavaeeFacet orphanFacet : orphanFacets) {
                if (orphanFacet.isDisposed()) continue;
                Module orphanFacetModule = orphanFacet.getModule();
                ModifiableFacetModel modifiableFacetModel = modelsProvider.getModifiableFacetModel(orphanFacetModule);
                LOG.debug("Facet '" + orphanFacet.getName() + "' will be removed by " + ((Object)((Object)this)).getClass().getSimpleName());
                modifiableFacetModel.removeFacet((Facet)orphanFacet);
            }
        }
    }

    protected FACET createOrReplaceFacet(ModifiableFacetModel facetModel, Module module, String facetName, FACET_TYPE javaeeFacetType) {
        Collection facets = facetModel.getFacetsByType(javaeeFacetType.getId());
        for (JavaeeFacet facet : facets) {
            if (!facetName.equals(facet.getName())) continue;
            facetModel.removeFacet((Facet)facet);
            break;
        }
        JavaeeFacet facet = (JavaeeFacet)javaeeFacetType.createFacet(module, facetName, (FacetConfiguration)((JavaeeFacetConfiguration)javaeeFacetType.createDefaultConfiguration()), null);
        facetModel.addFacet((Facet)facet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
        return (FACET)facet;
    }

    protected String getFacetNamePrefix(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(13);
        }
        return facetType.getPresentableName() + " " + GradleConstants.SYSTEM_ID.getReadableName();
    }

    @NotNull
    protected ModifiableArtifact prepareArtifact(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Module module, @NotNull String artifactName, @NotNull Jar jar, @NotNull ArtifactType artifactType) {
        String outputPath;
        GradleArtifactPropertiesProvider propertiesProvider;
        CompositePackagingElement rootElement;
        ModifiableArtifact modifiableArtifact;
        ModifiableArtifactModel artifactModel;
        Artifact artifact;
        if (modelsProvider == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(14);
        }
        if (module == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(15);
        }
        if (artifactName == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(16);
        }
        if (jar == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(17);
        }
        if (artifactType == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(18);
        }
        if ((artifact = (artifactModel = ((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getModifiableArtifactModel()).findArtifact(artifactName)) == null || !artifact.getArtifactType().equals(artifactType) || artifact.getExternalSource() == null) {
            if (artifact != null) {
                artifactModel.removeArtifact(artifact);
            }
            modifiableArtifact = artifactModel.addArtifact(artifactName, artifactType, artifactType.createRootElement(artifactName), ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
            rootElement = modifiableArtifact.getRootElement();
        } else {
            modifiableArtifact = artifactModel.getOrCreateModifiableArtifact(artifact);
            rootElement = modifiableArtifact.getRootElement();
            rootElement.removeAllChildren();
        }
        if (rootElement instanceof ArchivePackagingElement) {
            ArchivePackagingElement archivePackagingElement = (ArchivePackagingElement)rootElement;
            archivePackagingElement.rename(jar.getName());
        }
        boolean isExploded = false;
        if (artifactType instanceof JavaeeArtifactTypeBase) {
            boolean bl = isExploded = !((JavaeeArtifactTypeBase)artifactType).isArchive();
        }
        if ((propertiesProvider = GradleArtifactPropertiesProvider.getInstance()) != null) {
            GradleArtifactProperties gradleArtifactProperties = new GradleArtifactProperties();
            gradleArtifactProperties.setExternalProjectPath(ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
            gradleArtifactProperties.setBuildByTaskPath(JavaeeProjectDataService.buildFullTaskPath(module, this.getArtifactTaskName(isExploded)));
            gradleArtifactProperties.setCleanByTaskPath(JavaeeProjectDataService.buildFullTaskPath(module, "clean" + StringUtil.capitalize((String)this.getArtifactTaskName(isExploded))));
            modifiableArtifact.setProperties((ArtifactPropertiesProvider)propertiesProvider, (ArtifactProperties)gradleArtifactProperties);
        }
        if ((outputPath = this.getArtifactOutputPath(artifactName, module, jar, isExploded)) != null) {
            modifiableArtifact.setOutputPath(outputPath);
            if (isExploded) {
                this.addManifest(modifiableArtifact, outputPath, jar);
            }
        }
        ModifiableArtifact modifiableArtifact2 = modifiableArtifact;
        if (modifiableArtifact2 == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(19);
        }
        return modifiableArtifact2;
    }

    protected static String buildFullTaskPath(Module module, String taskName) {
        GradleModuleData gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
        if (gradleModuleData == null) {
            LOG.warn("Failed to find Gradle module data for module [" + module.getName() + "]");
            return taskName;
        }
        return gradleModuleData.getTaskPath(taskName, true);
    }

    protected abstract String getArtifactTaskName(boolean var1);

    @Nullable
    protected String getArtifactOutputPath(String artifactName, Module module, Jar jar, boolean isExploded) {
        File outputFile;
        if (jar.getArchivePath() != null && !USE_PROJECT_OUTPUT_PATH) {
            String path = isExploded ? jar.getArchivePath().getParent() + "/exploded/" + jar.getArchivePath().getName() : jar.getArchivePath().getParent();
            return FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path));
        }
        String defaultArtifactOutputPath = ArtifactUtil.getDefaultArtifactOutputPath((String)artifactName, (Project)module.getProject());
        if (defaultArtifactOutputPath != null && (outputFile = new File(defaultArtifactOutputPath).getParentFile()) != null) {
            String outputPath = outputFile.getName().equals(module.getName()) ? outputFile.getPath() : outputFile.getPath() + "/" + StringUtil.trimEnd((String)module.getName(), (String)"_main");
            String path = isExploded ? outputPath + "/exploded/" + jar.getName() : outputPath;
            return FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path));
        }
        return null;
    }

    protected void addManifest(@NotNull ModifiableArtifact modifiableArtifact, @NotNull String outputPath, @NotNull Jar jar) {
        if (modifiableArtifact == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(20);
        }
        if (outputPath == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(21);
        }
        if (jar == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(22);
        }
        if (jar.getManifestContent() == null) {
            return;
        }
        ArtifactProperties<GradleArtifactProperties> artifactProperties = JavaeeProjectDataService.getGradleArtifactProperties((Artifact)modifiableArtifact);
        if (artifactProperties == null) {
            return;
        }
        GradleArtifactProperties artifactPropertiesState = (GradleArtifactProperties)((Object)artifactProperties.getState());
        assert (artifactPropertiesState != null);
        artifactPropertiesState.setManifest(Base64.getEncoder().encodeToString(jar.getManifestContent().getBytes(StandardCharsets.UTF_8)));
        modifiableArtifact.setProperties((ArtifactPropertiesProvider)Objects.requireNonNull(GradleArtifactPropertiesProvider.getInstance()), artifactProperties);
        String manifestPath = FileUtil.toSystemIndependentName((String)(outputPath + "/META-INF/MANIFEST.MF"));
        PackagingElementFactory.getInstance().addFileCopy(modifiableArtifact.getRootElement(), ManifestFileUtil.MANIFEST_DIR_NAME, manifestPath, ManifestFileUtil.MANIFEST_FILE_NAME, true);
    }

    protected String resolveArtifactName(@NotNull ModuleData moduleData, @NotNull String archiveName, boolean isExploded) {
        if (moduleData == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(23);
        }
        if (archiveName == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(24);
        }
        String artifactNamePrefix = GradleConstants.SYSTEM_ID.getReadableName();
        StringBuilder buf = new StringBuilder(artifactNamePrefix);
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(" : ").append(moduleData.getGroup());
        }
        String artifactName = this.adjustName(buf.toString(), archiveName);
        return isExploded ? artifactName + " (exploded)" : artifactName;
    }

    @NotNull
    protected String formatModuleArchiveFileName(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(25);
        }
        StringBuilder buf = new StringBuilder();
        if (!StringUtil.isEmpty((String)moduleData.getGroup())) {
            buf.append(moduleData.getGroup()).append('-');
        }
        buf.append(StringUtil.trimEnd((String)moduleData.getExternalName(), (String)":main"));
        if (!StringUtil.isEmpty((String)moduleData.getVersion()) && !"unspecified".equals(moduleData.getVersion())) {
            buf.append('-').append(moduleData.getVersion());
        }
        String string = PathUtilRt.suggestFileName((String)buf.append(".jar").toString(), (boolean)true, (boolean)true);
        if (string == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(26);
        }
        return string;
    }

    protected String adjustName(@NotNull String namePrefix, @Nullable String archiveName) {
        if (namePrefix == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(27);
        }
        String buffer = namePrefix + (String)(StringUtil.isEmpty((String)archiveName) ? "" : " : " + archiveName);
        return buffer.replace('/', '_');
    }

    @Nullable
    public static ArtifactProperties<GradleArtifactProperties> getGradleArtifactProperties(@NotNull Artifact artifact) {
        GradleArtifactPropertiesProvider artifactPropertiesProvider;
        if (artifact == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(28);
        }
        if ((artifactPropertiesProvider = GradleArtifactPropertiesProvider.getInstance()) == null) {
            return null;
        }
        ArtifactProperties artifactProperties = artifact.getProperties((ArtifactPropertiesProvider)artifactPropertiesProvider);
        if (artifactProperties == null || !(artifactProperties.getState() instanceof GradleArtifactProperties)) {
            return null;
        }
        return artifactProperties;
    }

    private static boolean isUsedIn(@NotNull JavaeeFacet javaeeFacet, @NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context) {
        if (javaeeFacet == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(29);
        }
        if (artifact == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(30);
        }
        if (context == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(31);
        }
        Ref result = Ref.create((Object)Boolean.FALSE);
        ArtifactUtil.processPackagingElements((Artifact)artifact, null, element -> {
            Facet facet;
            if (element instanceof FacetBasedPackagingElement && javaeeFacet.equals((Object)(facet = ((FacetBasedPackagingElement)element).findFacet(context)))) {
                result.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }, (PackagingElementResolvingContext)context, (boolean)true);
        return (Boolean)result.get();
    }

    @NotNull
    private List<String> resolveArtifactNames(@NotNull Collection<? extends DataNode<E>> nodes) {
        if (nodes == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(32);
        }
        SmartList artifacts = new SmartList();
        for (DataNode<E> node : nodes) {
            Object parentNodeData;
            DataNode parentNode;
            ExternalEntityData earConfigurationModelData = (ExternalEntityData)node.getData();
            if (!GradleConstants.SYSTEM_ID.equals((Object)earConfigurationModelData.getOwner()) || (parentNode = node.getParent()) == null || !((parentNodeData = parentNode.getData()) instanceof ModuleData)) continue;
            ModuleData moduleData = (ModuleData)parentNodeData;
            artifacts.addAll(this.resolveArtifactNames(moduleData, earConfigurationModelData));
        }
        SmartList smartList = artifacts;
        if (smartList == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(33);
        }
        return smartList;
    }

    private static boolean isGradleJeeArtifact(@NotNull Artifact artifact, @NotNull JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> javaeeFacetType) {
        if (artifact == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(34);
        }
        if (javaeeFacetType == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(35);
        }
        boolean isOurType = false;
        for (ArtifactType artifactType : javaeeFacetType.getArtifactTypes()) {
            isOurType = isOurType || artifact.getArtifactType().equals(artifactType);
        }
        return isOurType && artifact.getName().startsWith(GradleConstants.SYSTEM_ID.getReadableName());
    }

    @NotNull
    private static List<Artifact> getArtifactList(ModifiableArtifactModel artifactModel, JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> javaeeFacetType) {
        SmartList result = new SmartList();
        for (Artifact artifact : artifactModel.getAllArtifactsIncludingInvalid()) {
            if (!JavaeeProjectDataService.isGradleJeeArtifact(artifact, javaeeFacetType)) continue;
            result.add(artifact);
        }
        SmartList smartList = result;
        if (smartList == null) {
            JavaeeProjectDataService.$$$reportNull$$$0(36);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 19, 26, 33, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 7: 
            case 19: 
            case 26: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/javaee/JavaeeProjectDataService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableArtifact";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 28: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeFacet";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeFacetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/javaee/JavaeeProjectDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOrphanData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareArtifact";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "formatModuleArchiveFileName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifactNames";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeOrphanData";
                break;
            }
            case 7: 
            case 19: 
            case 26: 
            case 33: 
            case 36: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFacetNamePrefix";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "prepareArtifact";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addManifest";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "formatModuleArchiveFileName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "adjustName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getGradleArtifactProperties";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isUsedIn";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactNames";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isGradleJeeArtifact";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 19, 26, 33, 36 -> new IllegalStateException(string);
        };
    }

    private static final class GradleArtifactsFinder
    implements Supplier<List<? extends Artifact>> {
        private final ModifiableArtifactModel myArtifactModel;
        private final JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> myJavaeeFacetType;

        GradleArtifactsFinder(ModifiableArtifactModel artifactModel, JavaeeFacetType<? extends JavaeeFacet, ? extends JavaeeFacetConfiguration> javaeeFacetType) {
            this.myArtifactModel = artifactModel;
            this.myJavaeeFacetType = javaeeFacetType;
        }

        @Override
        @NotNull
        public List<? extends Artifact> get() {
            List<Artifact> list = JavaeeProjectDataService.getArtifactList(this.myArtifactModel, this.myJavaeeFacetType);
            if (list == null) {
                GradleArtifactsFinder.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/javaee/JavaeeProjectDataService$GradleArtifactsFinder", "get"));
        }
    }
}

