/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.javaee.appServers.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeStartupPolicy;
import com.intellij.javaee.oss.server.WslStartupExecutable;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.javaee.oss.server.WslSupportUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.jetbrains.idea.tomcat.server.TomcatWslSupportUtilKt;

public class TomcatStartupPolicy
extends JavaeeStartupPolicy<TomcatLocalModel> {
    private static final Logger LOG = Logger.getInstance(TomcatStartupPolicy.class);
    @NonNls
    protected static final String TEMP_FILE_NAME = "temp";
    @NonNls
    protected static final String BIN_DIR = "bin";
    @NonNls
    private static final String CATALINA_TMPDIR_ENV_PROPERTY = "CATALINA_TMPDIR";
    @NonNls
    private static final String JAVA_HOME_ENV_PROPERTY = "JAVA_HOME";
    @NonNls
    private static final String JRE_HOME_ENV_PROPERTY = "JRE_HOME";
    @NonNls
    private static final String JAR_PARAMETER = "-jar";
    @NonNls
    public static final String CLASSPATH_PARAMETER = "-cp";
    @NonNls
    public static final String RMI_HOST_JAVA_OPT = "java.rmi.server.hostname";

    protected ExecutableObject getDefaultStartupScript(TomcatLocalModel serverModel, boolean debug) {
        try {
            return new ExecutableCreator(serverModel, "run", "start"){

                @Override
                protected List<String> getCustomJavaOptions(boolean isWsl) throws ExecutionException {
                    TomcatLocalModel tomcatModel = this.getTomcatModel();
                    if (tomcatModel.isUseJmx()) {
                        ArrayList<String> result = new ArrayList<String>();
                        result.add("-Dcom.sun.management.jmxremote=");
                        result.add("-Dcom.sun.management.jmxremote.port=" + tomcatModel.JNDI_PORT);
                        result.add("-Dcom.sun.management.jmxremote.ssl=false");
                        if (isWsl) {
                            result.add("-Dcom.sun.management.jmxremote.authenticate=false");
                            result.add("-Dcom.sun.management.jmxremote.local.only=false");
                            result.add("-Dcom.sun.management.jmxremote.registry.ssl=false");
                        }
                        File accessFile = tomcatModel.getAccessFile();
                        File passwordFile = tomcatModel.getPasswordFile();
                        if (accessFile == null || passwordFile == null) {
                            result.add("-Dcom.sun.management.jmxremote.authenticate=false");
                        } else {
                            try {
                                result.add("-Dcom.sun.management.jmxremote.password.file=" + passwordFile.getCanonicalPath());
                                result.add("-Dcom.sun.management.jmxremote.access.file=" + accessFile.getCanonicalPath());
                            }
                            catch (IOException e) {
                                throw new ExecutionException((Throwable)e);
                            }
                        }
                        if (tomcatModel.getVmArgument(TomcatStartupPolicy.RMI_HOST_JAVA_OPT) == null) {
                            result.add("-Djava.rmi.server.hostname=127.0.0.1");
                        }
                        if (tomcatModel.isTomEE()) {
                            if (tomcatModel.versionHigher(7, 0, 68)) {
                                result.add("-Dtomee.serialization.class.whitelist=");
                                result.add("-Dtomee.serialization.class.blacklist=-");
                            }
                            if (tomcatModel.versionHigher(8, 0, 28)) {
                                result.add("-Dtomee.remote.support=true");
                                result.add("-Dopenejb.system.apps=true");
                            }
                        }
                        return result;
                    }
                    return super.getCustomJavaOptions(isWsl);
                }
            }.createExecutable();
        }
        catch (ExecutionException | RuntimeConfigurationException e) {
            return null;
        }
    }

    protected ExecutableObject getDefaultShutdownScript(TomcatLocalModel serverModel, boolean debug) {
        try {
            return new ExecutableCreator(serverModel, "stop", "stop").createExecutable();
        }
        catch (ExecutionException | RuntimeConfigurationException e) {
            return null;
        }
    }

    protected void getStartupParameters(JavaeeParameters params, TomcatLocalModel model, boolean debug) {
        throw new UnsupportedOperationException();
    }

    protected void getShutdownParameters(JavaeeParameters params, TomcatLocalModel model, boolean debug) {
        throw new UnsupportedOperationException();
    }

    protected List<EnvironmentVariable> getEnvironmentVariables(TomcatLocalModel tomcatModel) {
        try {
            ArrayList<EnvironmentVariable> vars = new ArrayList<EnvironmentVariable>();
            vars.add(new EnvironmentVariable("CATALINA_HOME", tomcatModel.getHomeDirectory(), true));
            vars.add(new EnvironmentVariable("CATALINA_BASE", tomcatModel.getBaseDirectoryPath(), true));
            String tmpDir = EnvironmentUtil.getValue((String)CATALINA_TMPDIR_ENV_PROPERTY);
            if (tmpDir == null) {
                vars.add(new EnvironmentVariable(CATALINA_TMPDIR_ENV_PROPERTY, TomcatStartupPolicy.getCatalinaTempDirectory(tomcatModel), true));
            }
            String[] javaEnvVars = new String[]{JAVA_HOME_ENV_PROPERTY, JRE_HOME_ENV_PROPERTY};
            String jrePath = tomcatModel.getJrePath();
            for (String varName : javaEnvVars) {
                TomcatStartupPolicy.setupJavaPath(vars, varName, jrePath);
            }
            return vars;
        }
        catch (RuntimeConfigurationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static String getCatalinaTempDirectory(TomcatLocalModel tomcatModel) throws RuntimeConfigurationException {
        File tempDir = new File(tomcatModel.getSourceBaseDirectoryPath(), TEMP_FILE_NAME);
        if (!tempDir.exists() && !(tempDir = new File(tomcatModel.getBaseDirectoryPath(), TEMP_FILE_NAME)).exists()) {
            FileUtil.createDirectory((File)tempDir);
        }
        return tempDir.getAbsolutePath();
    }

    @NonNls
    public static String getDefaultCatalinaFileName() {
        return SystemInfo.isWindows ? "catalina.bat" : "catalina.sh";
    }

    public static String getCatalinaFileName(@NotNull String tomcatPath) {
        if (tomcatPath == null) {
            TomcatStartupPolicy.$$$reportNull$$$0(0);
        }
        if (WslSupportUtil.isWslPath((String)tomcatPath)) {
            return "catalina.sh";
        }
        return SystemInfo.isWindows ? "catalina.bat" : "catalina.sh";
    }

    private static void setupJavaPath(List<EnvironmentVariable> vars, String varName, String jrePath) {
        if (jrePath != null) {
            vars.add(new EnvironmentVariable(varName, jrePath, true));
        } else {
            String envValue = EnvironmentUtil.getValue((String)varName);
            if (envValue != null) {
                vars.add(new EnvironmentVariable(varName, envValue, true));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tomcatPath", "org/jetbrains/idea/tomcat/TomcatStartupPolicy", "getCatalinaFileName"));
    }

    private static class ExecutableCreator {
        private final TomcatLocalModel myTomcatModel;
        private final File myBinDir;
        private final File myCatalinaScriptFile;
        private final String myScriptCommand;
        private final String myJavaCommand;

        ExecutableCreator(TomcatLocalModel model, @NonNls String scriptCommand, @NonNls String javaCommand) throws RuntimeConfigurationException {
            this.myScriptCommand = scriptCommand;
            this.myJavaCommand = javaCommand;
            this.myTomcatModel = model;
            this.myBinDir = new File(new File(this.myTomcatModel.getHomeDirectory()), TomcatStartupPolicy.BIN_DIR);
            this.myCatalinaScriptFile = new File(this.myBinDir, TomcatStartupPolicy.getCatalinaFileName(this.myTomcatModel.getHomeDirectory()));
        }

        protected final TomcatLocalModel getTomcatModel() {
            return this.myTomcatModel;
        }

        public ExecutableObject createExecutable() throws RuntimeConfigurationException, ExecutionException {
            if (this.myCatalinaScriptFile.exists()) {
                return this.createScriptExecutable();
            }
            return this.createJavaExecutable();
        }

        private ExecutableObject createScriptExecutable() throws ExecutionException {
            if (WslSupportUtil.isWslPath((String)this.myCatalinaScriptFile.getAbsolutePath())) {
                return new WslStartupExecutable(this.myCatalinaScriptFile, this.myScriptCommand, this.getCustomJavaOptions(true), this.getTomcatModel().getProject(), TomcatBundle.message("tomcat.wsl.startup.script", new Object[0])){

                    protected Map<String, String> patchEnvVariables(Map<String, String> envVariables, String scriptPath) {
                        Map<String, String> wslVariables = TomcatWslSupportUtilKt.toWslEnvVariables(envVariables);
                        return super.patchEnvVariables(wslVariables, scriptPath);
                    }
                };
            }
            return new TomcatDefaultStartupExecutable(this.myCatalinaScriptFile, this.myScriptCommand, this.getCustomJavaOptions(false));
        }

        private ExecutableObject createJavaExecutable() throws RuntimeConfigurationException, ExecutionException {
            Sdk jre = this.getTomcatModel().getJre();
            @NonNls String vmExecutablePath = jre == null ? "java" : ((JavaSdkType)jre.getSdkType()).getVMExecutablePath(jre);
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList(vmExecutablePath, "-Dcatalina.base=" + this.myTomcatModel.getBaseDirectoryPath(), "-Dcatalina.home=" + this.myTomcatModel.getHomeDirectory(), "-Djava.io.tmpdir=" + TomcatStartupPolicy.getCatalinaTempDirectory(this.myTomcatModel)));
            args.addAll(this.getCustomJavaOptions(false));
            String bootstrapJarPath = new File(this.myBinDir, "bootstrap.jar").getAbsolutePath();
            if (this.myTomcatModel.isVersion7OrHigher()) {
                args.addAll(Arrays.asList(TomcatStartupPolicy.CLASSPATH_PARAMETER, bootstrapJarPath + File.pathSeparator + new File(this.myBinDir, "tomcat-juli.jar").getAbsolutePath(), "org.apache.catalina.startup.Bootstrap"));
            } else {
                args.addAll(Arrays.asList(TomcatStartupPolicy.JAR_PARAMETER, bootstrapJarPath));
            }
            return new ColoredCommandLineExecutableObject(ArrayUtilRt.toStringArray(args), this.myJavaCommand){

                protected GeneralCommandLine createCommandLine(String[] parameters, Map<String, String> envVariables) {
                    String javaOptions = envVariables.get("JAVA_OPTS");
                    if (javaOptions != null) {
                        ArrayList<String> newParameters = new ArrayList<String>();
                        for (String parameter : parameters) {
                            if (TomcatStartupPolicy.JAR_PARAMETER.equals(parameter) || TomcatStartupPolicy.CLASSPATH_PARAMETER.equals(parameter)) {
                                newParameters.addAll(StringUtil.splitHonorQuotes((String)javaOptions, (char)' '));
                            }
                            newParameters.add(parameter);
                        }
                        parameters = ArrayUtilRt.toStringArray(newParameters);
                    }
                    return super.createCommandLine(parameters, envVariables);
                }
            };
        }

        protected List<String> getCustomJavaOptions(boolean isWsl) throws ExecutionException {
            return Collections.emptyList();
        }
    }

    private static class TomcatDefaultStartupExecutable
    extends ColoredCommandLineExecutableObject {
        private final List<String> myCustomOptions;

        private TomcatDefaultStartupExecutable(File catalinaScriptFile, String scriptCommand, List<String> customOptions) {
            super(new String[]{catalinaScriptFile.getAbsolutePath(), scriptCommand}, null);
            this.myCustomOptions = customOptions;
        }

        public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
            if (!this.myCustomOptions.isEmpty()) {
                String combinedJavaOpts = WslSupportUtilKt.combineJavaOpts((String)envVariables.get("JAVA_OPTS"), this.myCustomOptions);
                envVariables.put("JAVA_OPTS", combinedJavaOpts);
            }
            return super.createProcessHandler(workingDirectory, envVariables);
        }
    }
}

