/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.annotators;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.jpa.highlighting.JpaLineMarkersDetector;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.NamedQueryBaseImpl;
import com.intellij.jpa.model.common.persistence.mapping.NamedQuery;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.jpa.SpringDataJpaUtil;
import com.intellij.spring.data.jpa.model.xml.JpaRepositories;
import com.intellij.spring.data.jpa.model.xml.JpaRepository;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

final class SpringDataRepositoryUastAnnotator
extends RelatedItemLineMarkerProvider {
    private static final String IMPL_POSTFIX = "Impl";

    SpringDataRepositoryUastAnnotator() {
    }

    public String getId() {
        return "SpringDataRepositoryAnnotator";
    }

    public String getName() {
        return SpringDataBundle.message("spring.data.repositories.title", new Object[0]);
    }

    public Icon getIcon() {
        return SpringApiIcons.SpringData;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringDataUtil.hasSpringDataSupport(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UElement element;
        if (psiElement == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(3);
        }
        if ((element = UastUtils.getUParentForIdentifier((PsiElement)psiElement)) instanceof UMethod) {
            SpringDataRepositoryUastAnnotator.addRepositoryMethodNavigationMarkers((UMethod)element, result);
        } else if (element instanceof UClass) {
            SpringDataRepositoryUastAnnotator.addRepositoryClassNavigationMarkers((UClass)element, result);
            SpringDataRepositoryUastAnnotator.addNamedQueryNavigationMarkers((UClass)element, result);
        }
    }

    private static void addNamedQueryNavigationMarkers(UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiClass psiClass;
        String entityName;
        if (result == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(4);
        }
        if ((entityName = (psiClass = uClass.getJavaPsi()).getName()) == null) {
            return;
        }
        EntityImpl entity = SpringDataRepositoryUastAnnotator.getEntity(uClass);
        if (entity != null && psiClass.equals(entity.getPsiClass())) {
            ArrayList queries = new ArrayList();
            queries.addAll(entity.getNamedQueries());
            queries.addAll(entity.getNamedNativeQueries());
            if (!queries.isEmpty()) {
                Set<PsiClass> relatedRepositories = null;
                for (NamedQueryBaseImpl query : queries) {
                    PsiElement sourcePsi;
                    UIdentifier uastAnchor;
                    Set<PsiMethod> methods;
                    String queryName = query.getName().getStringValue();
                    if (queryName == null || !queryName.startsWith(entityName)) continue;
                    if (relatedRepositories == null) {
                        relatedRepositories = SpringDataRepositoryUastAnnotator.getRelatedRepositories(psiClass);
                    }
                    if ((methods = SpringDataRepositoryUastAnnotator.getNamedQueryRelatedMethods(entityName, relatedRepositories, queryName)).isEmpty()) continue;
                    NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Gutter.SpringBeanMethod, (String)"String Data").setAlignment(SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT).setTargets(methods).setTooltipText(SpringDataBundle.message("goto.repository.methods.title", new Object[0]));
                    UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)query.getPsiAnnotation(), UAnnotation.class);
                    if (uAnnotation == null || (uastAnchor = uAnnotation.getUastAnchor()) == null || (sourcePsi = uastAnchor.getSourcePsi()) == null) continue;
                    result.add(builder.createLineMarkerInfo(sourcePsi));
                }
            }
        }
    }

    @NotNull
    private static Set<PsiMethod> getNamedQueryRelatedMethods(@NotNull String entityName, @NotNull Set<PsiClass> relatedRepositories, @NotNull String queryName) {
        if (entityName == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(5);
        }
        if (relatedRepositories == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(6);
        }
        if (queryName == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(7);
        }
        HashSet<PsiMethod> repositoryMethods = new HashSet<PsiMethod>();
        for (PsiClass repository : relatedRepositories) {
            for (PsiMethod method : repository.getMethods()) {
                if (!queryName.equals(entityName + "." + method.getName())) continue;
                repositoryMethods.add(method);
            }
        }
        HashSet<PsiMethod> hashSet = repositoryMethods;
        if (hashSet == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    private static Set<PsiClass> getRelatedRepositories(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(9);
        }
        HashSet<PsiClass> repositories = new HashSet<PsiClass>();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            for (CommonSpringBean repository : RepositoriesSearchUtil.getRepositoryInterfaceInheritors(module)) {
                PsiClass repositoryClass;
                Pair<PsiClass, ? extends PsiType> pair;
                if (!(repository instanceof SpringStereotypeElement) || (pair = SpringDataUtil.substituteRepositoryTypes(repositoryClass = ((SpringStereotypeElement)repository).getPsiElement())) == null || !((PsiClass)pair.first).equals(psiClass)) continue;
                repositories.add(repositoryClass);
            }
        }
        HashSet<PsiClass> hashSet = repositories;
        if (hashSet == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Nullable
    private static EntityImpl getEntity(@NotNull UClass uClass) {
        if (uClass == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(11);
        }
        PsiClass psiClass = uClass.getJavaPsi();
        JpaLineMarkersDetector.MarkerEntityClass markerEntityClass = JpaLineMarkersDetector.getMarkerEntityClass((UClass)uClass);
        if (markerEntityClass instanceof JpaLineMarkersDetector.AnnotatedMarkerEntityClass) {
            return (EntityImpl)EntityImpl.ENTITY_META.getJamElement((PsiModifierListOwner)psiClass);
        }
        if (markerEntityClass instanceof JpaLineMarkersDetector.RoleMarkerEntityClass) {
            PersistenceClassRole[] roles;
            JpaLineMarkersDetector.RoleMarkerEntityClass roleMarkerEntityClass = (JpaLineMarkersDetector.RoleMarkerEntityClass)markerEntityClass;
            for (PersistenceClassRole role : roles = roleMarkerEntityClass.getRoles()) {
                PersistentObject object = role.getPersistentObject();
                if (!(object instanceof EntityImpl)) continue;
                return (EntityImpl)object;
            }
        }
        return null;
    }

    private static void addRepositoryMethodNavigationMarkers(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiMethod psiMethod;
        Set<NamedQuery> namedQueries;
        if (uMethod == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(12);
        }
        if (result == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(13);
        }
        if (!(namedQueries = SpringDataJpaUtil.getNamedQueries(psiMethod = uMethod.getJavaPsi())).isEmpty()) {
            PsiElement identifierSourcePsi;
            Set targets = namedQueries.stream().map(query -> query.getIdentifyingPsiElement()).filter(Objects::nonNull).collect(Collectors.toSet());
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)JavaUltimateIcons.Javaee.Gutter.PersistenceEntity, (String)"String Data").setAlignment(GutterIconRenderer.Alignment.LEFT).setTargets(targets).setTooltipText(SpringDataBundle.message("goto.named.query.title", new Object[0]));
            UElement identifier = uMethod.getUastAnchor();
            if (identifier != null && (identifierSourcePsi = identifier.getSourcePsi()) != null) {
                result.add(builder.createLineMarkerInfo(identifierSourcePsi));
            }
        }
    }

    private static void addRepositoryClassNavigationMarkers(@NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiClass psiClass;
        if (uClass == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(14);
        }
        if (result == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(15);
        }
        if (SpringDataUtil.isRepository(psiClass = uClass.getJavaPsi())) {
            if (uClass.getQualifiedName() == null || psiClass instanceof PsiAnonymousClass) {
                return;
            }
            List mappedBeans = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass).resolve().getStereotypeMappedBeans();
            if (!mappedBeans.isEmpty()) {
                PsiClass customImplementation;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                Set configurationBeans = SpringJamUtils.getInstance().findStereotypeConfigurationBeans(SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass), mappedBeans, module);
                HashSet<JpaRepositories> repositories = new HashSet<JpaRepositories>();
                for (CommonModelElement configurationBean : configurationBeans) {
                    if (!(configurationBean instanceof JpaRepositories)) continue;
                    repositories.add((JpaRepositories)configurationBean);
                }
                if (!repositories.isEmpty() && (customImplementation = SpringDataRepositoryUastAnnotator.getCustomImplementation(psiClass, repositories, SpringDataRepositoryUastAnnotator.getBeanNames(mappedBeans))) != null) {
                    PsiElement identifierSourcePsi;
                    NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.Gutter.ParentBeanGutter, (String)"String Data").setAlignment(GutterIconRenderer.Alignment.LEFT).setTargets((Object[])new PsiElement[]{customImplementation}).setTooltipText(SpringDataBundle.message("goto.custom.implementation.title", customImplementation.getQualifiedName()));
                    UElement identifier = uClass.getUastAnchor();
                    if (identifier != null && (identifierSourcePsi = identifier.getSourcePsi()) != null) {
                        result.add(builder.createLineMarkerInfo(identifierSourcePsi));
                    }
                }
            }
        }
    }

    @NotNull
    private static Set<String> getBeanNames(List<JamSpringBeanPointer> mappedBeans) {
        HashSet<String> names = new HashSet<String>();
        for (JamSpringBeanPointer bean : mappedBeans) {
            names.add(bean.getName());
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @Nullable
    private static PsiClass getCustomImplementation(@NotNull PsiClass psiClass, @NotNull Set<JpaRepositories> repositoriesSets, Set<String> beanNames) {
        if (psiClass == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(17);
        }
        if (repositoriesSets == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(18);
        }
        HashSet<String> postfixes = new HashSet<String>();
        for (JpaRepositories jpaRepositories : repositoriesSets) {
            for (JpaRepository jpaRepository : jpaRepositories.getRepositories()) {
                if (!beanNames.contains(jpaRepository.getBeanName())) continue;
                if (DomUtil.hasXml(jpaRepository.getCustomImplRef())) {
                    SpringBeanPointer ref = (SpringBeanPointer)jpaRepository.getCustomImplRef().getValue();
                    return ref != null ? ref.getBeanClass() : null;
                }
                return SpringDataRepositoryUastAnnotator.getImplClass(psiClass, SpringDataRepositoryUastAnnotator.getPostfix((GenericAttributeValue<String>)jpaRepository.getRepositoryImplPostfix()));
            }
            postfixes.add(SpringDataRepositoryUastAnnotator.getPostfix((GenericAttributeValue<String>)jpaRepositories.getRepositoryImplPostfix()));
        }
        for (String postfix : postfixes) {
            PsiClass implClass = SpringDataRepositoryUastAnnotator.getImplClass(psiClass, postfix);
            if (implClass == null) continue;
            return implClass;
        }
        return null;
    }

    private static String getPostfix(GenericAttributeValue<String> implPostfix) {
        String postfix = implPostfix.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)postfix)) {
            postfix = IMPL_POSTFIX;
        }
        return postfix;
    }

    @Nullable
    private static PsiClass getImplClass(@NotNull PsiClass psiClass, @NotNull String postfix) {
        String qualifiedName;
        if (psiClass == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(19);
        }
        if (postfix == null) {
            SpringDataRepositoryUastAnnotator.$$$reportNull$$$0(20);
        }
        if ((qualifiedName = psiClass.getQualifiedName()) != null) {
            Project project = psiClass.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName + postfix, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedRepositories";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryName";
                break;
            }
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/jpa/annotators/SpringDataRepositoryUastAnnotator";
                break;
            }
            case 9: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoriesSets";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/jpa/annotators/SpringDataRepositoryUastAnnotator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedQueryRelatedMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedRepositories";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNamedQueryNavigationMarkers";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNamedQueryRelatedMethods";
                break;
            }
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedRepositories";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEntity";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoryMethodNavigationMarkers";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRepositoryClassNavigationMarkers";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCustomImplementation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getImplClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 16 -> new IllegalStateException(string);
        };
    }
}

