/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.microservices.jvm.completion.beans.BeanInjectionInsertHandler;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.microservices.jvm.inject.InjectionGeneratorHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.data.jpa.completion.RepositoryBeanWrapper;
import com.intellij.spring.data.jpa.completion.SpringRepositoryDependencyGeneratorHelper;
import com.intellij.spring.data.jpa.completion.SpringRepositoryGeneratorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B0\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J.\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/data/jpa/completion/NewRepositoryInsertHandler;", "Lcom/intellij/microservices/jvm/completion/beans/BeanInjectionInsertHandler;", "injectionTargetClassPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "entityClass", "Lcom/intellij/psi/PsiClass;", "injectedBeanName", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;Ljava/lang/String;)V", "getCommandContextScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "getInjectionGeneratorHelper", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorHelper;", "elementAtCaret", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "generatorContext", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.spring.data"})
public final class NewRepositoryInsertHandler
extends BeanInjectionInsertHandler {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> entityClass;

    public NewRepositoryInsertHandler(@NotNull SmartPsiElementPointer<PsiElement> injectionTargetClassPointer, @NotNull SmartPsiElementPointer<PsiClass> entityClass, @NotNull String injectedBeanName) {
        Intrinsics.checkNotNullParameter(injectionTargetClassPointer, (String)"injectionTargetClassPointer");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)injectedBeanName, (String)"injectedBeanName");
        super(injectionTargetClassPointer, injectedBeanName);
        this.entityClass = entityClass;
    }

    @NotNull
    protected CoroutineScope getCommandContextScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SpringRepositoryGeneratorService.Companion.getInstance(project).getScope();
    }

    @Nullable
    protected InjectionGeneratorHelper<?> getInjectionGeneratorHelper(@NotNull PsiElement elementAtCaret, @NotNull LookupElement item, @NotNull InjectionGeneratorContext generatorContext, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)elementAtCaret, (String)"elementAtCaret");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)generatorContext, (String)"generatorContext");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PsiClass psiClass = (PsiClass)this.entityClass.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass entityClass = psiClass;
        String repositoryClass = item.getObject().toString();
        PsiType psiType = JavaPsiFacade.getElementFactory((Project)elementAtCaret.getProject()).createTypeFromText(repositoryClass, elementAtCaret);
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"createTypeFromText(...)");
        PsiType repositoryType = psiType;
        return new SpringRepositoryDependencyGeneratorHelper((SmartPsiElementPointer<PsiElement>)SmartPointersKt.createSmartPointer((PsiElement)elementAtCaret), new RepositoryBeanWrapper((SmartPsiElementPointer<PsiClass>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)entityClass)), this.getInjectedBeanName(), repositoryClass, repositoryType), generatorContext);
    }
}

