/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.jpa.completion;

import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.data.jpa.SpringDateEntityUtilsKt;
import com.intellij.spring.model.actions.generate.SpringComponentGenerator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/data/jpa/completion/SpringRepositoryComponentGenerator;", "Lcom/intellij/spring/model/actions/generate/SpringComponentGenerator;", "project", "Lcom/intellij/openapi/project/Project;", "baseRepositoryClass", "Lcom/intellij/psi/PsiClass;", "ormEntity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiClass;Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;)V", "getBaseRepositoryClass", "()Lcom/intellij/psi/PsiClass;", "getOrmEntity", "()Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "prepareTemplateProperties", "Ljava/util/Properties;", "fileName", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "language", "Lcom/intellij/lang/Language;", "intellij.spring.data"})
public final class SpringRepositoryComponentGenerator
extends SpringComponentGenerator {
    @Nullable
    private final PsiClass baseRepositoryClass;
    @Nullable
    private final OrmEntity ormEntity;

    public SpringRepositoryComponentGenerator(@NotNull Project project, @Nullable PsiClass baseRepositoryClass, @Nullable OrmEntity ormEntity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, "Spring Repository");
        this.baseRepositoryClass = baseRepositoryClass;
        this.ormEntity = ormEntity;
    }

    @Nullable
    public final PsiClass getBaseRepositoryClass() {
        return this.baseRepositoryClass;
    }

    @Nullable
    public final OrmEntity getOrmEntity() {
        return this.ormEntity;
    }

    @NotNull
    protected Properties prepareTemplateProperties(@NotNull String fileName, @NotNull PsiDirectory directory, @Nullable Language language) {
        Properties properties;
        block8: {
            Fqn fqn;
            block12: {
                block11: {
                    String entityIdTypeFqn;
                    PsiClass entityClass;
                    block10: {
                        String string;
                        block9: {
                            String string2;
                            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                            properties = super.prepareTemplateProperties(fileName, directory, language);
                            if (this.baseRepositoryClass == null || this.ormEntity == null) break block8;
                            SmartPsiElementPointer smartPsiElementPointer = this.ormEntity.getClassPsiPointer();
                            Object object = smartPsiElementPointer != null ? (PsiClass)smartPsiElementPointer.getElement() : null;
                            Intrinsics.checkNotNull((Object)object);
                            entityClass = object;
                            string = SpringDateEntityUtilsKt.entityIdClass(this.ormEntity, entityClass);
                            if (string == null) break block9;
                            String it = string;
                            boolean bl = false;
                            if (language != null) {
                                TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance(this.getProject(), language);
                                string2 = templateHelper != null ? templateHelper.convertType(it, this.getProject()) : null;
                            } else {
                                string2 = it;
                            }
                            string = string2;
                            if (string2 != null) break block10;
                        }
                        string = entityIdTypeFqn = "PK";
                    }
                    if ((fqn = Fqn.Companion.ofClass(this.baseRepositoryClass)) == null) break block11;
                    Fqn[] fqnArray = new Fqn[2];
                    Intrinsics.checkNotNull((Object)Fqn.Companion.ofClass(entityClass));
                    fqnArray[1] = Fqn.Companion.ofFullName(entityIdTypeFqn);
                    if ((fqn = fqn.wrap(fqnArray)) != null) break block12;
                }
                return properties;
            }
            Fqn baseRepositoryClassFqn = fqn;
            ((Map)properties).put("BASE_CLASS", baseRepositoryClassFqn);
        }
        return properties;
    }
}

