/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlCompletionContributor;
import com.intellij.freemarker.inspections.CreateFromUsageIntentionBase;
import com.intellij.freemarker.inspections.CreateSignatureDirectiveFromUsage;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayQuery;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class CreateDynamicMethodFix
extends CreateFromUsageIntentionBase
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(CreateDynamicMethodFix.class);
    private Collection<String> myReturnType;
    private String myName;
    private boolean myProperty;
    private boolean myHasVoid;

    @Override
    protected void addDeclaration(PsiFile sourceFile, Editor sourceEditor, PsiFile targetFile, final Editor targetEditor) throws IncorrectOperationException {
        PsiClass targetClass;
        final Project project = sourceFile.getProject();
        VirtualFile virtualFile = targetFile.getVirtualFile();
        assert (virtualFile != null);
        Object[] parameterTypes = this.getParameterTypes(sourceEditor, sourceFile);
        TemplateDataLanguageMappings.getInstance((Project)project).setMapping(virtualFile, (Object)JavaLanguage.INSTANCE);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiJavaFile javaFile = (PsiJavaFile)sourceFile.getManager().findViewProvider(virtualFile).getPsi((Language)JavaLanguage.INSTANCE);
        PsiClass[] classes = javaFile.getClasses();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)javaFile.getProject()).getElementFactory();
        if (classes.length > 0) {
            targetClass = classes[0];
        } else {
            targetClass = (PsiClass)javaFile.add((PsiElement)((PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.java", "class FreeMarkerDynamicMethods { }")).getClasses()[0]);
            javaFile.addBefore(PsiParserFacade.getInstance((Project)project).createWhiteSpaceFromText("\n\n"), (PsiElement)targetClass);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(targetEditor.getDocument());
        PsiMethod method = (PsiMethod)targetClass.add((PsiElement)factory.createMethodFromText("static void " + this.myName + "(" + StringUtil.join((Object[])parameterTypes, psiType -> psiType.getCanonicalText() + " x", (String)", ") + ") {\n}", null));
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        ArrayList<Object> returnTypes = new ArrayList<Object>(this.myReturnType.size());
        for (String s : this.myReturnType) {
            try {
                returnTypes.add(factory.createTypeFromText(s, (PsiElement)targetClass));
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
        returnTypes.sort(Comparator.comparing(PsiType::getPresentableText));
        if (this.myHasVoid) {
            returnTypes.add(this.myProperty ? returnTypes.size() - 1 : 0, PsiTypes.voidType());
        }
        builder.replaceElement((PsiElement)method.getReturnTypeElement(), (Expression)(returnTypes.isEmpty() ? new ConstantNode("void") : new TypeExpression(project, returnTypes.toArray(PsiType.EMPTY_ARRAY))));
        HashSet usedNames = new HashSet();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            String paramName = CreateSignatureDirectiveFromUsage.suggestParameterName(usedNames, codeStyleManager, parameter.getType());
            builder.replaceElement((PsiElement)parameter.getNameIdentifier(), (Expression)new ConstantNode(paramName), true);
        }
        Template template = builder.buildTemplate();
        template.setToReformat(true);
        template.setToIndent(true);
        template.setToShortenLongNames(true);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(targetEditor.getDocument());
        targetEditor.getCaretModel().moveToOffset(method.getTextRange().getStartOffset());
        method.replace(PsiParserFacade.getInstance((Project)project).createWhiteSpaceFromText("\n"));
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(targetEditor.getDocument());
        TemplateManager.getInstance((Project)project).startTemplate(targetEditor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiDocumentManager.getInstance((Project)project).commitDocument(targetEditor.getDocument());
                    int offset = targetEditor.getCaretModel().getOffset();
                    PsiMethod method1 = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetClass.getContainingFile(), (int)(offset - 1), PsiMethod.class, (boolean)false);
                    if (method1 != null) {
                        try {
                            PsiClass aClass = method1.getContainingClass();
                            CreateFromUsageUtils.setupMethodBody((PsiMethod)method1, (PsiClass)aClass, (FileTemplate)FileTemplateManager.getInstance((Project)project).getCodeTemplate("Dynamic Method Body.java"));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                        CreateFromUsageUtils.setupEditor((PsiMethod)method1, (Editor)targetEditor);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/freemarker/inspections/CreateDynamicMethodFix$1", "templateFinished"));
            }
        });
    }

    @NotNull
    public String getText() {
        String string = FreeMarkerBundle.message("create.dynamic.method", this.myName);
        if (string == null) {
            CreateDynamicMethodFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = FreeMarkerBundle.message("create.dynamic.method.or.property", new Object[0]);
        if (string == null) {
            CreateDynamicMethodFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    private PsiType[] getParameterTypes(Editor editor, PsiFile file) {
        FtlQualifiedReference reference = CreateDynamicMethodFix.findQualifiedReference(editor, file);
        assert (reference != null);
        FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
        assert (qualifier != null);
        FtlPsiType type = FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlPsiType.class);
        String referenceName = reference.getReferenceName();
        assert (type != null);
        PsiType qualifierType = type.getPsiType();
        this.myReturnType = (Collection)FtlCompletionContributor.inferVariableType((Query<PsiReference>)new ArrayQuery((Object[])new PsiReference[]{reference})).first;
        FtlExpression expression = reference.getValidExpression();
        this.myHasVoid = expression.getParent() instanceof FtlInterpolation;
        if (expression instanceof FtlMethodCallExpression) {
            this.myProperty = false;
            this.myName = referenceName;
            FtlExpression[] arguments = ((FtlMethodCallExpression)expression).getArgumentList().getPositionalArguments();
            PsiType[] types = new PsiType[arguments.length + 1];
            types[0] = qualifierType;
            for (int i = 0; i < arguments.length; ++i) {
                FtlExpression argument = arguments[i];
                FtlPsiType psiType = FtlPsiUtil.asInstanceOf(argument.getType(), FtlPsiType.class);
                assert (psiType != null);
                types[i + 1] = psiType.getPsiType();
            }
            return types;
        }
        return new PsiType[]{qualifierType};
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            CreateDynamicMethodFix.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof FtlFile)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null || ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0) {
            return false;
        }
        FtlQualifiedReference reference = CreateDynamicMethodFix.findQualifiedReference(editor, psiFile);
        if (reference == null || reference.multiResolve(false).length > 0) {
            return false;
        }
        FtlReferenceQualifier qualifier = reference.getReferenceQualifier();
        if (qualifier == null) {
            return false;
        }
        FtlPsiType type = FtlPsiUtil.asInstanceOf(qualifier.getType(), FtlPsiType.class);
        if (type == null) {
            return false;
        }
        String referenceName = reference.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        this.myReturnType = (Collection)FtlCompletionContributor.inferVariableType((Query<PsiReference>)new ArrayQuery((Object[])new PsiReference[]{reference})).first;
        FtlExpression expression = reference.getValidExpression();
        this.myHasVoid = expression.getParent() instanceof FtlInterpolation;
        if (expression instanceof FtlMethodCallExpression) {
            this.myProperty = false;
            this.myName = referenceName;
            for (FtlExpression argument : ((FtlMethodCallExpression)expression).getArgumentList().getPositionalArguments()) {
                if (FtlPsiUtil.asInstanceOf(argument.getType(), FtlPsiType.class) != null) continue;
                return false;
            }
        } else {
            this.myProperty = true;
            this.myName = PropertyUtilBase.suggestGetterName((String)referenceName, null);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            CreateDynamicMethodFix.$$$reportNull$$$0(3);
        }
        this.chooseTargetFile(psiFile, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/CreateDynamicMethodFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/CreateDynamicMethodFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

