/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlDeprecatedBuiltInsInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlDeprecatedBuiltInsInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                PsiElement psiElement;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((psiElement = element.getParent()) instanceof FtlBuiltIn) {
                    FtlBuiltIn builtIn = (FtlBuiltIn)psiElement;
                    if (element.getNode().getElementType() == FtlElementTypes.IDENTIFIER) {
                        FtlBuiltInDescriptor descriptor = builtIn.getBuiltInDescriptor();
                        if (descriptor == null || !descriptor.isDeprecated()) {
                            return;
                        }
                        String replacement = descriptor.getQuickFixReplacement(builtIn);
                        String message = FreeMarkerBundle.message("deprecated.builtin.usage", builtIn.getBuiltInName());
                        if (replacement == null) {
                            holder.registerProblem(element, message, new LocalQuickFix[0]);
                        } else {
                            holder.registerProblem(element, message, new LocalQuickFix[]{new FtlReplaceDeprecatedBuiltInQuickFix(replacement)});
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$1", "visitElement"));
            }
        };
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlDeprecatedBuiltInsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "FtlDeprecatedBuiltInsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class FtlReplaceDeprecatedBuiltInQuickFix
    implements LocalQuickFix {
        private final String myReplacement;

        private FtlReplaceDeprecatedBuiltInQuickFix(String replacement) {
            this.myReplacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            String string = FreeMarkerBundle.message("replace.with.0", this.myReplacement);
            if (string == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            Document document;
            if (project == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(2);
            }
            if ((document = (psiElement = descriptor.getPsiElement()).getContainingFile().getViewProvider().getDocument()) == null) {
                return;
            }
            FtlBuiltIn builtIn = (FtlBuiltIn)psiElement.getParent();
            PsiElement parent = builtIn.getParent();
            int endOffset = (parent instanceof FtlMethodCallExpression ? parent : psiElement).getTextRange().getEndOffset();
            document.replaceString(builtIn.getQuestionToken().getTextRange().getStartOffset(), endOffset, (CharSequence)this.myReplacement);
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(3);
            }
            return currentFile;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            if (target == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(4);
            }
            return this;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            PsiElement element;
            if (project == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(6);
            }
            if ((element = previewDescriptor.getStartElement()) == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(7);
                }
                return intentionPreviewInfo;
            }
            this.applyFix(project, previewDescriptor);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                FtlReplaceDeprecatedBuiltInQuickFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$FtlReplaceDeprecatedBuiltInQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/freemarker/inspections/FtlDeprecatedBuiltInsInspection$FtlReplaceDeprecatedBuiltInQuickFix";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

